<?php 
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_classes = [BLOCK_RDG_GAME];
    $block_game = $rdgb->settings->get_block(BLOCK_RDG_GAME);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());

    $post = get_post();
    $fields = $block_game->get_block_fields($post, $rdgb);
    $type = (isset($fields['type']) && !empty($fields['type'])) ? $fields['type'] : null;
    $example = (isset($fields['example']) && !empty($fields['example'])) ? $fields['example'] : null;
?>

<?php if ($type != 'example' && $type != ''): ?>
    <?php
        $params = ['type_game' => $type, 'data' => $example];
        $block_game->get_log_debug($params);
    ?>
<?php else: ?>
    <div class="rdg-blocks">
        <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
            <div class="content">
                <div class="game">
                    <div class="game-header">
                        <span class="teams">
                            <?php if ($type == 'example'): ?>
                                <span class="team">EXAMPLE</span>
                            <?php endif; ?>
                            <span class="team"><?php echo $fields['shg_home_city'].' '.$fields['shg_home_team']; ?></span>
                            <span class="vs">vs</span>
                            <span class="team"><?php echo $fields['shg_visitor_city'].' '.$fields['shg_visitor_team']; ?></span>
                        </span>
                        <span class="date">
                            <span class="sport"><?php echo $fields['title']; ?></span>
                            <span class="separator"> • </span>
                            <span class="time"> <?php echo date('D, M j, H:i a.', strtotime($fields['shg_game_date'])); ?></span>
                        </span>
                    </div>
                    <div class="game-body">
                        <div class="content-body">
                            <div class="content-teams">
                                <div class="team-home">
                                    <div class="team">
                                        <div class="team-name">
                                        <?php #TODO: Se necesita separar el nombre del equipo de la ciudad ?>
                                            <span class="city"><?php echo $fields['shg_home_city']; ?></span>
                                            <span class="name"><?php echo $fields['shg_home_team']; ?></span>
                                            <div class="stats">
                                                <span class="pill <?php echo ($fields['shg_current_money_line_home_odds'] < 0) ? 'success' : 'info'; ?>">ML: <?php echo $fields['shg_current_money_line_home_odds']; ?></span>
                                            </div>
                                        </div>
                                        <div class="team-logo">
                                            <img src="<?php echo $fields['shg_home_local_url']; ?>" alt="">
                                        </div>
                                        <div class="team-score">
                                            <span class="score"><?php echo $fields['shg_home_score']; ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="team-separator"></div>
                                <div class="team-visitor">
                                    <div class="team">
                                        <div class="team-score">
                                            <span class="score"><?php echo $fields['shg_visitor_score']; ?></span>
                                        </div>
                                        <div class="team-logo">
                                            <img src="<?php echo $fields['shg_visitor_local_url']; ?>" alt="">
                                        </div>
                                        <div class="team-name">
                                            <span class="city"><?php echo $fields['shg_visitor_city']; ?></span>
                                            <span class="name"><?php echo $fields['shg_visitor_team']; ?></span>
                                            <div class="stats">
                                                <span class="pill <?php echo ($fields['shg_current_money_line_visitor_odds'] < 0) ? 'success' : 'info'; ?>">ML: <?php echo $fields['shg_current_money_line_visitor_odds']; ?></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!--<div class="content-stats">
                                <div class="pill">
                                    <?php #TODO: En espera de modificacion del API ?>
                                    <span class="stats-home">TOR -110</span>
                                    <span class="stats-separator"> • </span>
                                    <span class="stats-visitor">O/U 54.5</span>
                                </div>
                            </div>-->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
