<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Base
{
    public function get_block_name() {
        return $this->block_name;
    }

    public function get_block_title() {
        return $this->block_title;
    }

    public function is_caching() {
        return $this->is_caching;
    }

    public function is_config() {
        return $this->is_config;
    }

    public function get_config() {
        $config = [
            'page_title' => '',
            'menu_title' => '',
            'order' => '',
        ];

        if ($this->is_config) {
            $config['page_title'] = $this->config_page_title;
            $config['menu_title'] = $this->config_menu_title;
            $config['order'] = $this->config_menu_order;
        }

        return $config;
    }

    public function get_log_debug($params) {
        global $rdgb;
        $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

        if (isset($params['api_request']) && $rdgb->helpers->rdg_debug_request($params['api_request'])) {
            echo sprintf('<!--Request: %s-->', $params['api_request']['request']);
        }

        if (isset($params['cache_file']) && $rdgb->helpers->rdg_debug_cache($params['cache_file'])) {
            try {
                $cache = file_get_contents($rdgb->helpers->get_cache_dir().$params['cache_file']);
                echo '<!-- Cache File: '.$params['cache_file'].' ';
                print_r(unserialize($cache));
                echo '-->';
            } catch (\Exception $exception) {
                //
            }
        }

        if (isset($params['type_game']) && $rdgb->helpers->rdg_debug_blocks_games($params)) {
            echo '<div class="rdg-blocks"><!-- RDG Blocks/RDG Game: '.$params['type_game'].'. Example ';
            print_r($params['data']);
            
            if (isset($params['invalid_fields']) && is_array($params['invalid_fields']) && count($params['invalid_fields']) > 0) {
                echo 'Invalid Fields: ';
                print_r($params['invalid_fields']);
            }

            echo '--></div>';
        }
    }
}
