<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Game extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_GAME;
    private $block_folder_name = BLOCK_RDG_GAME;
    private $block_title = 'RDG Game';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'game'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = false;

    public function init() {
        $this->register_block();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_game.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => false,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    private function get_team_city($team) {
        $city_team = explode(' ', $team);

        if (!is_array($city_team)) {
            return ['City Name', 'Team Name'];
        }

        if (is_array($city_team) && count($city_team) == 1) {
            return ['City Name', $city_team];
        }

        if (is_array($city_team) && count($city_team) == 2) {
            return [$city_team[0], $city_team[1]];
        }

        $city = $city_team[0];
        unset($city_team[0]);
        $team = implode(' ',$city_team);

        return [$city, $team];
    }

    public function get_block_fields($post, $rdgb) {
        $example_fields = [
            'shg_sport_id' => '1',
            'shg_category' => '1',
            'shg_game_date' => '2023-09-15 10:25:00',
            'shg_home_team' => 'Kansas City Chiefs',
            'shg_home_score' => '21',
            'shg_home_local_url' => RDGBLOCKS_PLUGIN_URL.'blocks/rdg-game/assets/img/chiefs.png',
            'shg_current_money_line_home_odds' => '-288',
            'shg_visitor_team' => 'Detroit Lions',
            'shg_visitor_score' => '3',
            'shg_visitor_local_url' => RDGBLOCKS_PLUGIN_URL.'blocks/rdg-game/assets/img/lions.png',
            'shg_current_money_line_visitor_odds' => '+236',
        ];

        $fields_validate = [
            'shg_category' => 'nullable'
        ];

        #TODO: En espera de la inclusión en el API del campo city
        $tem_home = $this->get_team_city($example_fields['shg_home_team']);
        $example_fields['shg_home_city'] = $tem_home[0];
        $example_fields['shg_home_team'] = $tem_home[1];

        $tem_visitor = $this->get_team_city($example_fields['shg_visitor_team']);
        $example_fields['shg_visitor_city'] = $tem_visitor[0];
        $example_fields['shg_visitor_team'] = $tem_visitor[1];

        $sports_categories = $rdgb->helpers->get_sporst_categories_titles(true);
        
        if ($post->post_type == 'gp_elements') {
            return array_merge($example_fields, [
                'type' => 'example',
                'title' => $sports_categories[$example_fields['shg_sport_id']]
            ]);
        }

        $custom_fields = get_fields($post->ID);

        #TODO: En espera de la inclusión en el API del campo city
        $tem_home = $this->get_team_city($custom_fields['shg_home_team']);
        $custom_fields['shg_home_city'] = $tem_home[0];
        $custom_fields['shg_home_team'] = $tem_home[1];

        $tem_visitor = $this->get_team_city($custom_fields['shg_visitor_team']);
        $custom_fields['shg_visitor_city'] = $tem_visitor[0];
        $custom_fields['shg_visitor_team'] = $tem_visitor[1];

        $validate = true;
        $fields_invalids = [];
        foreach ($example_fields as $key => $value) {
            if (!isset($custom_fields[$key]) || empty($custom_fields[$key])) {
                if (!isset($fields_validate[$key]) || (isset($fields_validate[$key]) && $fields_validate[$key] != 'nullable')) {
                    $validate = false;
                    $fields_invalids[] = $key;
                }
            } else {
                $fields[$key] = $custom_fields[$key];
            }
        }

        if (!$validate) {
            return array_merge($example_fields, [
                'type' => 'Invalid field validation',
                'invalid_fields' => $fields_invalids,
                'example' => $example_fields,
            ]);
        }

        $sport_category_index = $custom_fields['shg_sport_id'];
        if (isset($custom_fields['shg_category']) && !empty($custom_fields['shg_category'])) {
            $sport_category_index = $custom_fields['shg_sport_id'].'-'.$custom_fields['shg_category'];
        }

        $fields['title'] = (!empty($sports_categories[$sport_category_index]))
            ? $sports_categories[$sport_category_index]
            : $sports_categories[$custom_fields['shg_sport_id']];

        return array_merge($fields, ['type' => '']);
    }
}

$rdg_game_class = new Rdg_Blocks_Game();
$rdg_game_class->init();

return $rdg_game_class;
