<?php 
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_classes = [BLOCK_RDG_GAME_TOP_HANDICAPPER];
    $block_game = $rdgb->settings->get_block(BLOCK_RDG_GAME_TOP_HANDICAPPER);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container content grid-container">
            <div class="inner-content">
                <div class="top-header">
                    <span class="top-title">Top Handicapper</span>
                </div>
                <div class="top-content">
                    <div class="top-capper">
                        <img src="http://rdg-blocks.test:8080/app/uploads/2023/09/photo.png" alt="">
                    </div>
                    <div class="top-body">
                        <div class="body-header">
                            <div class="header">
                                <div class="body-header-capper">
                                    <span class="name">Al Grant</span>
                                    <span class="separator">|</span>
                                    <span class="cat">Handicapper</span>
                                </div>
                                <div class="body-header-socials">
                                    <a href="">
                                        <img src="http://rdg-blocks.test:8080/app/uploads/2023/09/x.png" alt="">
                                    </a>
                                    <a href="">
                                        <img src="http://rdg-blocks.test:8080/app/uploads/2023/09/in.png" alt="">
                                    </a>
                                    <a href="">
                                        <img src="http://rdg-blocks.test:8080/app/uploads/2023/09/face.png" alt="">
                                    </a>
                                    <a href="">
                                        <img src="http://rdg-blocks.test:8080/app/uploads/2023/09/insta.png" alt="">
                                    </a>
                                </div>
                            </div>
                            <div class="body-description">
                                Lorem ipsum dolor sit amet consectetur adipisicing elit. Iste, adipisci placeat. Tempore distinctio a laboriosam eaque eius sint officiis libero? Eius perspiciatis ratione laborum magni. Voluptatem fugit eligendi magni in?
                                Animi unde earum, accusantium amet quisquam ratione, quidem laboriosam a quasi commodi perspiciatis ipsam, dolores quod! Iste sapiente earum, placeat voluptatum ipsam voluptas necessitatibus? Illum dignissimos commodi quo a reprehenderit?
                            </div>
                        </div>
                        <div class="games">
                            <div class="game">
                                <div class="game-title">
                                    #2 NBA
                                </div>
                                <div class="game-body">
                                    <div class="list-games">
                                        <div class="list-game">
                                            <div class="time">Yesterday</div>
                                            <div class="amount">$85</div>
                                        </div>
                                        <div class="list-game">
                                            <div class="time">Last 7 days</div>
                                            <div class="amount">$66</div>
                                        </div>
                                        <div class="list-game">
                                            <div class="time">Last 3 days</div>
                                            <div class="amount">$135</div>
                                        </div>
                                        <div class="list-game">
                                            <div class="time">Last 30 days</div>
                                            <div class="amount">-$414</div>
                                        </div>
                                    </div>
                                </div>
                                <div class="game-footer">
                                    <a href="#">ALL STATS</a>
                                </div>
                            </div>
                            <div class="game">
                                <div class="game-title">
                                    SPORTS RANK
                                </div>
                                <div class="game-body">
                                    <div class="list-games">
                                        <div class="list-game">
                                            <div class="time">MLB</div>
                                            <div class="amount">#143</div>
                                        </div>
                                        <div class="list-game">
                                            <div class="time">NHL</div>
                                            <div class="amount">#85</div>
                                        </div>
                                        <div class="list-game">
                                            <div class="time">NBA</div>
                                            <div class="amount">#2</div>
                                        </div>
                                        <div class="list-game">
                                            <div class="time">SOC</div>
                                            <div class="amount">-</div>
                                        </div>
                                    </div>
                                </div>
                                <div class="game-footer"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
