<?php 
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_classes = [BLOCK_RDG_GAME_LINKS];
    $block_game = $rdgb->settings->get_block(BLOCK_RDG_GAME_LINKS);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
?>
<div class="game-link-sticky hide"></div>
<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container content grid-container">
            <div id="game-link-sticky-origin" class="links-body">
                <div class="primary">
                    <span>ON THIS PAGE</span>
                </div>
                <div class="default">
                    <div class="link">
                        <a href="#block-game-links-preview">
                            <img src="<?php echo RDGBLOCKS_PLUGIN_URL.'blocks/rdg-game-links/assets/img/ico-5.png'; ?>" alt="">
                            Preview
                        </a>
                    </div>
                    <div class="link">
                        <a href="#block-game-links-top-handicapper">
                            <img src="<?php echo RDGBLOCKS_PLUGIN_URL.'blocks/rdg-game-links/assets/img/ico-4.png'; ?>" alt="">
                            Top Handicapper
                        </a>
                    </div>
                    <div class="link">
                        <a href="#block-game-links-picks">
                            <img src="<?php echo RDGBLOCKS_PLUGIN_URL.'blocks/rdg-game-links/assets/img/ico-3.png'; ?>" alt="">
                            Picks
                        </a>
                    </div>
                    <div class="link">
                        <a href="#block-game-links-odds">
                            <img src="<?php echo RDGBLOCKS_PLUGIN_URL.'blocks/rdg-game-links/assets/img/ico-2.png'; ?>" alt="">
                            Odds
                        </a>
                    </div>
                    <div class="link">
                        <a href="#block-game-links-last-recap">
                            <img src="<?php echo RDGBLOCKS_PLUGIN_URL.'blocks/rdg-game-links/assets/img/ico-1.png'; ?>" alt="">
                            Last Recap
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
