<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Promote_Site extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_PROMOTE_SITE;
    private $block_folder_name = BLOCK_RDG_PROMOTE_SITE;
    protected $block_title = 'RDG Promote Site';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'promote', 'site'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = true;
    protected $is_styles_load = true;
    protected $config_page_title = 'RDG Promote Site';
    protected $config_menu_title = 'Promote Site';
    protected $config_menu_order = 11;

    public function init() {
        $this->register_block();
        $this->register_fields();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_promote_site.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => false,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    public function register_fields() {
        add_action( 'acf/include_fields', function() {
            if ( ! function_exists( 'acf_add_local_field_group' ) ) {
                return;
            }
        
            acf_add_local_field_group( array(
            'key' => 'group_65ce99e806c3d',
            'title' => 'Promote Sites',
            'fields' => array(
                array(
                    'key' => 'field_65ce99e8f0e1c',
                    'label' => 'Site',
                    'name' => 'promo_sites',
                    'aria-label' => '',
                    'type' => 'repeater',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'acfe_save_meta' => 0,
                    'acfe_repeater_stylised_button' => 0,
                    'layout' => 'block',
                    'pagination' => 0,
                    'min' => 0,
                    'max' => 0,
                    'collapsed' => '',
                    'button_label' => 'Add Row',
                    'rows_per_page' => 20,
                    'sub_fields' => array(
                        array(
                            'key' => 'field_65ce9a37f0e1d',
                            'label' => 'Site Logo',
                            'name' => 'promote_site_logo',
                            'aria-label' => '',
                            'type' => 'image',
                            'instructions' => '',
                            'required' => 1,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '60',
                                'class' => '',
                                'id' => '',
                            ),
                            'acfe_save_meta' => 0,
                            'uploader' => '',
                            'return_format' => 'array',
                            'upload_folder' => '',
                            'acfe_thumbnail' => 0,
                            'required_message' => '',
                            'min_width' => '',
                            'min_height' => '',
                            'min_size' => '',
                            'max_width' => '',
                            'max_height' => '',
                            'max_size' => '',
                            'mime_types' => '',
                            'preview_size' => 'medium',
                            'library' => 'all',
                            'parent_repeater' => 'field_65ce99e8f0e1c',
                        ),
                        array(
                            'key' => 'field_65ce9b1a01709',
                            'label' => 'Site Name',
                            'name' => 'promote_site_name',
                            'aria-label' => '',
                            'type' => 'text',
                            'instructions' => '',
                            'required' => 1,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '60',
                                'class' => '',
                                'id' => '',
                            ),
                            'acfe_save_meta' => 0,
                            'default_value' => '',
                            'required_message' => '',
                            'maxlength' => '',
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                            'parent_repeater' => 'field_65ce99e8f0e1c',
                        ),
                        array(
                            'key' => 'field_65ce9b5845bb1',
                            'label' => 'Offer Amount',
                            'name' => 'promote_site_offer_amount',
                            'aria-label' => '',
                            'type' => 'text',
                            'instructions' => '',
                            'required' => 1,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '20',
                                'class' => '',
                                'id' => '',
                            ),
                            'acfe_save_meta' => 0,
                            'default_value' => '',
                            'required_message' => '',
                            'maxlength' => '',
                            'placeholder' => '',
                            'prepend' => '$',
                            'append' => '',
                            'parent_repeater' => 'field_65ce99e8f0e1c',
                        ),
                        array(
                            'key' => 'field_65ce9bcd19885',
                            'label' => 'Offer Description',
                            'name' => 'promote_site_offer_description',
                            'aria-label' => '',
                            'type' => 'textarea',
                            'instructions' => '',
                            'required' => 1,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'acfe_save_meta' => 0,
                            'default_value' => '',
                            'acfe_textarea_code' => 0,
                            'required_message' => '',
                            'maxlength' => '',
                            'rows' => '',
                            'placeholder' => '',
                            'new_lines' => '',
                            'parent_repeater' => 'field_65ce99e8f0e1c',
                        ),
                        array(
                            'key' => 'field_65ce9c42066b9',
                            'label' => 'Action Button Text',
                            'name' => 'promote_site_action_button_text',
                            'aria-label' => '',
                            'type' => 'text',
                            'instructions' => '',
                            'required' => 1,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '50',
                                'class' => '',
                                'id' => '',
                            ),
                            'acfe_save_meta' => 0,
                            'default_value' => '',
                            'required_message' => '',
                            'maxlength' => '',
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                            'parent_repeater' => 'field_65ce99e8f0e1c',
                        ),
                        array(
                            'key' => 'field_65ce9e17e9d1b',
                            'label' => 'Age terms',
                            'name' => 'promote_site_age_terms',
                            'aria-label' => '',
                            'type' => 'text',
                            'instructions' => '',
                            'required' => 1,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '50',
                                'class' => '',
                                'id' => '',
                            ),
                            'acfe_save_meta' => 0,
                            'default_value' => '',
                            'required_message' => '',
                            'maxlength' => '',
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                            'parent_repeater' => 'field_65ce99e8f0e1c',
                        ),
                        array(
                            'key' => 'field_65ce9f3bdac63',
                            'label' => 'Offer Features',
                            'name' => 'promote_site_offer_features',
                            'aria-label' => '',
                            'type' => 'repeater',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'acfe_save_meta' => 0,
                            'acfe_repeater_stylised_button' => 0,
                            'layout' => 'table',
                            'pagination' => 0,
                            'min' => 0,
                            'max' => 0,
                            'collapsed' => '',
                            'button_label' => 'Add Row',
                            'rows_per_page' => 20,
                            'sub_fields' => array(
                                array(
                                    'key' => 'field_65ce9f97dac64',
                                    'label' => 'Features',
                                    'name' => 'promote_site_feature',
                                    'aria-label' => '',
                                    'type' => 'text',
                                    'instructions' => '',
                                    'required' => 1,
                                    'conditional_logic' => 0,
                                    'wrapper' => array(
                                        'width' => '',
                                        'class' => '',
                                        'id' => '',
                                    ),
                                    'acfe_save_meta' => 0,
                                    'required_message' => '',
                                    'default_value' => '',
                                    'maxlength' => '',
                                    'placeholder' => '',
                                    'prepend' => '',
                                    'append' => '',
                                    'parent_repeater' => 'field_65ce9f3bdac63',
                                ),
                            ),
                            'parent_repeater' => 'field_65ce99e8f0e1c',
                        ),
                    ),
                ),
            ),
            'location' => array(
                array(
                    array(
                        'param' => 'options_page',
                        'operator' => '==',
                        'value' => 'acf-options-promote-site',
                    ),
                ),
            ),
            'menu_order' => 0,
            'position' => 'normal',
            'style' => 'default',
            'label_placement' => 'left',
            'instruction_placement' => 'label',
            'hide_on_screen' => '',
            'active' => true,
            'description' => '',
            'show_in_rest' => 0,
            'acfe_autosync' => '',
            'acfe_form' => 0,
            'acfe_display_title' => '',
            'acfe_meta' => '',
            'acfe_note' => '',
        ) );
        } );
                                   
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'color-rdg-promote-site-bg','slug' => 'color-rdg-promote-site-bg','color' => '#f0f0f0'],
            ['name' => 'color-rdg-promote-site-header','slug' => 'color-rdg-promote-site-header','color' => '#ffffff'],
            ['name' => 'color-rdg-promote-site-header-border','slug' => 'color-rdg-promote-site-header-border','color' => '#3a96e0'],
            ['name' => 'color-rdg-promote-site-primary','slug' => 'color-rdg-promote-site-primary','color' => '#0160ac'],
            ['name' => 'color-rdg-promote-site-body-bg','slug' => 'color-rdg-promote-site-body-bg','color' => '#f0f0f0'],
            ['name' => 'color-rdg-promote-site-button','slug' => 'color-rdg-promote-site-button','color' => '#ffffff'],
            ['name' => 'color-rdg-promote-site-button-success','slug' => 'color-rdg-promote-site-button-success','color' => '#00bc00'],
            ['name' => 'color-rdg-promote-site-button-success-border','slug' => 'color-rdg-promote-site-button-success-border','color' => '#68f96e'],
            ['name' => 'color-rdg-promote-site-gray-light','slug' => 'color-rdg-promote-site-gray-light','color' => '#d8d8d8'],
            ['name' => 'color-rdg-promote-site-gray','slug' => 'color-rdg-promote-site-gray','color' => '#4a4a4a'],
            ['name' => 'color-rdg-promote-site-gray-dark','slug' => 'color-rdg-promote-site-gray-dark','color' => '#b2b2be'],
            ['name' => 'color-rdg-promote-site-black','slug' => 'color-rdg-promote-site-black','color' => '#000000'],
            ['name' => 'color-rdg-promote-site-red','slug' => 'color-rdg-promote-site-red','color' => '#ff0000'],
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [
            [
                'customSelector' => '.rdg-blocks-promote .header .promote-name',
                'fontWeight' => 'bold',
            ],
            [
                'customSelector' => '.rdg-blocks-promote .header .promote-offer-amount',
                'fontWeight' => 'bold',
                'fontSize' => '1.1rem',
            ],
            [
                'customSelector' => '.rdg-blocks-promote .body .promote-content .promote-offer-description',
                'fontWeight' => 'bold',
            ],
            [
                'customSelector' => '.rdg-blocks-promote .body .promote-action-button button',
                'fontWeight' => 'bold',
            ],
            [
                'customSelector' => '.rdg-blocks .rdg-blocks-promote .footer .terms',
                'fontWeight' => '500',
            ],
            [
                'customSelector' => '.rdg-blocks-promote .footer .age_terms',
                'fontWeight' => 'bold',
                'fontSize' => '0.7rem',
            ],
        ];
    }
}

$rdg_promote_site_class = new Rdg_Blocks_Promote_Site();
$rdg_promote_site_class->init();

return $rdg_promote_site_class;