<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Best_Pph_Sites extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_BEST_PPH_SITES;
    private $block_folder_name = 'rdg-best-pph-sites';
    protected $block_title = 'RDG Best PPH Sites';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'best', 'pph', 'site', 'pay', 'per', 'head'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = false;
    protected $is_styles_load = true;
    protected $is_pre_saved = false;

    public function init() {
        $this->register_block();
        add_action('acf/init', [$this, 'register_fields'], 20);
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_best_pph_sites.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    public function register_fields() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'group_64e8b6c8aef74',
                'title' => 'RDG Sidebar',
                'key' => 'group_64e8b6c8aef74',
                'title' => 'RDG Best PPH Sites',
                'fields' => array(
                    array(
                        'key' => 'field_64e8b6c833103',
                        'label' => 'Title',
                        'name' => 'sidebar_title',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64e8bbe5ecb08',
                        'label' => 'Heading',
                        'name' => 'sidebar_heading',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64e8b6c833103',
                                    'operator' => '!=empty',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'h1' => 'H1',
                            'h2' => 'H2',
                            'h3' => 'H3',
                            'span' => 'Span',
                        ),
                        'default_value' => 'h3',
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_64ea2948f8fb5',
                        'label' => 'Icon',
                        'name' => 'sidebar_icon',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'dashicons-plus-alt' => 'Circle Plus',
                            'dashicons-yes-alt' => 'Circle Check',
                            'dashicons-dismiss' => 'Circle Close',
                            'dashicons-warning' => 'Circle Info',
                        ),
                        'default_value' => false,
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 1,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_64e8b75233104',
                        'label' => 'Sites',
                        'name' => 'pay_per_head_sites',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_64e8b7a133105',
                                'label' => 'Logo',
                                'name' => 'logo',
                                'aria-label' => '',
                                'type' => 'image',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                                'library' => 'all',
                                'min_width' => '',
                                'min_height' => '',
                                'min_size' => '',
                                'max_width' => '',
                                'max_height' => '',
                                'max_size' => '',
                                'mime_types' => '',
                                'preview_size' => 'medium',
                                'parent_repeater' => 'field_64e8b75233104',
                            ),
                            array(
                                'key' => 'field_64e8b7af33106',
                                'label' => 'Description',
                                'name' => 'description',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_64e8b75233104',
                            ),
                            array(
                                'key' => 'field_64e8b7c533107',
                                'label' => 'Link',
                                'name' => 'link',
                                'aria-label' => '',
                                'type' => 'link',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                                'parent_repeater' => 'field_64e8b75233104',
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-best-pph-sites',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'color-rdg-best-pph-sites-sidebar-title','slug' => 'color-rdg-best-pph-sites-sidebar-title','color' => '#111111'],
            ['name' => 'color-rdg-best-pph-sites-sidebar-line-border','slug' => 'color-rdg-best-pph-sites-sidebar-line-border','color' => '#CCC'],
            ['name' => 'color-rdg-best-pph-sites-sidebar-description','slug' => 'color-rdg-best-pph-sites-sidebar-description','color' => '#111111'],
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [
            [
                'customSelector' => '.rdg-best-pph-sites .sidebar-title',
                'fontWeight' => '600',
                'fontSize' => '1.2rem',
            ],
            [
                'customSelector' => '.rdg-best-pph-sites .sidebar-description',
                'fontWeight' => '600',
                'fontSize' => '1rem',
            ],
            [
                'customSelector' => '.rdg-best-pph-sites .sidebar-link',
                'fontWeight' => '600',
                'fontSize' => '1.2rem',
            ],
            [
                'customSelector' => '.acf-block-preview .rdg-best-pph-sites .sidebar-pphs .sidebar-pph .sidebar-link a',
                'textDecoration' => 'none'
            ],
        ];
    }
}

$rdg_best_pph_sites_class = new Rdg_Blocks_Best_Pph_Sites();
$rdg_best_pph_sites_class->init();

return $rdg_best_pph_sites_class;
