document.addEventListener("change", function (e) {
    if (e.target.matches("select.rdg_injury_report_leagues")) {
        e.preventDefault();
        const ajax_url = rdg_injury_report_var.ajaxurl;

        let league = document.querySelector(
            "select.rdg_injury_report_leagues option:checked"
        ).value;

        if (league == "") {
            document.querySelector(
                ".acf-field-key-rdg-injury-report-teams select"
            ).innerHTML = "";
            return;
        }

        fetch(ajax_url, {
            method: "POST",
            headers: {
                "Content-Type": "application/x-www-form-urlencoded",
            },
            body: `action=load_teams_sports&league=${league}`,
        })
            .then((response) => response.text())
            .then((resultado) => {
                document.querySelector(
                    ".acf-field-key-rdg-injury-report-teams select"
                ).innerHTML = resultado;
            })
            .catch((err) => console.error(err));
    }
});
