<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Paragraph_Custom extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_PARAGRAPH_CUSTOM;
    private $block_folder_name = 'rdg-paragraph-custom';
    protected $block_title = 'RDG Paragraph Custom';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'paragraph', 'text'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = false;
    protected $is_styles_load = false;
    protected $is_pre_saved = false;

    public function init() {
        $this->register_block();
        add_action('acf/init', [$this, 'register_fields'], 20);
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_paragraph_custom.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    public function register_fields() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'group_rdg_paragraph_custom_block_dc232ddd2d2d',
                'title' => 'Block_rdg_paragraph_custom',
                'fields' => array(
                    array(
                        'key' => 'field_63c8394687e41',
                        'label' => 'Elements',
                        'name' => 'elements',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_63c83a92a764a',
                                'label' => 'Title',
                                'name' => 'title',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63c8394687e41',
                            ),
                            array(
                                'key' => 'field_63c83a9da764b',
                                'label' => 'Heading',
                                'name' => 'heading',
                                'aria-label' => '',
                                'type' => 'select',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_63c83a92a764a',
                                            'operator' => '!=empty',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => array(
                                    'h1' => 'Heading H1',
                                    'h2' => 'Heading H2',
                                    'h3' => 'Heading H3',
                                    'span' => 'Heading Span',
                                ),
                                'default_value' => 'h1',
                                'return_format' => 'value',
                                'multiple' => 0,
                                'allow_null' => 0,
                                'ui' => 0,
                                'ajax' => 0,
                                'placeholder' => '',
                                'parent_repeater' => 'field_63c8394687e41',
                            ),
                            array(
                                'key' => 'field_63c8403f44673',
                                'label' => 'Border Line',
                                'name' => 'border_line',
                                'aria-label' => '',
                                'type' => 'number',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_63c83a92a764a',
                                            'operator' => '!=empty',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => 3,
                                'min' => 0,
                                'max' => 20,
                                'placeholder' => '',
                                'step' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63c8394687e41',
                            ),
                            array(
                                'key' => 'field_63c83c2878fd7',
                                'label' => 'Padding',
                                'name' => 'padding',
                                'aria-label' => '',
                                'type' => 'number',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_63c83a92a764a',
                                            'operator' => '!=empty',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '0.5',
                                'min' => 0,
                                'max' => 20,
                                'placeholder' => '',
                                'step' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63c8394687e41',
                            ),
                            array(
                                'key' => 'field_63c83c4e78fd8',
                                'label' => 'Text Align',
                                'name' => 'title_align',
                                'aria-label' => '',
                                'type' => 'select',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_63c83a92a764a',
                                            'operator' => '!=empty',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => array(
                                    'left' => 'Left',
                                    'center' => 'Center',
                                    'right' => 'Right',
                                ),
                                'default_value' => 'left',
                                'return_format' => 'value',
                                'multiple' => 0,
                                'allow_null' => 0,
                                'ui' => 0,
                                'ajax' => 0,
                                'placeholder' => '',
                                'parent_repeater' => 'field_63c8394687e41',
                            ),
                            array(
                                'key' => 'field_63c83c7078fd9',
                                'label' => 'Font Weight',
                                'name' => 'font_weight',
                                'aria-label' => '',
                                'type' => 'select',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_63c83a92a764a',
                                            'operator' => '!=empty',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => array(
                                    100 => '100',
                                    200 => '200',
                                    300 => '300',
                                    400 => '400',
                                    500 => '500',
                                    600 => '600',
                                    700 => '700',
                                    800 => '800',
                                    900 => '900',
                                ),
                                'default_value' => 700,
                                'return_format' => 'value',
                                'multiple' => 0,
                                'allow_null' => 0,
                                'ui' => 0,
                                'ajax' => 0,
                                'placeholder' => '',
                                'parent_repeater' => 'field_63c8394687e41',
                            ),
                            array(
                                'key' => 'field_63c83d6278fdc',
                                'label' => 'Size',
                                'name' => 'size',
                                'aria-label' => '',
                                'type' => 'number',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_63c83a92a764a',
                                            'operator' => '!=empty',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '1.5',
                                'min' => 0,
                                'max' => 20,
                                'placeholder' => '',
                                'step' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63c8394687e41',
                            ),
                            array(
                                'key' => 'field_63c83d8878fdd',
                                'label' => 'Size LG',
                                'name' => 'size_lg',
                                'aria-label' => '',
                                'type' => 'number',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_63c83a92a764a',
                                            'operator' => '!=empty',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => 0,
                                'min' => 0,
                                'max' => 20,
                                'placeholder' => '',
                                'step' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63c8394687e41',
                            ),
                            array(
                                'key' => 'field_63c83da078fde',
                                'label' => 'Size MD',
                                'name' => 'size_md',
                                'aria-label' => '',
                                'type' => 'number',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_63c83a92a764a',
                                            'operator' => '!=empty',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => 0,
                                'min' => 0,
                                'max' => 20,
                                'placeholder' => '',
                                'step' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63c8394687e41',
                            ),
                            array(
                                'key' => 'field_63c83daa78fdf',
                                'label' => 'Size SM',
                                'name' => 'size_sm',
                                'aria-label' => '',
                                'type' => 'number',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_63c83a92a764a',
                                            'operator' => '!=empty',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => 0,
                                'min' => 0,
                                'max' => 20,
                                'placeholder' => '',
                                'step' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63c8394687e41',
                            ),
                            array(
                                'key' => 'field_63c83cae78fda',
                                'label' => 'Title Color',
                                'name' => 'title_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_63c83a92a764a',
                                            'operator' => '!=empty',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#000000',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                                'parent_repeater' => 'field_63c8394687e41',
                            ),
                            array(
                                'key' => 'field_63c83d2178fdb',
                                'label' => 'Border Color',
                                'name' => 'line_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_63c8403f44673',
                                            'operator' => '>',
                                            'value' => '0',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                                'parent_repeater' => 'field_63c8394687e41',
                            ),
                            array(
                                'key' => 'field_63c83f11df011',
                                'label' => 'Paragraph',
                                'name' => 'paragraph',
                                'aria-label' => '',
                                'type' => 'wysiwyg',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'tabs' => 'all',
                                'toolbar' => 'full',
                                'media_upload' => 1,
                                'delay' => 0,
                                'parent_repeater' => 'field_63c8394687e41',
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-paragraph-custom',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function get_sub_title($element) {
        $rdg_helpers = new Rdg_Blocks_Helpers();
        list($heading, $title, $styles) = $rdg_helpers->get_title($element, false);

        $new_style = [];
        foreach($styles as $style) {
            if (strpos($style, 'text-shadow:') === false) {
                $new_style[] = $style;
            }
        }

        $color_line = (!empty($element['line_color'])) ? $element['line_color'] : '#3a96e0';
        $line = (!empty($element['border_line'])) ? 'border-bottom: '.$element['border_line'].'px solid '.$color_line : 'border-bottom: none';

        if (count($new_style) > 0) {
            $styles = implode('; ', $new_style).';';
        }

        return [$heading, $title, $styles, $line];
    }
}

$rdg_paragraph_custom_class = new Rdg_Blocks_Paragraph_Custom();
$rdg_paragraph_custom_class->init();

return $rdg_paragraph_custom_class;
