<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Product_Report extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_PRODUCT_REPORT;
    private $block_folder_name = BLOCK_RDG_PRODUCT_REPORT;
    protected $block_title = 'RDG Product Report';
    private $block_description = 'The block is used to display and structure the description for a product with a round corner box style, it allow to edit the Header title and the description text';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'product', 'report'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_styles_load = true;

    public function init() {
        $this->register_block();
        $this->register_fields();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_product_report.css'),
                'example' => array(
                    'attributes' => array(
                        'mode' => 'preview',
                        'data' => array(
                            'isExample' => true,
                            'preview_image' => RDGBLOCKS_PLUGIN_URL."dist/images/rdg-product-report-template-preview.jpg",
                        ),
                    ),
                ),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    private function register_fields() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'group_rdg_product_report_block_sdaasdsdasdad',
                'title' => 'Block_rdg_product_report',
                'fields' => array(
                    array(
                        'key' => 'field_6436fd0895188',
                        'label' => 'Header Title',
                        'name' => 'header_title',
                        'aria-label' => '',
                        'type' => 'wysiwyg',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => 'height-100',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'tabs' => 'text',
                        'media_upload' => 0,
                        'toolbar' => 'full',
                        'delay' => 0,
                    ),
                    array(
                        'key' => 'field_6436fe61b89b2',
                        'label' => 'Content',
                        'name' => 'content',
                        'aria-label' => '',
                        'type' => 'wysiwyg',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'tabs' => 'text',
                        'media_upload' => 0,
                        'toolbar' => 'full',
                        'delay' => 0,
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-product-report',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'color-product-report-title-bg','slug' => 'color-product-report-title-bg','color' => '#0160ac'],
            ['name' => 'color-product-report-title','slug' => 'color-product-report-title','color' => '#ffffff'],
            ['name' => 'color-product-report-title-icon','slug' => 'color-product-report-title-icon','color' => '#ffffff'],
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [
            [
                'customSelector' => '.rdg-product-report .header .header-title',
                'fontWeight' => '500',
                'fontSize' => '1.1rem',
                'lineHeightMobile' => '1.3rem',
            ],
            [
                'customSelector' => '.rdg-product-report .content',
                'fontSize' => '1.1rem',
            ],
            [
                'customSelector' => '.rdg-blocks .rdg-product-report .content .header .header-icon',
                'fontSize' => '1.2rem',
            ],
        ];
    }
}

$rdg_product_report_class = new Rdg_Blocks_Product_Report();
$rdg_product_report_class->init();

return $rdg_product_report_class;
