<?php 
    if (isset($block['data']['isExample']) && $block['data']['isExample']) {
        echo '<img src="' . esc_url( $block['data']['preview_image'] ) . '"style="max-width:100%; min-width:100%" alt="Preview" />';
        return;
    }

    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $name_block = BLOCK_RDG_RANKING_BOOKIE;
    $block_classes = [$name_block];
    $block_ranking_bookie = $rdgb->settings->getBlock($name_block);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $titles = get_field('titles');
    $position_block = $rdgb->helpers->getBlocksSpaces(get_fields());

    $bookie = (!empty(get_field('bookie'))) ? get_field('bookie') : null;
    $heading = (!empty(get_field('heading'))) ? get_field('heading') : 'span';
    $sub_title = (!empty(get_field('sub_title'))) ? get_field('sub_title') : null;
    $ranking = (!empty(get_field('ranking'))) ? get_field('ranking') : 1;
    $description = (!empty(get_field('description'))) ? get_field('description') : null;
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="content">
            <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

            <?php if (!empty($bookie)): ?>
                <<?php echo $heading; ?> class="ranking-title"><?php echo $bookie; ?></<?php echo $heading; ?>>
                <div class="ranking-data">
                    <?php if (!empty($sub_title)): ?>
                        <span class="ranking-since"><?php echo $sub_title; ?></span>
                    <?php endif; ?>
                    <div class="stars <?php echo (empty($sub_title)) ? 'ml-0' : ''; ?>">
                        <?php $block_ranking_bookie->get_stars($ranking); ?>
                    </div>
                </div>
                <?php if (!empty($description)): ?>
                    <div class="ranking-description"><?php echo $description; ?></div>
                <?php endif; ?>
            <?php else: ?>
                <div class="message danger">
                    <span><?php echo __('Must add some Bookie.'); ?></span>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
