<?php foreach ($handicappers as $handicapper): ?>
    <?php if (!$rdgb->helpers->validateFields($fields, $handicapper)) continue; ?>
    <div class="handicapper">
        <div class="handicapper-header">
            <div class="header-image">
                <?php
                    $image = $block_handicappers_hub->getImage($handicapper['image'], [
                        'image_type' => 'handicappers_hub',
                        'image_alt' => $handicapper['name'],
                        'logo_label' => true
                    ]);
                ?>
                <img src="<?php echo $image['url']; ?>" alt="<?php echo $image['alt']; ?>">
            </div>
            <div class="header-content">
                <div class="header-name"><a href="<?php echo $handicapper['profile_url']; ?>"><?php echo $handicapper['name']; ?></a></div>
                <?php if (isset($handicapper['group'][0]['name']) && !empty($handicapper['group'][0]['name']) && isset($handicapper['group_url']) && !empty($handicapper['group_url'])): ?>
                    <div class="header-package">
                        <a href="<?php echo $handicapper['group_url']; ?>"><?php echo $handicapper['group'][0]['name']; ?></a>
                    </div>
                <?php endif; ?>
                <?php
                    $amount = '';
                    if (strpos($handicapper['last_days_amount'], '-') === 0) {
                        $stat_class = 'danger';
                        $tem_amount = str_replace('-', '', $handicapper['last_days_amount']);
                        $amount = '-$' . number_format($tem_amount, 0, '.', ',');
                    } else {
                        $stat_class = 'success';
                        $amount = '+$' . number_format($handicapper['last_days_amount'], 0, '.', ',');
                    }
                ?>
                <div class="header-stats">Won in Last <?php echo $handicapper['last_days']; ?> days <span class="<?php echo $stat_class; ?>"><?php echo $amount; ?></span></div>
            </div>
        </div>
        <div class="handicapper-body">
            <div class="body-content">
                <?php
                    $paragraphs = preg_split('/\n+/', trim(strip_tags($handicapper['bio'])));
                    $result = implode('. ', array_map('trim', $paragraphs));
                    echo $result;
                ?>
            </div>
        </div>
        <div class="handicapper-footer">
            <div class="footer-content">
                <a href="<?php echo $handicapper['profile_url']; ?>">
                    <div class="footer-button">
                        <span class="button-picks"><?php echo $handicapper['today_picks']; ?> Picks available</span>
                        <span class="button-capper"><?php echo $handicapper['name']; ?></span>
                    </div>
                </a>
            </div>
        </div>
    </div>
<?php endforeach; ?>
