<?php if (!empty($picks) && is_array($picks)): ?>
    <?php $fields = $block_scores_and_odds->getFieldsValidate(); ?>
    <?php foreach ($picks as $pick): ?>
        <?php
        if (!$rdgb->helpers->validateFields($fields, $pick)) continue;

        // Robust date parsing with multiple formats
        $game_datetime = false;
        $date_formats = [
            'Y-m-d H:i:s',      // 2025-11-03 12:00:00
            'Y-m-d H:i',        // 2025-11-03 12:00
            'Y-m-d\TH:i:s',     // 2025-11-03T12:00:00 (ISO)
            'Y-m-d\TH:i:sP',    // 2025-11-03T12:00:00+00:00 (ISO with timezone)
            'Y-m-d\TH:i:s.uP',  // 2025-11-03T12:00:00.000000+00:00 (ISO with microseconds)
        ];
        
        foreach ($date_formats as $format) {
            $game_datetime = DateTime::createFromFormat($format, $pick['game_date']);
            if ($game_datetime !== false) {
                break;
            }
        }
        
        // If all formats fail, try strtotime as fallback
        if ($game_datetime === false) {
            $timestamp = strtotime($pick['game_date']);
            if ($timestamp !== false) {
                $game_datetime = new DateTime();
                $game_datetime->setTimestamp($timestamp);
            }
        }
        
        // If still fails, skip this pick
        if ($game_datetime === false) {
            error_log('RDG Scores and Odds: Invalid date format for game_date: ' . $pick['game_date']);
            continue;
        }
        
        $formatted_game_date = sprintf('%s EST', $game_datetime->format('M d, Y H:i'));

        $odds = $pick['opener_game_odds'][0] ?? [];

        $format_odds = function ($value) {
            if (!isset($value) || $value === null) {
                return "-";
            }
            // if already has a sign (+ or -), don't add another
            if (preg_match('/^[+-]/', $value)) {
                return $value;
            }
            // if doesn't have a sign, add + for positives, - for negatives
            return (strpos($value, "-") === 0 ? "" : "+") . $value;
        };

        $valid_extensions = ['png', 'jpg', 'jpeg', 'webp', 'gif', 'svg'];
        $is_valid_image = function ($url) use ($valid_extensions) {
            $path_info = pathinfo($url);
            return isset($path_info['extension']) && in_array(strtolower($path_info['extension']), $valid_extensions);
        };

        $pick_text = ($pick['game_picks_count'] == 1) ? "1 Pick" : "{$pick['game_picks_count']} Picks";
        $pick_text .= ($pick['game_stat'] === "Final") ? " Made" : " Available";
        ?>

        <div class="sao-wrapper">
            <div class="header">
                <p><?php echo $pick['home_team']; ?></p>
                <p>vs</p>
                <p><?php echo $pick['visitor_team']; ?></p>
            </div>
            <div class="body">
                <div class="versus">
                    <div class="team-a">
                        <?php if (!empty($pick['home_image']) && $is_valid_image($pick['home_image'])): ?>
                            <?php $home_image = $block_scores_and_odds->get_image($pick['home_image'], [
                                'image_type' => 'scores_and_odds',
                                'image_alt' => $pick['home_team'] . ' Game Odds',
                                'logo_label' => false,
                            ]); ?>
                            <img src="<?php echo $home_image['url']; ?>" alt="<?php echo $home_image['alt']; ?>">
                        <?php endif; ?>
                    </div>
                    <div class="vs">
                        <p class="state"> <?php echo $pick['game_stat']; ?> </p>
                        <p class="vs-p">vs</p>
                        <p class="date"> <?php echo $formatted_game_date; ?> </p>
                    </div>
                    <div class="team-b">
                        <?php if (!empty($pick['visitor_image']) && $is_valid_image($pick['visitor_image'])): ?>
                            <?php $visitor_image = $block_scores_and_odds->get_image($pick['visitor_image'], [
                                'image_type' => 'scores_and_odds',
                                'image_alt' => $pick['visitor_team'] . ' Game Odds',
                                'logo_label' => false,
                            ]); ?>
                            <img src="<?php echo $visitor_image['url']; ?>" alt="<?php echo $visitor_image['alt']; ?>">
                        <?php endif; ?>
                    </div>
                </div>
                <div class="stats">
                    <div class="stat">
                        <p class="team-a"> <?php echo $pick['home_score'] ?? '-'; ?> </p>
                        <p class="name">Score</p>
                        <p class="team-b"> <?php echo $pick['visitor_score'] ?? '-'; ?> </p>
                    </div>
                    <div class="stat">
                        <p class="team-a">
                            <?php
                            $spread_home_points = $odds['spread_home_points'] ?? null;
                            $spread_home_odds = $odds['spread_home_odds'] ?? null;

                            if ($spread_home_points !== null || $spread_home_odds !== null) {
                                $points_str = ($spread_home_points !== null ? $format_odds($spread_home_points) : '-');
                                $odds_str = ($spread_home_odds !== null ? $format_odds($spread_home_odds) : '-');
                                // Solo mostrar espacio si ambos valores son válidos
                                if ($points_str !== '-' && $odds_str !== '-') {
                                    echo $points_str . ' ' . $odds_str;
                                } else {
                                    echo trim($points_str . ' ' . $odds_str);
                                }
                            } else {
                                echo '-';
                            }
                            ?>
                        </p>
                        <p class="name">Spread</p>
                        <p class="team-b">
                            <?php
                            $spread_visitor_points = $odds['spread_visitor_points'] ?? null;
                            $spread_visitor_odds = $odds['spread_visitor_odds'] ?? null;

                            if ($spread_visitor_points !== null || $spread_visitor_odds !== null) {
                                $points_str = ($spread_visitor_points !== null ? $format_odds($spread_visitor_points) : '-');
                                $odds_str = ($spread_visitor_odds !== null ? $format_odds($spread_visitor_odds) : '-');
                                // Solo mostrar espacio si ambos valores son válidos
                                if ($points_str !== '-' && $odds_str !== '-') {
                                    echo $points_str . ' ' . $odds_str;
                                } else {
                                    echo trim($points_str . ' ' . $odds_str);
                                }
                            } else {
                                echo '-';
                            }
                            ?>
                        </p>
                    </div>
                    <div class="stat">
                        <p class="team-a">
                            <?php 
                            if (!empty($odds['total_over_points'])) {
                                $over_points = $format_odds($odds['total_over_points']);
                                $over_odds = isset($odds['total_over_odds']) ? $format_odds($odds['total_over_odds']) : '';
                                echo 'o' . $over_points . $over_odds;
                            } else {
                                echo '-';
                            }
                            ?>
                        </p>
                        <p class="name">Total</p>
                        <p class="team-b">
                            <?php 
                            if (!empty($odds['total_under_points'])) {
                                $under_points = $format_odds($odds['total_under_points']);
                                $under_odds = isset($odds['total_under_odds']) ? $format_odds($odds['total_under_odds']) : '';
                                echo 'u' . $under_points . $under_odds;
                            } else {
                                echo '-';
                            }
                            ?>
                        </p>
                    </div>
                    <div class="stat">
                        <p class="team-a">
                            <?php 
                            if (isset($odds['money_line_home_odds']) && $odds['money_line_home_odds'] !== null) {
                                $money_home = $odds['money_line_home_odds'];
                                // if the value already has a sign (+ or -), don't add another
                                if (preg_match('/^[+-]/', $money_home)) {
                                    echo $money_home;
                                } else {
                                    echo $format_odds($money_home);
                                }
                            } else {
                                echo "-";
                            }
                            ?>
                        </p>
                        <p class="name">Moneyline</p>
                        <p class="team-b">
                            <?php 
                            if (isset($odds['money_line_visitor_odds']) && $odds['money_line_visitor_odds'] !== null) {
                                $money_visitor = $odds['money_line_visitor_odds'];
                                // if the value already has a sign (+ or -), don't add another
                                if (preg_match('/^[+-]/', $money_visitor)) {
                                    echo $money_visitor;
                                } else {
                                    echo $format_odds($money_visitor);
                                }
                            } else {
                                echo "-";
                            }
                            ?>
                        </p>
                    </div>
                </div>
                <div class="ctas">
                    <?php
                        $preview_url = '';
                        if (isset($pick['local_game_id']) && !empty($pick['local_game_id'])) {
                            $preview_url = get_permalink($pick['local_game_id']);
                        } elseif (is_user_logged_in() && is_array($games_previews) && isset($pick['id_preview']) 
                            && !empty($pick['id_preview']) && isset($games_previews[$pick['id_preview']]) 
                            && !empty($games_previews[$pick['id_preview']])) {
                                $preview_url = get_permalink($games_previews[$pick['id_preview']]);
                        }
                    ?>
                    <?php if (!empty($pick['game_url'])): ?>
                        <a href="<?php echo $pick['game_url']; ?>" target="_blank" class="pick">
                            <?php echo $pick_text; ?>
                        </a>
                    <?php endif; ?>
                    <?php if (!empty($preview_url)): ?>
                        <a href="<?php echo $preview_url; ?>" class="preview">
                            <?php echo __('Preview & Prediction', BLOCK_RDG_SCORES_AND_ODDS); ?>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    <?php endforeach; ?>
<?php else: ?>
    <p>No picks available.</p>
<?php endif; ?>