<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Call_To_Action extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_CALL_TO_ACTION;
    private $block_folder_name = 'rdg-call-to-action';
    protected $block_title = 'RDG Call to Action';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'cta', 'call to action', 'call', 'action'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = false;
    protected $is_styles_load = true;
    protected $is_pre_saved = false;

    public function init() {
        $this->register_block();
        $this->register_fields();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_call_to_action.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    private function register_fields() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'group_rdg_call_to_action_block_hd73nsdu7sb32y',
                'title' => 'Block_rdg_call_to_action',
                'fields' => array(
                    array(
                        'key' => 'field_63d3178548c1f',
                        'label' => 'Orientation',
                        'name' => 'orientation',
                        'aria-label' => '',
                        'type' => 'radio',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'vertical' => 'Vertical',
                            'horizontal' => 'Horizontal',
                        ),
                        'default_value' => 'vertical',
                        'return_format' => 'value',
                        'allow_null' => 0,
                        'other_choice' => 0,
                        'layout' => 'horizontal',
                        'save_other_choice' => 0,
                    ),
                    array(
                        'key' => 'field_63d30d2b480cf',
                        'label' => 'Background Image',
                        'name' => 'background_image',
                        'aria-label' => '',
                        'type' => 'image',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'return_format' => 'array',
                        'library' => 'all',
                        'min_width' => '',
                        'min_height' => '',
                        'min_size' => '',
                        'max_width' => '',
                        'max_height' => '',
                        'max_size' => '',
                        'mime_types' => '',
                        'preview_size' => 'medium',
                    ),
                    array(
                        'key' => 'field_63d30d2b4babf',
                        'label' => 'Texts',
                        'name' => 'texts',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_63d30d2b56e54',
                                'label' => 'Text',
                                'name' => 'text',
                                'aria-label' => '',
                                'type' => 'wysiwyg',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'tabs' => 'all',
                                'toolbar' => 'full',
                                'media_upload' => 1,
                                'delay' => 0,
                                'parent_repeater' => 'field_63d30d2b4babf',
                            ),
                            array(
                                'key' => 'field_63d30d2b5aaba',
                                'label' => 'Heading',
                                'name' => 'heading',
                                'aria-label' => '',
                                'type' => 'select',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => array(
                                    'h1' => 'Heading H1',
                                    'h2' => 'Heading H2',
                                    'h3' => 'Heading H3',
                                    'span' => 'Heading Span',
                                ),
                                'default_value' => 'span',
                                'return_format' => 'value',
                                'multiple' => 0,
                                'allow_null' => 0,
                                'ui' => 0,
                                'ajax' => 0,
                                'placeholder' => '',
                                'parent_repeater' => 'field_63d30d2b4babf',
                            ),
                            array(
                                'key' => 'field_63d30d2b6d318',
                                'label' => 'Spacing',
                                'name' => 'spacing',
                                'aria-label' => '',
                                'type' => 'number',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'min' => 0,
                                'max' => 20,
                                'placeholder' => '',
                                'step' => 1,
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63d30d2b4babf',
                            ),
                            array(
                                'key' => 'field_63d30d2b5e802',
                                'label' => 'Size',
                                'name' => 'size',
                                'aria-label' => '',
                                'type' => 'number',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => 3,
                                'min' => 1,
                                'max' => 20,
                                'placeholder' => '',
                                'step' => 1,
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63d30d2b4babf',
                            ),
                            array(
                                'key' => 'field_63d30d2b62086',
                                'label' => 'Size LG',
                                'name' => 'size_lg',
                                'aria-label' => '',
                                'type' => 'number',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'min' => 1,
                                'max' => 20,
                                'placeholder' => '',
                                'step' => 1,
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63d30d2b4babf',
                            ),
                            array(
                                'key' => 'field_63d30d2b65bd1',
                                'label' => 'Size MD',
                                'name' => 'size_md',
                                'aria-label' => '',
                                'type' => 'number',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'min' => 1,
                                'max' => 20,
                                'placeholder' => '',
                                'step' => 1,
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63d30d2b4babf',
                            ),
                            array(
                                'key' => 'field_63d30d2b69702',
                                'label' => 'Size SM',
                                'name' => 'size_sm',
                                'aria-label' => '',
                                'type' => 'number',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'min' => 1,
                                'max' => 20,
                                'placeholder' => '',
                                'step' => 1,
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63d30d2b4babf',
                            ),
                            array(
                                'key' => 'field_63d30d2b70e12',
                                'label' => 'Color',
                                'name' => 'color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#ffffff',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                                'parent_repeater' => 'field_63d30d2b4babf',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_63d30d2b4f608',
                        'label' => 'Links',
                        'name' => 'links',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_63d30d2b8bc02',
                                'label' => 'Link',
                                'name' => 'link',
                                'aria-label' => '',
                                'type' => 'link',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                                'parent_repeater' => 'field_63d30d2b4f608',
                            ),
                            array(
                                'key' => 'field_63d30d2b8f75f',
                                'label' => 'Default Styles',
                                'name' => 'default_styles',
                                'aria-label' => '',
                                'type' => 'select',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => array(
                                    'link-success' => 'Success',
                                    'link-warning' => 'Warning',
                                    'link-danger' => 'Danger',
                                    'link-default' => 'Default',
                                    'custom' => 'Custom',
                                ),
                                'default_value' => 'link-warning',
                                'return_format' => 'value',
                                'multiple' => 0,
                                'allow_null' => 0,
                                'ui' => 0,
                                'ajax' => 0,
                                'placeholder' => '',
                                'parent_repeater' => 'field_63d30d2b4f608',
                            ),
                            array(
                                'key' => 'field_63d30d2b9334e',
                                'label' => 'Background color',
                                'name' => 'background_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_63d30d2b8f75f',
                                            'operator' => '==',
                                            'value' => 'custom',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                                'parent_repeater' => 'field_63d30d2b4f608',
                            ),
                            array(
                                'key' => 'field_63d30d2b96cb1',
                                'label' => 'Background Hover Color',
                                'name' => 'background_hover_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_63d30d2b8f75f',
                                            'operator' => '==',
                                            'value' => 'custom',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                                'parent_repeater' => 'field_63d30d2b4f608',
                            ),
                            array(
                                'key' => 'field_63d30d2b9a5fd',
                                'label' => 'Text color',
                                'name' => 'text_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_63d30d2b8f75f',
                                            'operator' => '==',
                                            'value' => 'custom',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                                'parent_repeater' => 'field_63d30d2b4f608',
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-call-to-action',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function get_style($type, $fields) {
        $style = [];

        if ('texts' == $type) {
            $rdg_helpers = new Rdg_Blocks_Helpers();

            $style = $rdg_helpers->get_title_sizes($fields);
            $spacing = $fields['spacing'];
            $color = ($fields['color'] != '') ? $fields['color'] : '#ffffff';
            $style[] = 'padding-bottom: '.$spacing.'rem';
            $style[] = 'color: '.$color;

            return implode('; ', $style);
        }
    
        if ('buttons' == $type) {
            $style[] = 'background-color: '.$fields['background_color'];
            $style[] = 'color: '.$fields['text_color'];
    
            return implode('; ', $style);
        }
    
        return '';
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'color-rdg-call-to-action-bg','slug' => 'color-rdg-call-to-action-bg','color' => '#0160ac'],
            ['name' => 'color-rdg-call-to-action-white','slug' => 'color-rdg-call-to-action-bg','color' => '#FFFFFF'],
        ];
    } 

    public function getStylesToloadGeneratePress() {
        return [
            [
                'customSelector' => '.rdg-call-to-action .body .footer .buttons',
                'fontWeight' => '500',
                'fontSize' => '1rem',
            ],
            [
                'customSelector' => '.acf-block-preview .rdg-call-to-action .buttons a',
                'textDecoration' => 'none',
            ],
        ];
    }
}

$rdg_call_to_action_class = new Rdg_Blocks_Call_To_Action();
$rdg_call_to_action_class->init();

return $rdg_call_to_action_class;
