<?php
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_name = BLOCK_RDG_INJURY_REPORT;
    $block_classes = [$block_name];
    $block_injury_report = $rdgb->settings->get_block($block_name);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $titles = get_field('titles');
    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());

    $league = (!empty(get_field('rdg_injury_report_leagues'))) ? get_field('rdg_injury_report_leagues') : null;
    $team = (!empty(get_field('rdg_injury_report_teams'))) ? get_field('rdg_injury_report_teams') : null;
    $select_season = (!empty(get_field('rdg_injury_report_season'))) ? get_field('rdg_injury_report_season') : null;
    $season = $block_injury_report->getSeason($league, $select_season);

    if ($block_injury_report->is_caching()) {
        $items = 0;
        $api_url = get_field('injury_report_api_url', 'option');
        $api_token = get_field('injury_report_api_token', 'option');

        if (!empty($api_url) && !empty($api_token)) {
            $api_attributes = $block_injury_report->get_api_attributes($items, ['league' => $league, 'team' => $team, 'season' => $season]);
            $block_custom_id = (!empty($block['data']['custom_id'])) ? $block['data']['custom_id'] : '';
            $post_id_custom = (!empty($block['data']['post_id'])) ? $block['data']['post_id'] : $post_id;
            $cache_file = $rdgb->helpers->get_cache_name($block_name, $post_id_custom, $block_custom_id);
            $response = $block_injury_report->get_resources($api_attributes, $cache_file);

            if (empty($response->message)) {
                $injuries = $response->json[0]['data-content'][0][0]['injuries'];
            } else {
                $injuries = null;
                $message = $response->message;
            }
        } else {
            $message = __('Configure API connection correctly.');
        }
    }
?>

<div class="rdg-blocks">

    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container content grid-container">
            <?php if (is_array($injuries) && count($injuries) > 0): ?>
                <table>
                    <tr>
                        <th>#</th>
                        <th>Player</th>
                        <th>Location</th>
                        <th>Start Date</th>
                        <th>Status</th>
                        <th>Display Status</th>
                        <th>Note</th>
                    </tr>
                    <?php
                        $i = 1;
                        $players = (function_exists('shMappingTeamPlayers')) ? shMappingTeamPlayers() : [];
                    ?>
                    <?php foreach ($injuries as $injury): ?>
                        <tr>
                            <th><?php echo $i; ?></th>
                            <th>
                                <?php
                                    if (is_user_logged_in() && current_user_can('administrator')) {
                                        echo $rdgb->helpers->getPlayerName($injury['player_id'], $players);
                                    } else {
                                        echo $injury['player_id'];
                                    }
                                ?>
                            </th>
                            <th><?php echo $injury['location']; ?></th>
                            <th><?php echo $injury['start_date']; ?></th>
                            <th><?php echo $injury['status']; ?></th>
                            <th><?php echo $injury['display_status']; ?></th>
                            <th><?php echo $injury['note']; ?></th>
                        </tr>
                        <?php $i++; ?>
                    <?php endforeach; ?>
                </table>
            <?php endif; ?>
        </div>
    </div>
</div>
