<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Sport_Information extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_SPORT_INFORMATION;
    private $block_folder_name = 'rdg-sport-information';
    protected $block_title = 'RDG Sport Information';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'banner', 'secondary', 'secondary banner'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = false;
    protected $is_styles_load = true;
    protected $is_pre_saved = false;

    public function init() {
        $this->register_block();
        $this->register_fields();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_sport_information.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    private function register_fields() {
        add_action( 'acf/include_fields', function() {
            if ( ! function_exists( 'acf_add_local_field_group' ) ) {
                return;
            }
        
            acf_add_local_field_group( array(
            'key' => 'group_6584edc20d05f',
            'title' => 'RDG Sport Information',
            'fields' => array(
                array(
                    'key' => 'field_6585096df9941',
                    'label' => 'Header Title',
                    'name' => 'header_title',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_6584f66f01dd6',
                    'label' => 'Post Block',
                    'name' => 'post_block',
                    'aria-label' => '',
                    'type' => 'group',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'layout' => 'block',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_6584f69401dd7',
                            'label' => 'Show block?',
                            'name' => 'show_block',
                            'aria-label' => '',
                            'type' => 'radio',
                            'instructions' => '',
                            'required' => 1,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'yes' => 'Yes',
                                'no' => 'No',
                            ),
                            'default_value' => 'yes',
                            'return_format' => 'value',
                            'allow_null' => 0,
                            'other_choice' => 0,
                            'layout' => 'horizontal',
                            'save_other_choice' => 0,
                        ),
                        array(
                            'key' => 'field_6584f6ae01dd8',
                            'label' => 'Featured Image',
                            'name' => 'featured_image',
                            'aria-label' => '',
                            'type' => 'image',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_6584f69401dd7',
                                        'operator' => '==',
                                        'value' => 'yes',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'return_format' => 'array',
                            'library' => 'all',
                            'min_width' => '',
                            'min_height' => '',
                            'min_size' => '',
                            'max_width' => '',
                            'max_height' => '',
                            'max_size' => '',
                            'mime_types' => '',
                            'preview_size' => 'medium',
                        ),
                        array(
                            'key' => 'field_6584f6c701dd9',
                            'label' => 'Post Title',
                            'name' => 'post_title',
                            'aria-label' => '',
                            'type' => 'text',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_6584f69401dd7',
                                        'operator' => '==',
                                        'value' => 'yes',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'maxlength' => '',
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                        ),
                        array(
                            'key' => 'field_6584f6dd01dda',
                            'label' => 'Post Excerpt',
                            'name' => 'post_excerpt',
                            'aria-label' => '',
                            'type' => 'wysiwyg',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_6584f69401dd7',
                                        'operator' => '==',
                                        'value' => 'yes',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'tabs' => 'all',
                            'toolbar' => 'full',
                            'media_upload' => 1,
                            'delay' => 0,
                        ),
                        array(
                            'key' => 'field_6584f6e601ddb',
                            'label' => 'Post Link',
                            'name' => 'post_link',
                            'aria-label' => '',
                            'type' => 'link',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_6584f69401dd7',
                                        'operator' => '==',
                                        'value' => 'yes',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'return_format' => 'array',
                        ),
                    ),
                ),
                array(
                    'key' => 'field_6584f7714d10f',
                    'label' => 'Previews Block',
                    'name' => 'previews_block',
                    'aria-label' => '',
                    'type' => 'group',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'layout' => 'block',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_6584f7864d110',
                            'label' => 'Show Block?',
                            'name' => 'show_block',
                            'aria-label' => '',
                            'type' => 'radio',
                            'instructions' => '',
                            'required' => 1,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'yes' => 'Yes',
                                'no' => 'No',
                            ),
                            'default_value' => 'yes',
                            'return_format' => 'value',
                            'allow_null' => 0,
                            'other_choice' => 0,
                            'layout' => 'horizontal',
                            'save_other_choice' => 0,
                        ),
                        array(
                            'key' => 'field_6584fcbe5ed6f',
                            'label' => 'Block Title',
                            'name' => 'block_title',
                            'aria-label' => '',
                            'type' => 'text',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_6584f7864d110',
                                        'operator' => '==',
                                        'value' => 'yes',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'maxlength' => '',
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                        ),
                        array(
                            'key' => 'field_6584fcd45ed70',
                            'label' => 'Vs List',
                            'name' => 'vs_list',
                            'aria-label' => '',
                            'type' => 'repeater',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_6584f7864d110',
                                        'operator' => '==',
                                        'value' => 'yes',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'layout' => 'table',
                            'pagination' => 0,
                            'min' => 1,
                            'max' => 3,
                            'collapsed' => '',
                            'button_label' => 'Add Row',
                            'rows_per_page' => 20,
                            'sub_fields' => array(
                                array(
                                    'key' => 'field_6584fcee5ed71',
                                    'label' => 'Team A',
                                    'name' => 'team_a',
                                    'aria-label' => '',
                                    'type' => 'text',
                                    'instructions' => '',
                                    'required' => 0,
                                    'conditional_logic' => 0,
                                    'wrapper' => array(
                                        'width' => '',
                                        'class' => '',
                                        'id' => '',
                                    ),
                                    'default_value' => '',
                                    'maxlength' => '',
                                    'placeholder' => '',
                                    'prepend' => '',
                                    'append' => '',
                                    'parent_repeater' => 'field_6584fcd45ed70',
                                ),
                                array(
                                    'key' => 'field_6584fcf35ed72',
                                    'label' => 'Team B',
                                    'name' => 'team_b',
                                    'aria-label' => '',
                                    'type' => 'text',
                                    'instructions' => '',
                                    'required' => 0,
                                    'conditional_logic' => 0,
                                    'wrapper' => array(
                                        'width' => '',
                                        'class' => '',
                                        'id' => '',
                                    ),
                                    'default_value' => '',
                                    'maxlength' => '',
                                    'placeholder' => '',
                                    'prepend' => '',
                                    'append' => '',
                                    'parent_repeater' => 'field_6584fcd45ed70',
                                ),
                            ),
                        ),
                        array(
                            'key' => 'field_6584fd155ed73',
                            'label' => 'Previews Link',
                            'name' => 'previews_link',
                            'aria-label' => '',
                            'type' => 'link',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_6584f7864d110',
                                        'operator' => '==',
                                        'value' => 'yes',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'return_format' => 'array',
                        ),
                        array(
                            'key' => 'field_6584fd265ed74',
                            'label' => 'Recaps Link',
                            'name' => 'recaps_link',
                            'aria-label' => '',
                            'type' => 'link',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_6584f7864d110',
                                        'operator' => '==',
                                        'value' => 'yes',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'return_format' => 'array',
                        ),
                    ),
                ),
                array(
                    'key' => 'field_6584f7bc4d111',
                    'label' => 'Handicappers Block',
                    'name' => 'handicappers_block',
                    'aria-label' => '',
                    'type' => 'group',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'layout' => 'block',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_6584f7bc4d112',
                            'label' => 'Show Block?',
                            'name' => 'show_block',
                            'aria-label' => '',
                            'type' => 'radio',
                            'instructions' => '',
                            'required' => 1,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'yes' => 'Yes',
                                'no' => 'No',
                            ),
                            'default_value' => 'yes',
                            'return_format' => 'value',
                            'allow_null' => 0,
                            'other_choice' => 0,
                            'layout' => 'horizontal',
                            'save_other_choice' => 0,
                        ),
                        array(
                            'key' => 'field_6584fbc144059',
                            'label' => 'Block Title',
                            'name' => 'block_title',
                            'aria-label' => '',
                            'type' => 'text',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_6584f7bc4d112',
                                        'operator' => '==',
                                        'value' => 'yes',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'maxlength' => '',
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                        ),
                        array(
                            'key' => 'field_6584fbd84405a',
                            'label' => 'Handicapper Logo',
                            'name' => 'handicapper_logo',
                            'aria-label' => '',
                            'type' => 'image',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_6584f7bc4d112',
                                        'operator' => '==',
                                        'value' => 'yes',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'return_format' => 'array',
                            'library' => 'all',
                            'min_width' => '',
                            'min_height' => '',
                            'min_size' => '',
                            'max_width' => '',
                            'max_height' => '',
                            'max_size' => '',
                            'mime_types' => '',
                            'preview_size' => 'medium',
                        ),
                        array(
                            'key' => 'field_6584fbf14405b',
                            'label' => 'Title',
                            'name' => 'title',
                            'aria-label' => '',
                            'type' => 'text',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_6584f7bc4d112',
                                        'operator' => '==',
                                        'value' => 'yes',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'maxlength' => '',
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                        ),
                        array(
                            'key' => 'field_6584fc184405c',
                            'label' => 'Subtitle',
                            'name' => 'subtitle',
                            'aria-label' => '',
                            'type' => 'text',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_6584f7bc4d112',
                                        'operator' => '==',
                                        'value' => 'yes',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'maxlength' => '',
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                        ),
                        array(
                            'key' => 'field_6584fc244405d',
                            'label' => 'Total',
                            'name' => 'total',
                            'aria-label' => '',
                            'type' => 'text',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_6584f7bc4d112',
                                        'operator' => '==',
                                        'value' => 'yes',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'maxlength' => '',
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                        ),
                        array(
                            'key' => 'field_6584fc384405e',
                            'label' => 'Picks',
                            'name' => 'picks',
                            'aria-label' => '',
                            'type' => 'text',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_6584f7bc4d112',
                                        'operator' => '==',
                                        'value' => 'yes',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'maxlength' => '',
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                        ),
                        array(
                            'key' => 'field_6584fc484405f',
                            'label' => 'Picks Availables',
                            'name' => 'picks_availables',
                            'aria-label' => '',
                            'type' => 'text',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_6584f7bc4d112',
                                        'operator' => '==',
                                        'value' => 'yes',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'maxlength' => '',
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                        ),
                    ),
                ),
                array(
                    'key' => 'field_6584f7bf4d113',
                    'label' => 'Picks Block',
                    'name' => 'picks_block',
                    'aria-label' => '',
                    'type' => 'group',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'layout' => 'block',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_6584f7bf4d114',
                            'label' => 'Show Block?',
                            'name' => 'show_block',
                            'aria-label' => '',
                            'type' => 'radio',
                            'instructions' => '',
                            'required' => 1,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'yes' => 'Yes',
                                'no' => 'No',
                            ),
                            'default_value' => 'yes',
                            'return_format' => 'value',
                            'allow_null' => 0,
                            'other_choice' => 0,
                            'layout' => 'horizontal',
                            'save_other_choice' => 0,
                        ),
                        array(
                            'key' => 'field_6584f94f834e2',
                            'label' => 'Block Title',
                            'name' => 'block_title',
                            'aria-label' => '',
                            'type' => 'text',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_6584f7bf4d114',
                                        'operator' => '==',
                                        'value' => 'yes',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'maxlength' => '',
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                        ),
                        array(
                            'key' => 'field_6584f95d834e3',
                            'label' => 'Category',
                            'name' => 'category',
                            'aria-label' => '',
                            'type' => 'text',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_6584f7bf4d114',
                                        'operator' => '==',
                                        'value' => 'yes',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'maxlength' => '',
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                        ),
                        array(
                            'key' => 'field_6584f962834e4',
                            'label' => 'Time',
                            'name' => 'time',
                            'aria-label' => '',
                            'type' => 'text',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_6584f7bf4d114',
                                        'operator' => '==',
                                        'value' => 'yes',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'maxlength' => '',
                            'placeholder' => 'YYYY-MM-DD HH-MM',
                            'prepend' => '',
                            'append' => '',
                        ),
                        array(
                            'key' => 'field_6584f976834e5',
                            'label' => 'Status',
                            'name' => 'status',
                            'aria-label' => '',
                            'type' => 'text',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_6584f7bf4d114',
                                        'operator' => '==',
                                        'value' => 'yes',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'maxlength' => '',
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                        ),
                        array(
                            'key' => 'field_6584f97f834e6',
                            'label' => 'Teams',
                            'name' => 'teams',
                            'aria-label' => '',
                            'type' => 'repeater',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_6584f7bf4d114',
                                        'operator' => '==',
                                        'value' => 'yes',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'layout' => 'table',
                            'pagination' => 0,
                            'min' => 2,
                            'max' => 2,
                            'collapsed' => '',
                            'button_label' => 'Add Row',
                            'rows_per_page' => 20,
                            'sub_fields' => array(
                                array(
                                    'key' => 'field_6584fa3284f14',
                                    'label' => 'Team Logo',
                                    'name' => 'team_logo',
                                    'aria-label' => '',
                                    'type' => 'image',
                                    'instructions' => '',
                                    'required' => 0,
                                    'conditional_logic' => 0,
                                    'wrapper' => array(
                                        'width' => '',
                                        'class' => '',
                                        'id' => '',
                                    ),
                                    'return_format' => 'array',
                                    'library' => 'all',
                                    'min_width' => '',
                                    'min_height' => '',
                                    'min_size' => '',
                                    'max_width' => '',
                                    'max_height' => '',
                                    'max_size' => '',
                                    'mime_types' => '',
                                    'preview_size' => 'medium',
                                    'parent_repeater' => 'field_6584f97f834e6',
                                ),
                                array(
                                    'key' => 'field_6584fab984f15',
                                    'label' => 'Team name',
                                    'name' => 'team_name',
                                    'aria-label' => '',
                                    'type' => 'text',
                                    'instructions' => '',
                                    'required' => 0,
                                    'conditional_logic' => 0,
                                    'wrapper' => array(
                                        'width' => '',
                                        'class' => '',
                                        'id' => '',
                                    ),
                                    'default_value' => '',
                                    'maxlength' => '',
                                    'placeholder' => '',
                                    'prepend' => '',
                                    'append' => '',
                                    'parent_repeater' => 'field_6584f97f834e6',
                                ),
                            ),
                        ),
                        array(
                            'key' => 'field_6584fafb84f16',
                            'label' => 'Picks Availables',
                            'name' => 'picks_availables',
                            'aria-label' => '',
                            'type' => 'text',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_6584f7bf4d114',
                                        'operator' => '==',
                                        'value' => 'yes',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'maxlength' => '',
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                        ),
                    ),
                ),
                array(
                    'key' => 'field_6585097bf9942',
                    'label' => 'Footer Title',
                    'name' => 'footer_title',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),
            ),
            'location' => array(
                array(
                    array(
                        'param' => 'block',
                        'operator' => '==',
                        'value' => 'acf/rdg-sport-information',
                    ),
                ),
            ),
            'menu_order' => 0,
            'position' => 'normal',
            'style' => 'default',
            'label_placement' => 'top',
            'instruction_placement' => 'label',
            'hide_on_screen' => '',
            'active' => true,
            'description' => '',
            'show_in_rest' => 0,
        ) );
        } );                     
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'color-sport-information-btn-hover','slug' => 'color-sport-information-btn-hover','color' => '#013b6b'],
            ['name' => 'color-sport-information-picks','slug' => 'color-sport-information-picks','color' => '#00bc00'],
            ['name' => 'color-sport-information-picks-available','slug' => 'color-sport-information-picks-available','color' => '#FFFFFF'],
            ['name' => 'color-sport-information-picks-available-bg','slug' => 'color-sport-information-picks-available-bg','color' => '#0160ac'],
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [
            [
                'customSelector' => '.rdg-sport-information .si_container .si_header',
                'fontWeight' =>'700',
                'fontSize' => '1.1rem',
            ],
            [
                'customSelector' => '.rdg-sport-information .si_container .si_content .post_block .title',
                'fontWeight' =>'600',
                'fontSize' => '1.6rem',
            ],
            [
                'customSelector' => '.rdg-sport-information .si_container .si_content .post_block .read_more',
                'fontWeight' =>'bold',
                'textDecoration' => 'underline',
            ],
            [
                'customSelector' => '.rdg-sport-information .si_container .si_content .previews_block .title',
                'fontWeight' =>'600',
                'fontSize' => '1.6rem',
            ],
            [
                'customSelector' => '.rdg-sport-information .si_container .si_content .previews_block .previews_list .list',
                'fontWeight' =>'bold',
                'fontSize' => '1rem',
            ],
            [
                'customSelector' => '.rdg-sport-information .si_container .si_content .previews_block .previews_links .btn',
                'fontWeight' =>'bold',
                'fontSize' => '0.875rem',
                'textTransform' => 'uppercase',
                'textDecoration' => 'none',
            ],
            [
                'customSelector' => '.rdg-sport-information .si_container .si_content .handicappers_block .title',
                'fontWeight' =>'600',
                'fontSize' => '1.6rem',
            ],
            [
                'customSelector' => '.rdg-sport-information .si_container .si_content .handicappers_block .handicappers_container .handicappers_wrapper .handicappers_info',
                'fontWeight' =>'bold',
            ],
            [
                'customSelector' => '.rdg-sport-information .si_container .si_content .handicappers_block .handicappers_container .handicappers_wrapper .handicappers_info .title',
                'fontWeight' =>'700',
                'fontSize' => '1rem',
            ],
            [
                'customSelector' => '.rdg-sport-information .si_container .si_content .handicappers_block .handicappers_container .handicappers_wrapper .handicappers_info .sub_title',
                'fontSize' => '0.8rem',
            ],
            [
                'customSelector' => '.rdg-sport-information .si_container .si_content .handicappers_block .handicappers_container .handicappers_wrapper .handicappers_info .total',
                'fontSize' => '0.8rem',
            ],
            [
                'customSelector' => '.rdg-sport-information .si_container .si_content .handicappers_block .handicappers_container .picks_availables span',
                'fontWeight' =>'bold',
                'fontSize' => '0.875rem',
            ],
            [
                'customSelector' => '.rdg-sport-information .si_container .si_content .picks_block .title',
                'fontWeight' =>'600',
                'fontSize' => '1.6rem',
            ],
            [
                'customSelector' => '.rdg-sport-information .si_container .si_content .picks_block .pick .picks_header',
                'fontSize' => '0.9rem',
            ],
            [
                'customSelector' => '.rdg-sport-information .si_container .si_content .picks_block .pick .picks_header .sport, .rdg-sport-information .si_container .si_content .picks_block .pick .picks_header .status',
                'fontWeight' => '700',
            ],
            [
                'customSelector' => '.rdg-sport-information .si_container .si_content .picks_block .pick .picks_body .teams .team_a p, .rdg-sport-information .si_container .si_content .picks_block .pick .picks_body .teams .team_b p',
                'fontWeight' => '700',
                'fontSize' => '0.8rem',
                'textTransform' => 'uppercase',
            ],
            [
                'customSelector' => '.rdg-sport-information .si_container .si_content .picks_block .pick .picks_body .teams .vs_logo span',
                'fontWeight' => '500',
                'fontSize' => '0.9rem',
            ],
            [
                'customSelector' => '.rdg-sport-information .si_container .si_content .picks_block .pick .picks_availables span',
                'fontWeight' => 'bold',
                'fontSize' => '0.875rem',
            ],
            [
                'customSelector' => '.rdg-blocks .rdg-sport-information .si_container .si_footer',
                'fontWeight' => '400',
                'fontSize' => '1.1rem',
            ],
        ];
    }
}

$rdg_sport_information_class = new Rdg_Blocks_Sport_Information();
$rdg_sport_information_class->init();

return $rdg_sport_information_class;
