# RDG Corp / RDG Blocks Plugin for WordPress

Tags: rdg corp, rdg blocks, rdg, corp
Requires at least: 6.0
Tested up to: 6.0
Requires PHP: 8.1
Stable tag: 1.3.111
License: GPLv3 or later
License URI: http://www.gnu.org/licenses/gpl-3.0.html

# Changelog
-   1.3.111 (2025-12-11)
  * DEV-951-rdg-error-on-sports-picks
    - Fixed rdg-sports-picks block rendering issue by normalizing hierarchy-structured API data
    - Added data normalization to flatten nested array structure when data comes in hierarchy format 
-   1.3.110 (2025-12-10)

-   1.3.109 (2025-12-5)
  * DEV-945-rdg-remove-the-get-all-picks-button-in-handicappers-hub
    - add input on settings for customize URL in packages


-   1.3.107 (2025-12-3)
  * DEV-945-rdg-remove-the-get-all-picks-button-in-handicappers-hub
    - Change the font size for picks available text
-   1.3.106 (2025-12-3)
  * DEV-945-rdg-remove-the-get-all-picks-button-in-handicappers-hub
    - Remove the handicapper name from handicappers cards bottom from partials/api.php L50
    - Change the size of text for picks available adding the rule in assets/scss/main.scss L493-495
-   1.3.105 (2025-12-2)
  * DEV-945-rdg-remove-the-get-all-picks-button-in-handicappers-hub
    - Apply the same number of results (Number of Items input) for every tab on handicappers-hub 


-   1.3.103 (2025-12-1)
  * DEV-945-rdg-remove-the-get-all-picks-button-in-handicappers-hub
    - Remove "Get All PICKS" buttom from handicappers cards


-   1.3.89 (2025-11-18)
  * DEV-925-sh-debug-rdg-blocks-cache-regeneration
    - Added comprehensive diagnostic page for RDG Blocks cache system
    - New admin page: "RDG Blocks Cache > Diagnostic" with full system status
    - Displays WP_CRON status, scheduled cron jobs, Redis connection info, and cache statistics
    - Shows TTL remaining, failed attempt counts, and block status (active/retrying/paused)
    - Lists all RDG Blocks cron jobs with next execution times and intervals
    - Displays sample of cached blocks with detailed metrics (TTL, data status, failure counts)
    - Added button to manually schedule cache regeneration cron if missing
    - CRITICAL FIX: Improved regenerate_cache() to automatically regenerate empty blocks
    - Empty blocks are now detected and regenerated instead of just being marked for deletion
    - Blocks with invalid/empty api_attributes are now automatically regenerated from post content
    - Added validation for api_attributes before attempting API requests
    - Enhanced error handling with detailed logging for regeneration attempts
    - CRITICAL FIX: Fixed cron execution to call regenerate_cache() directly instead of shell_exec
    - Previous implementation used shell_exec('wp rdg_blocks regenerate_cache') which failed if wp-cli not in PATH
    - Now calls regenerate_cache() method directly, making cron execution more reliable
    - Added manual "Regenerate All Cache (inGodWeTrust)" button in diagnostic page
    - Executes inGodWeTrust() directly to create/update block cache structure
    - Added manual "Execute Regenerate Cache (Fill Data)" button in diagnostic page
    - Executes regenerate_cache() directly to fill empty blocks with API data
    - Improved inGodWeTrust() to regenerate blocks that exist but have empty/invalid data
    - Now checks if existing blocks have valid api_response before skipping regeneration
    - Blocks with empty api_response are now regenerated even if they exist in cache list
    - Enhanced cache regeneration logic to handle blocks with empty api_attributes
    - Automatically attempts to rebuild api_attributes from post content when missing
    - Better handling of blocks that fail API requests with retry counter management
    - Comprehensive logging added for all cache operations (creation, regeneration, failures)
    - Diagnostic page shows last cache execution time and cron configuration
    - All manual operations include success/error notifications with detailed messages
    - System now provides complete visibility into cache health and regeneration status
-   1.3.80 (2025-11-10)
  * DEV-905-sh-not-displaying-rdg-blocks
-   1.3.76 (2025-11-06)
  * FIX-critical-cache-loss-prevention-escalated
    - CRITICAL FIX: Prevents cache deletion when no blocks detected on post save
    - Root cause: clearCacheBlock() was deleting ALL cache when $blocks_caching was empty
    - This happened during autosaves, parsing errors, or WordPress temporary saves
    - Now only clears old cache if new blocks are actually detected (count > 0)
    - Preserves existing cache during parsing failures or autosave operations
    - CRITICAL FIX: Retry mechanism before deleting empty cache in regenerate_cache
    - Empty cache is no longer deleted immediately (might be transient Redis error)
    - Checks failed attempt counter before removing blocks from cache list
    - Only removes after RDG_BLOCK_CACHE_FAILED_RETRY (5) failed attempts
    - Malformed cache data now kept for retry instead of immediate deletion
    - CRITICAL FIX: Admin panel no longer auto-deletes empty cache entries
    - Empty blocks remain visible in admin panel for manual regeneration
    - Allows admins to see which blocks need attention instead of hiding them
    - regenerate_cache cron handles cleanup after multiple failed attempts
    - Comprehensive error logging with context for all cache operations
    - Fixes persistent cache loss issues in production environments
    - Significantly more resilient to transient Redis errors and parsing failures
-   1.3.75 (2025-11-05)
  * FIX-cache-constants-and-ttl-improvements
    - Added missing cache configuration constants to prevent undefined constant warnings
    - Defined RDG_BLOCK_CACHE_CLEAR_TIME (300 seconds / 5 minutes before expiration)
    - Defined RDG_BLOCK_CACHE_FAILED_RETRY (5 attempts before pausing)
    - Defined RDG_BLOCK_CACHE_FAILED_RETRY_DELAY (1800 seconds / 30 minutes retry delay)
    - Constants were referenced in class-rdg-blocks-cli.php and class-rdg-blocks-run.php but never defined
    - PHP was treating undefined constants as string literals, breaking cache regeneration logic
    - Implemented minimum TTL of 3 hours for all cached blocks in class-rdg-blocks-cache.php
    - Prevents premature cache expiration for blocks with refresh = 1 hour
    - Improved error logging in regenerate_cache method for better diagnostics
    - Added detailed logging in admin panel cache deletion for troubleshooting
    - Ensures cache regeneration triggers work as originally designed
-   1.3.74 (2025-11-05)
-   1.3.73 (2025-11-03)
  * FIX-rdg-scores-and-odds-date-format-error
    - Fixed Fatal Error 500 in RDG Scores and Odds block caused by date parsing failure
    - Error: "Call to a member function format() on false" at api.php line 8
    - Root cause: API changed date format (removed/modified seconds/milliseconds)
    - Implemented robust multi-format date parser with 5 different format attempts
    - Supports: 'Y-m-d H:i:s', 'Y-m-d H:i', 'Y-m-d\TH:i:s', 'Y-m-d\TH:i:sP', 'Y-m-d\TH:i:s.uP'
    - Added strtotime() as ultimate fallback for unexpected formats
    - Added validation to skip invalid picks instead of crashing entire page
    - Added error logging for debugging: 'RDG Scores and Odds: Invalid date format for game_date'
    - Block now gracefully handles date format changes from API without Fatal Errors
    - Maintains full backward compatibility with old date formats
  * FIX-rdg-picks-vs-date-format-robustness
    - Applied same robust date parser to RDG Picks Vs block (partials/api.php)
    - Replaced vulnerable DateTime::createFromFormat() with multi-format parser
    - Removed try-catch that was hiding date parsing failures (dates showing blank)
    - Now supports all 5 date formats + strtotime fallback
    - Block will display dates correctly even when API format changes
  * FIX-rdg-picks-vs-multi-date-format-robustness
    - Applied same robust date parser to RDG Picks Vs Multi block (partials/api.php)
    - Replaced vulnerable DateTime::createFromFormat() with multi-format parser
    - Removed try-catch that was hiding date parsing failures (dates showing blank)
    - Now supports all 5 date formats + strtotime fallback
    - Block will display dates correctly even when API format changes
    - All 3 blocks (Scores and Odds, Picks Vs, Picks Vs Multi) now use consistent date handling
  * FIX-comprehensive-date-parsing-audit-all-blocks
    - Performed comprehensive audit of all blocks using DateTime::createFromFormat()
    - Found 9 files total: 3 already fixed + 6 additional vulnerable blocks
    - Fixed 3 CRITICAL blocks without try-catch (Fatal Error 500 if date format changes):
      * sh-query-posts/main.php - line 1032 - chained call without protection
      * rdg-posts-ajax/partials/posts.php - line 27 - chained call without protection
      * rdg-latest-post/template.php - line 71 - chained call without protection
    - Fixed 3 blocks with try-catch (dates showing blank if format changes):
      * rdg-sport-betting-odds/template.php - supports date-only format (Y-m-d)
      * sh-query-posts/template.php - 2 occurrences (lines 147 and 273)
      * rdg-posts-list/template.php - line 98
    - All blocks now use consistent robust multi-format date parser
    - Supports 5 formats: Y-m-d H:i:s, Y-m-d H:i, Y-m-d\TH:i:s, Y-m-d\TH:i:sP, Y-m-d\TH:i:s.uP
    - strtotime() fallback for unexpected formats
    - Total blocks protected: 10 (Scores and Odds, Picks Vs, Picks Vs Multi, Sport Betting Odds, SH Query Posts x2, Posts List, Posts Ajax, Latest Post)
-   1.3.72 (2025-11-01)
  * DEV-875-rdg-blocks-correct-rdg-blocks-picks-vs-multi
  * FIX-rdg-admin-cappers-simple-hierarchy-wrapped-response
    - Fixed RDG Admin Cappers Simple block not rendering data from new API format
    - Added normalizeApiResponse() method to handle hierarchy-wrapped responses
    - API now returns data wrapped in hierarchy key: {"277": [...picks...]}
    - Applied normalization in template.php when reading from cache
    - Uses ReflectionClass to access private normalizeApiResponse() method
    - Maintains backward compatibility with old API format (flat array)
    - Block now correctly extracts picks from hierarchy wrapper
  * FIX-multiple-blocks-duplicate-choose-option
    - Fixed duplicate "Choose an option" in RDG Picks Vs block League dropdown
    - Standardized dropdown key from '' (empty string) to '0' in getPicksVsOptions()
    - Fixed duplicate "Choose an option" in RDG Top Cappers Sport block League dropdown
    - Added "Choose an option" to getTopCappersSportOptions() PHP response
    - Comprehensive fix applied to all blocks with Sport → League dynamic loading
    - Blocks corrected: rdg-picks-vs, rdg-top-cappers-sport
    - Fixed duplicate "Choose an option" in RDG Picks Vs Multi block League dropdown
    - Matches the same fix applied to rdg-picks-vs-categories in v1.3.70
- 1.3.71 (2025-10-31)
  * DEV-863-error-sas-rdg-picks-vs-categories-fix-version
- 1.3.70 (2025-10-31)
  * FIX-rdg-picks-vs-categories-optional-league-and-dropdown-duplicates
    - Made League field optional in RDG Picks Vs Categories block (required => 0)
    - Block now works with Sport only OR Sport + League selections
    - If League selected → API receives hierarchy=[league_id] (e.g., hierarchy=269)
    - If only Sport selected → API receives hierarchy=[sport_id] (e.g., hierarchy=216)
    - Fixed duplicate "Choose an option" in League dropdown (both PHP and JavaScript)
    - Standardized all dropdown keys to '0' instead of mixing '0' and '' (empty string)
    - Updated getPicksVsCategoriesOptions() to use ['0' => 'Choose an option']
    - Removed manual "Choose an option" injection in JavaScript
    - Updated get_categories_sports() to handle both league and sport hierarchies
    - Enhanced hierarchy ID cleaning to support both league (L271) and sport (G216) prefixes
-   1.3.69 (2025-10-31)
  * FIX-redis-connection-platform-sh
    - Fixed Redis connection issues in Platform.sh and multi-host environments
    - Corrected getRedisConnect() method in class-rdg-blocks-cache.php
    - Changed connection logic to connect BEFORE calling ping() to prevent fallback to 127.0.0.1
    - Added conditional authentication: only calls auth() if WP_REDIS_PASSWORD is not empty
    - Prevents "Redis server 127.0.0.1:6379 went away" errors in Platform.sh production
    - Improved error logging: now includes host and port information for debugging
    - Compatible with all environments: Platform.sh (redis.internal, no password), Local (127.0.0.1 with password), AWS ElastiCache, Docker, etc.
    - Resolves "Redis connection failed" errors in rdg-blocks admin panel
    - Maintains full backward compatibility with existing Redis configurations
-   1.3.68 (2025-10-30)
  * FIX-rdg-picks-vs-categories-sport-league-loading
    - Fixed RDG Picks Vs Categories block - Sport → League dropdown not loading
    - Added missing enqueue_assets to load JavaScript and AJAX variables
    - JavaScript file now properly loads with rdg_picks_vs_categories_var.ajaxurl defined
    - Optimized loadLeagues() with 3-strategy approach matching rdg-picks-vs-multi
    - Strategy 1: Detect sport from saved league value across all sports
    - Strategy 2: Extract sport from POST data in same repeater row
    - Strategy 3: Load all leagues as fallback to maintain saved values after refresh
    - Simplified JavaScript to use direct event listener (matching rdg-picks-vs-multi pattern)
    - League dropdown now dynamically loads when Sport is selected in repeater
    - Fixed league persistence after page refresh in ACF repeater context
-   1.3.67 (2025-10-29)
  * DEV-857-rdg-blocks-adapt-rdg-picks-vs-to-new-api-structure
    - Adapted RDG Picks Vs block to handle new API response structure
    - API now returns picks wrapped in hierarchy-keyed object: {"263": [...picks...]}
    - Added normalizeApiResponse() helper function to handle both old and new formats
    - Updated getResourcesAjax() to extract picks from hierarchy key
    - Updated get_picks_vs_data() AJAX handler with same normalization logic
    - Fixed template.php to normalize cached data with hierarchy structure
    - Cache now correctly extracts picks from hierarchy key when loading cached data
    - Maintains full backward compatibility with old API structure
    - New endpoint: /api/picks-by-sports with parameters gamesToShow, hierarchy, showProbs
    - Response now includes additional fields: id_league, league_name, visitor_image_type, home_image_type
    - Automatic fallback to first hierarchy if specific hierarchy ID not found
    - No breaking changes for existing blocks using old API format
-   1.3.66 (2025-10-29)
  * DEV-856-rdg-blocks-rdg-scores-and-odds-double-signs
    - Fixed double sign issue (++) in RDG Scores and Odds block odds display
    - Improved format_odds() function to detect existing signs before adding new ones
    - Added preg_match('/^[+-]/', $value) validation to prevent double sign concatenation
    - Refactored MONEYLINE section to explicitly check for existing signs
    - Enhanced SPREAD section with better string separation and null handling
    - Improved TOTAL section with clearer variable construction
    - Fixed display of positive odds that already included "+" sign from API
    - Example fix: "++58" now correctly displays as "+58"
    - All odds sections (SPREAD, TOTAL, MONEYLINE) now consistently handle signed values
    - Added inline comments for better code maintainability
    - No linter errors introduced
-   1.3.65 (2025-10-28)
  * DEV-854-rdg-blocks-fix-rdg-picks-vs-multi-league-persistence
    - Fixed league field persistence in RDG Picks Vs Multi block after page refresh
    - Implemented multi-strategy approach in loadLeagues() function for repeater context
    - Strategy 1: Detect sport from saved league value by searching across all sports
    - Strategy 2: Extract sport value from POST data in same repeater row
    - Strategy 3: Load all possible leagues as fallback to ensure saved values remain visible
    - Resolves issue where league selections were not maintained after page reload
    - Now matches the correct behavior implemented in RDG Picks Vs block
    - League options now properly populate even when fields are inside ACF repeater
-   1.3.64 (2025-10-27)
  * DEV-853-rdg-block-fix-hierarchy-id
    - Fixed RDG Picks Vs block to use correct hierarchy ID after sh-mapping fix
    - Changed API parameter from hierarchy + sports_hierarchy to only hierarchy
    - Removed sports_hierarchy parameter (no longer needed after DEV-853 sh-mapping fix)
    - Now uses league ID (L269) directly as hierarchy parameter
    - Example: hierarchy=269 instead of hierarchy=216&sports_hierarchy=269
    - Removed unused sport_id variable and related logic
    - Made League field required (required => 1) instead of optional
    - Removed arbitrary default value - returns null if league is missing
    - Fixed RDG Sport Betting Odds block to use hierarchy instead of sports_hierarchy
    - Changed parameter from sports_hierarchy to hierarchy for consistency
    - Made League field required (required => 1) for data integrity
    - Returns null if no league selected instead of using arbitrary defaults
    - Fixed RDG Scores and Odds block to use hierarchy instead of sports_hierarchy
    - Changed parameter from sports_hierarchy to hierarchy for consistency
    - Made League field required (required => 1) for data integrity
    - Returns null if no league selected instead of using arbitrary defaults
    - Transformed RDG Admin Cappers Simple block to use Sport + League structure
    - Replaced single Category field with Sport and League fields
    - Changed from getSporstHierarchyOptions() to shMappingHierarchySports() for sports
    - Added dynamic League field using shMappingHierarchyFamily()
    - Added loadLeagues() function for PHP ACF field population
    - Added getAdminCappersSimpleOptions() AJAX handler for league loading
    - Created JavaScript file for Sport→League dynamic updates
    - Made League field required (required => 1) for data integrity
    - Returns null if no league selected instead of using arbitrary default (130)
    - Maintained backward compatibility with old 'category' field
    - Transformed RDG Sports Picks block to use Sport + League structure
    - Changed from getSporstHierarchyOptions() to shMappingHierarchySports() for sports
    - Added dynamic League field using shMappingHierarchyFamily()
    - Added loadLeagues() function for PHP ACF field population
    - Added getSportsPicksOptions() AJAX handler for league loading
    - Created JavaScript file (rdg-sports-picks.js) for Sport→League dynamic updates
    - Made League field required (required => 1) for data integrity
    - Returns null if no league selected instead of using arbitrary default (130 for Baseball)
    - Updated getApiParams() to include 'sport' and 'league' parameters
    - Hidden old Category field (deprecated) - replaced by Sport + League
    - Kept old field for backward compatibility with existing posts
    - Sport and League fields display side by side (50% width each)
    - Fixed RDG Picks Vs Categories block to use correct hierarchy IDs
    - Changed from getSporstHierarchyOptions() to shMappingHierarchySports()
    - Added ID cleaning logic to remove prefixes (G215 -> 215, L269 -> 269)
    - Fixed get_sports_categories_url_params() to strip non-numeric characters from hierarchy IDs
    - No structural changes needed - block already uses correct hierarchy parameter
    - Ensures category selections use correct level 2 group IDs after sh-mapping fix
    - Maintained backward compatibility with old 'category' field
    - Maintained backward compatibility fallback to sports field for old blocks
    - Related to DEV-853-sh-mapping fix that corrected clearHierarchy() to return level 2 group ID

-   1.3.63 (2025-10-25)
  * DEV-848-rdg-block-update-rdg-top-cappers-sport-block
    - Updated RDG Top Cappers Sport block to match RDG Picks Vs structure
    - Changed Sports field to use shMappingHierarchySports() (9 main categories)
    - Added dynamic League field populated via AJAX when Sport changes
    - League field auto-loads using PHP acf/prepare_field filter
    - Updated API parameters: sports (sport ID) and leagues (league ID)
    - Fixed parameter order (was inverted initially)
    - Cleaned G and L prefixes from IDs using preg_replace
    - Fixed array navigation in api.php to correctly access nested Sports structure
    - Fixed number_of_items field to properly display multiple cappers (was hardcoded to 1)
    - Maintained backward compatibility with existing blocks using old 'sports' field
    - Added JavaScript for dynamic Sport-League selection with block ID scoping
-   1.3.62 (2025-10-25)
  * DEV-839-rdg-blocks-fix-rdg-picks-vs-league-autoload
    - Fixed handling multiple block instance
    - Fixed league field pre-population when editing existing blocks
-   1.3.61 (2025-10-25)
  * DEV-839-rdg-blocks-update-rdg-picks-vs-block-functionality
    - Updated RDG Picks Vs block to match RDG Scores and Odds block structure
    - Changed Sports field to use shMappingHierarchySports() (9 main categories)
    - Added dynamic League field populated via AJAX when Sport changes
    - Added Game Part field (None/Game) for game filtering
    - Added Show Props field (radio 0/1) for props visibility
    - Fixed API parameters: hierarchy (league ID) and sports_hierarchy (sport ID)
    - Cleaned G and L prefixes from IDs using preg_replace
    - Fixed validation to allow num_picks = 0 as valid value
    - Maintained backward compatibility with existing blocks using old 'category' field
    - Added ACF loadLeagues() hook for dynamic field population
    - Implemented getPicksVsOptions AJAX handler for league loading
-   1.3.60 (2025-10-24)
  * DEV-838-rdg-blocks-review-rdg-sport-betting-odds-block-functionality
    - Aligned RDG Sport Betting Odds block with RDG Scores and Odds block structure
    - Changed Sports field to use shMappingHierarchySports() (9 main categories instead of 137 items)
    - Added dynamic League field populated via AJAX when Sport changes
    - Removed legacy third select input (sport_betting_odds_sports_categories)
    - Added Game Part field (None/Game) with showOnlyParents support
    - Changed Date Type from radio (Auto/Custom) to select with 5 options (Latest/Next 3/Next 7/Specific/Range)
    - Added conditional date fields: From day, To day, and Specific Date
    - Changed Quantity label from "Number of Items" to match Scores and Odds
    - Updated API parameter from leagues_hierarchy to sports_hierarchy
    - Moved API token to end of URL for consistency
    - Added ACF loadLeagues() hook for dynamic field population
-   1.3.59 (2025-10-20)
  * DEV-837-rdg-blocks-Replace-sport_external-field-name-with-sport_name-in-pick-headers
    - Picks header field was replaced
-   1.3.57 (2025-08-21)
  * DEV-746-rdg-block-investigate-and-debug-wordpress-post-performance-issues
    - Change timeout in api request
-   1.3.56 (2025-08-14)
  * DEV-740-fix-uncaught-typeerror-for-count-function-with-invalid-argument-type
    - Fix data counting
-   1.3.55 (2025-08-12)
  * DEV-738-validate-response-block-top-cappers-sport
    - Validate response in block top cappers sport
-   1.3.54 (2025-08-05)
  * DEV-693-migrate-cache-to-redis
    - updated sports-picks, admin-cappers-simple, picks-vs-category, sport-betting-odds, top-cappers-sport.
-   1.3.53 (2025-07-01)
  * DEV-708-refactor-rdg-sas-navbar-block
    - The rdg sas navbar block was refactored.
-   1.3.52 (2025-04-14)
  * DEV-616-scores-and-odds
    - New endpoint implemented for RDG Scores and Odds block.
-   1.3.51 (2025-04-14)
  * DEV-611-rdg-blocks-picks-vs-multiple
    - Block RDG Pick Vs Multi added.
-   1.3.50 (2025-04-09)
  * DEV-619-sas-page-section-broken
    - Set a default fallback image.
    - Check the images and, if there is an error, remove the srcset attribute.
    - Use the src image as a fallback, if there is an error with th src image use the dafault fallbak image    
-   1.3.49 (2025-04-08)
  * DEV-606-sas-check-the-responsive-menu
-   1.3.48 (2025-04-02)
  * DEV-605-pick-vs-cls
    - Defining width and height to the logo teams in Block Pick Vs.
-   1.3.47 (2025-04-02)
  * DEV-583-leaderboard-block-update
    - The leaderboard block is updated by applying multiple filters.
-   1.3.46 (2025-03-26)
  * DEV-601-rdg-block-remove-code-from-block-top-capper-by-sport
-   1.3.45 (2025-03-21)
  * DEV-586-rdg-blocks-lazy-load-youtube-video-block
    - RDG Sh Youtube Video to add lazy-loading videos.
    - Remove separator
-   1.3.44 (2025-03-25)
  * DEV-594-rdg-blocks-scores-and-odds-block-add-parameters
    - Add parameters to scores and odds block
-   1.3.43 (2025-03-19)
  * bugfix/DEV-589-rdg-blocks-rdg-promote-site-bug
    - RDG Promote Site bug fixed.
-   1.3.42 (2025-03-18)
  * bugfix/DEV-575-sas-mobile-login-and-signup-butt
    - Fix sas navarbar iOS icons.
-   1.3.41 (2025-03-14)
  * DEV-567-rdg-blocks-parlay-calculator
    - Block Parlay Calculator added.
-   1.3.40 (2025-03-10)
  * DEV-561-sas-show-top-handicapper-by-league-on-homepage
    - Update rdg-blocks handicappers sport, added theme option
-   1.3.39 (2025-03-07)
  * DEV-552-scores-and-odds-bug-New
    - RDG Scores and odds block updated
    - Block rendering with API is limited
-   1.3.38 (2025-03-05)
  * DEV-547-rdg-blocks-handicapper-pick-resu
    - Block Handicapper pick results added.
-   1.3.37 (2025-02-27)
  *  DEV-541-rdg-blocks-latest-option-not-working-on-rdg-team-schedules
    - Correct seasons order and add latest option with first key.
-   1.3.36 (2025-02-25)
  *  DEV-488-sas-scores-and-odds-pages
    - Block Scores and Odds added.
    - Need to add the preview button integration.
    - Fixed an error with the date time.
-   1.3.35 (2025-02-05)
  *  DEV-481-rdg-blocks-rdg-team-schedules-changes
    - Avoid infinite loop when week does not exist.
-   1.3.34 (2025-02-05)
  *  DEV-482-handicappers-ranking-block
    - The RDG Handicappers Hub block was created.
-   1.3.33 (2025-01-31)
  *  DEV-503-rdg-blocks-agregar-preview-image-y-description
    - Add description and preview image to the blocks in RDG-blocks plugin.
-   1.3.31 (2024-12-18)
  *  DEV-479-update-description-query-posts-block
    - Update description in query posts block.
-   1.3.30 (2024-12-17)
  *  DEV-478-change-rdg-picks-vs
    - RDG Picks vs. Block Links Attributes Updated.
-   1.3.29 (2024-12-12)
  *  DEV-468-validate-acf-activation
    - Validate and alert about acf plugin dependency.
-   1.3.28 (2024-11-28)
  *  DEV-465-sas-bug-on-menu
    - Fixed bug on sas navbar.
-   1.3.27 (2024-11-19)
  *  DEV-300-create-trends-block
    - Type filter applied in the trends block.
-   1.3.26 (2024-10-28)
  *  DEV-452-sh-query-posts-change
    - Links are implemented on the posts of the SH Query Posts block.
-   1.3.25 (2024-10-19)
  *  bugfix/DEV-445-sas-mobile-menu-issue
    - Adjusted the style of the RDG SAS Navbar block.
-   1.3.24 (2024-10-17)
  *  DEV-366-make-header-responsive
    - Adjusted the style of the RDG SAS Navbar block.
-   1.3.23 (2024-10-09)
  *  bugfix/DEV-440-case-sensitive-issue-on-blog-dro
    - Fixing sh query posts bugs.
-   1.3.22 (2024-09-26)
  *  DEV-422-problem-on-rdg-custom-post-type-list-block
    - Update cpt list, remove quantity condition, get public posts type from database.
-   1.3.21 (2024-09-26)
  *  DEV-405-previews-hub-page-design
    - SH Query Posts block text thickness adjusted.
-   1.3.20 (2024-09-25)
  *  DEV-405-previews-hub-page-design
    - SH Query Posts block is finalized.
-   1.3.19 (2024-09-24)
  *  fix/DEV-406-rdg-carousel
    - RDG Carousel block fixed.
-   1.3.18 (2024-09-23)
  *  DEV-406-sas-expert-betting-guide.
    - RDG Carousel block added.
-   1.3.17 (2024-09-06)
  *  DEV-396-repair-block-sport-betting-odds.
    - SH Mapping 1.0.16 was implemented.
    - Fixed creating categories with multiple blocks in the same place.
-   1.3.16 (2024-08-27)
  *  DEV-371-rgd-blocks-secondary-banner-link.
    - Add link attributes, change image position in mobile.
-   1.3.15 (2024-08-27)
  * DEV-393-fix-card-rdg-picks-vs.
    - Fixed the card size in the RDG Picks Vs block.
-   1.3.14 (2024-08-27)
  * DEV-322-expert-betting-guide.
    - RDG Sport Betting Odds block is finalized.
    - Rebase is performed on main.
    - The version was updated.
-   1.3.13 (2024-07-26)
  * DEV-322-expert-betting-guide.
    - RDG Picks Vs Block Updated.
-   1.3.12.5 (2024-08-26)
  * fix/DEV-363-navbar.
    - Changing the SAS Navbar to use the default WP Search Form
-   1.3.12.4 (2024-08-20)
  * fix/DEV-363-navbar.
    - SAS Navbar fix.
-   1.3.12.3 (2024-08-19)
  * DEV-363-test-new-navbar.
    - SAS Navbar minor changes.
-   1.3.12.2 (2024-08-19)
  * DEV-363-test-new-navbar.
    - SAS Navbar test 2.
-   1.3.12.1 (2024-08-18)
  * DEV-363-test-new-navbar.
    - SAS Navbar added.
    - Adjusted the style of the RDG Picks Vs block.
    - RDG Latest Post Block Updated.
-   1.3.12 (2024-07-18)
  * DEV-343-injury-report-design.
    - The RDG Injury Report block is finalized.
-   1.3.11 (2024-06-25)
  * DEV-352-fix-folder-path-upload.
    - Updated the way to obtain the upload folder.
-   1.3.10 (2024-06-25)
  * DEV-342-create-injury-report-block
    - The injury report part 2 block is completed.
-   1.3.8.1 (2024-06-10)
  * DEV-321-sas-rdg-sports-picks-vs-gutenber
    - Sports picks vs css variables changed.
-   1.3.8 (2024-06-07)
  * DEV-321-sas-rdg-sports-picks-vs-gutenber
    - Sports picks vs colors changed.
-   1.3.7.2 (2024-05-24)
  * DEV-315-block-promote-site
    - Padding footer changed.
-   1.3.7.1 (2024-05-23)
  * DEV-315-block-promote-site
    - Claim btn acf changed to acf link.
    - Terms and conditions are now a acf link.
-   1.3.7 (2024-05-23)
  * DEV-315-block-promote-site
    - Changes in Block RDG Promote site.
    - Site name now is not required.
    - Ul margin removed.
    - More width to the logo.
-   1.3.6 (2024-05-03)
  * DEV-256-link-whisper-error
    - Fixed rdg-admin-cappers block.
-   1.3.5 (2024-05-10)
  * DEV-247-top-cappers-change
      - The RDG Top Cappers Sport block was created.
-   1.3.4 (2024-05-07)
  * DEV-256-link-whisper-error
      - Fixed rdg-post-list block.
-   1.3.3 (2024-04-30)
  * DEV-256-rdg-blocks-cross-platform
    - Updated rdg-sports-picks block.
-   1.3.2 (2024-04-30)
  * DEV-256-rdg-blocks-cross-platform
    - Variable debrock is defined to determine the destination of the images.
-   1.3.1 (2024-04-30)
  * DEV-256-rdg-blocks-cross-platform
    - The isInstallGeneratePress method is updated.
-   1.3.0 (2024-04-29)
  * DEV-256-rdg-blocks-cross-platform
    - Styles and colors are homologated.
    - Multiple issues fixed.
-   1.2.35 (2024-03-25)
  * DEV-238-rdg-top-sites
    - Refactored rdg-top-sites block.
-   1.2.34 (2024-04-17)
  * DEV-250-padding-on-blog-posts
    - Add padding to post list.
-   1.2.33 (2024-04-04)
  * DEV-263-fix-manifest-filepath
    - The path of the manifest file is defined as an internal file.
-   1.2.32 (2024-03-25)
  * DEV-255-fix-fields-keys
    - Keys for multiple fields are repaired.
-   1.2.31 (2024-03-25)
  * DEV-238-rdg-top-sites
    - Finished rdg-top-sites block.
-   1.2.30 (2024-03-12)
  * DEV-222-rdg-team-schedule-block
    - Finish the first version of the Team Schedules Block.
-   1.2.29 (2024-03-08)
  * DEV-249-block-recommended-site-part-2
    - Create promote site block
    - Fix text style
    - Place block form inside a repeater and display a site each time the page is reloaded
-   1.2.28 (2024-02-09)
  * DEV-222-rdg-team-schedule-block
    - Block RDG Team Schedules added.
-   1.2.27.7 (2024-02-22)
  * feature/DEV-237-block-recommended-site
    - Update style
-   1.2.27.6 (2024-02-22)
  * feature/DEV-237-block-recommended-site
    - Fix text style
-   1.2.27.5 (2024-02-19)
  * feature/DEV-237-block-recommended-site
    - Include missing dist folder
-   1.2.27.4 (2024-02-16)
  * feature/DEV-237-block-recommended-site
    - Included ccs rules to mobile devices
-   1.2.27.3 (2024-02-15)
  * feature/DEV-237-block-recommended-site
    - Place block form inside a repeater and display a site each time the page is reloaded.
-   1.2.27.2 (2024-02-14)
  * feature/DEV-237-block-recommended-site
    - Include class to logo size.
-   1.2.27.1 (2024-02-12)
  * feature/DEV-237-block-recommended-site
    - Remove color text style.
-   1.2.27 (2024-02-09)
  * feature/DEV-237-block-recommended-site
    - Block RDG Block Promote Site.
-   1.2.26 (2025-01-25)
  * feature/DEV-231-rdg-blocks-integrate-endpoint-on
    - Block RDG Membership Info api feature added.
-   1.2.25 (2025-01-10)
  * DEV-226-rdg-blocks-new-groups-block
    - Block RDG Membership Info added.
-   1.2.24 (2023-12-22)
  * bugfix/DEV-221-error-on-rdg-sport-information-b
    - RDG Sport Information fixed.
-   1.2.23 (2023-12-06)
  * DEV-213-limit-gambling-center-categories
    - New block sport information added.
-   1.2.22 (2023-12-06)
  * fix/1.2.22
    - New block sport information added.
    - Fix block sport information.
-   1.2.21 (2023-12-04)
  * DEV-196-top-cappers-integration
    - Added compatibility to work without platform.
-   1.2.20 (2023-12-04)
  * DEV-209-create-bookie-selector-block
    - The link options were created.
-   1.2.19 (2023-12-02)
  * DEV-209-create-bookie-selector-block
    - New sibar is finished.
-   1.2.18 (2023-11-29)
  * DEV-203-block-not-filtering-by-category
    - RDG post list block is repaired.
-   1.2.17 (2023-11-15)
  * DEV-186-integrate-blocks-with-WPML
    - The translations in the blocks have been completed.
-   1.2.16 (2023-11-08)
  * DEV-183-images-being-crop
    - The post-list image size is modified.
-   1.2.15 (2023-11-06)
  * DEV-182-post-list-update
    - Added optional flexbox in rdg posts list block.
-   1.2.14 (2023-11-02)
  * DEV-179-change-on-function
    - get_image_source method was fixed.
-   1.2.13 (2023-10-17)
  * DEV-178-rdg-blocks-replace-get-image-sou
    - Get image source function updated.
-   1.2.12 (2023-10-17)
  * DEV-173-rdg-blocks-custom-post-types-on-blocks
    - Show CTP automatically.
    - The task is completed.
-   1.2.11 (2023-10-09) 
    * DEV-171-fix-pre-save-blocks
        - Redis reading and writing is repaired.
-   1.2.10 (2023-10-07) 
    * DEV-171-fix-pre-save-blocks
        - Fix pre save blocks.
-   1.2.9 (2023-10-07) 
    * DEV-103-new-plugin-development
        - Branch where game blocks started.
-   1.2.8 (2023-09-21) 
    * DEV-166-select-post-type-on-posts-list
        - Fix pre save blocks
-   1.2.7 (2023-09-20) 
    * DEV-166-select-post-type-on-posts-list
        - The installation of acfe is validated.
        - Support for multiple post types in rdg posts list block is allowed.
-   1.2.6 (2023-09-14) 
    * DEV-146-rdg-blocks-categories-maintenance
        - Categories maintenance opction to fetch data from api.
-   1.2.5 (2023-09-12) 
    * DEV-162-bug-rdg-picks-vs
        - Log and block cache are created with API.
-   1.2.4 (2023-09-11) 
    * DEV-139-rdg-blocks-leaderboard-block-res
        - Leaderboard Block Responsiveness.
-   1.2.3 (2023-09-08) 
    * DEV-158-rdg-blocks-alt-tag-for-images-on
        - Alt tag for images on blocks rdg-logo-team and rdg-image-column.
-   1.2.2 (2023-09-07)
    * DEV-156-Picks-vs-bug
        - Block debugging is implemented.
-   1.2.1 (2023-09-05)
    * DEV-145-select-post-type-to-show
        - Added support for multiple post types to the rdg lates post block.
-   1.2.0 (2023-09-01)
    * DEV-144-select-post-yype-and-url
        - Remove unnecessary form code.
-   1.1.56 (2023-08-29)
    * DEV-141-sidebar-block
        - The rdg-best-pph-sites block was created.
        - The rdg-gambling-center block was created.
-   1.1.55 (2023-08-23)
    * DEV-136-add-leaderboard-pagination
        - Added paging to the rdg-leader-board block.
-   1.1.54 (2023-08-21)
    * DEV-128-create-cpt-list-block
        - cpt list block finished.
-   1.1.53 (2023-08-01)
    * DEV-107-rdg-blocks-backend-scripts
        - Backend-scripts.js now only used in wp-admin.
-   1.1.52 (2023-07-25)
    * DEV-101-resources-images-optimization
        - Fixed blocks settings menu.
-   1.1.51 (2023-07-24)
    * DEV-100-rdg-blocks-fix-title-picks-vs-categories
        - Category titles are repaired.
-   1.1.50 (2023-07-24)
    * DEV-99-rdg-blocks-rdg-posts-list-bug
        - Adjusted RDG posts list block design.
-   1.1.49 (2023-07-21)
    * DEV-98-sas-update-rdg-blocks-plugin
        - RDG Memberships fixed.
-   1.1.48 (2023-07-21)
    * DEV-86-blocks-links-api
        - Customization of links in multiple blocks is allowed.
-   1.1.47 (2023-07-20)
    * DEV-86-picks-vs-block-change
        - Adjustment in the link of the block picks vs categories.
-   1.1.46 (2023-07-20)
    * DEV-97-rdg-blocks-change-content-alignme
        - RDG Pick Vs and Pick List justify content changed to space-between.
-   1.1.45 (2023-07-20)
    * DEV-86-picks-vs-block-change
        - The revision of blocks with api is finished.
-   1.1.44 (2023-07-18)
    * DEV-87-rdg-blocks-api-calls-new-format
        - Updated block request to new format.
        - Fixed multiple changes.
-   1.1.43 (2023-07-12)
    * DEV-87-rdg-blocks-api-calls-new-format
        - New format changed in rdg leaderboad, admin cappers simple, sports picks and sports picks vs.
-   1.1.42 (2023-07-12)
    * DEV-84-rdg-blocks-changes-rdg-posts-ajax
        - RDG Posts List author added and position of header changed.
        - RDG Posts Ajax read more deleted and image is now a hyperlink.
-   1.1.41 (2023-07-11)
    * DEV-82-rdg-blocks-empty-block
        - The operation of the block cache was verified. Adjusted block picks vs.. 
-   1.1.40 (2023-07-11)
    * DEV-81-ajax-not-working
        - The way to obtain the url is changed. 
-   1.1.39 (2023-07-10)
    * bugfix/DEV-81-ajax-not-working
        - Url hardcoded fixed. 
-   1.1.38 (2023-07-10)
    * DEV-81-ajax-not-working
        - The origin of the url in the ajax posts block was modified. 
-   1.1.37 (2023-06-29)
    * DEV-73-sh-remove-inline-style
        - Multiple styles are modified. styles are minified. 
-   1.1.36 (2023-06-29)
    * DEV-69-rdg-blocks-leaderboard-block-change
        - Unnecessary jquery inclusion is removed. 
-   1.1.35 (2023-06-29)
    * DEV-69-rdg-blocks-leaderboard-block-change
        - Added sortable to leaderboard block. 
-   1.1.34 (2023-06-28)
    * DEV-70-sh-remove-bootstrap_custom.js
        - Bootstrap_custom.js commented. 
-   1.1.33 (2023-06-27)
    * DEV-67-rdg-blocks-update-fields
        - Changed api fields updated. 
-   1.1.32 (2023-06-22)
    * DEV-60-rdg-blocks-shortpixel-integration
        - Image conversion with shortpixel is finished. 
-   1.1.31 (2023-06-19)
    * DEV-58-rdg-blocks-resources-page-for-jquery
        - Menu is created to select jquery version. 
-   1.1.30 (2023-06-17)
    * DEV-55-rdg-blocks-integrate-admin-capper-simple-block-to-api
        - API implementation in simple rdg admin cappers block is finished. 
-   1.1.29 (2023-06-15)
    * DEV-54-rdg-blocks-change-on-rdg-posts-list-block
        - Added margin to the title of the picks vs block. 
        - Removed link read more in post list block.
-   1.1.28 (2023-06-15)
    * DEV-53-rdg-blocks-js-change
        - Add css margin-left to class "title" in pick-vs block.
        - Convert jQuery into Vainilla Javascript in the faq block.
-   1.1.27 (2023-06-15)
    * DEV-49-rdg-blocks-block-not-working-prop
        - The title of the picks vs block was made dynamic.
-   1.1.26 (2023-06-14)
    * DEV-29-update-sport-picks-vs-block-fix
        - Added validation to custom link.
-   1.1.25 (2023-06-14)
    * DEV-29-update-sport-picks-vs-block-fix
        - Fixed picks vs block.
-   1.1.24 (2023-06-13)
    * DEV-29-update-sport-picks-vs-block-fix
        - Fixed problem in sports picks vs block form.
        - The category key was updated.
-   1.1.23 (2023-06-13)
    * DEV-29-update-sport-picks-vs-block-fix
        - The update of blocks with cache is finished. 
        - Added link to block picks sports picks vs.
-   1.1.22 (2023-06-10)
    * DEV-29-update-sport-picks-vs-block-fix
        - The way in which the cache is updated has been updated.
-   1.1.21 (2023-06-09)
    * DEV-29-update-sport-picks-vs-block-fix
        - Fixed menu order.
-   1.1.20 (2023-06-09)
    * DEV-29-update-sport-picks-vs-block
        - Fixed data source.
-   1.1.19 (2023-06-07)
    * DEV-44-rdg-blocks-top-winner-changes-fix
        - The net field information is displayed.
-   1.1.18 (2023-06-07)
    * DEV-44-rdg-blocks-top-winner-changes
        - Updated from the main branch.
-   1.1.17 (2023-06-06)
    * DEV-38-sh-remove-scripts
        - Fixing RDG Post Ajax and RDG Picks Vs.
-   1.1.16 (2023-06-05)
    * DEV-38-sh-remove-scripts
        - Fixing issues.
-   1.1.15 (2023-06-05)
    * DEV-38-sh-remove-scripts
        - Convert jQuery to Vainilla Javascript.
-   1.1.14 (2023-06-02)
    * DEV-42-apply-api-to-top-cappers-block
        - Adjustments are made to the block layout.
-   1.1.13 (2023-06-02)
    * DEV-42-apply-api-to-top-cappers-block
        - API is consumed from top cappers block. Image cache is applied to top capper.
-   1.1.12 (2023-06-01)
    * DEV-41-images-maintenance
        - Image maintenance is finished.
-   1.1.11 (2023-05-30)
    * DEV-39-change-image-source
        - DEV-39 The necessary adjustments are made to the images.
-   1.1.10 (2023-05-29)
    * DEV-39-change-image-source
        - The images of the top winner blocks and sports picks are adapted.
-   1.1.9 (2023-05-15)
    * SAS-DEV-11-update-plugins
        - Updated rdg-bookie-summary-sidebar and rdg-quick-links-sidebar blocks.
-   1.1.8 (2023-05-11)
    * RDG-104-update-leader-board-block
        - The link of the handicapper name is removed.
-   1.1.7 (2023-05-10)
    * RDG-103-update-picks-vs-block
        - It is allowed to hide the category.
-   1.1.6 (2023-05-04)
    * RDG-102-fix-posts-ajax-block
        - Fixed ajax posts block.
-   1.1.5 (2023-05-03)
    * RDG-101-update-posts-ajax
        - Updated ajax posts block. redirect was added.
-   1.1.4 (2023-04-27)
    * RDG-100-update-quick-links-block
        - The rdg bookie summary sidebar block was created.
-   1.1.3 (2023-04-26)
    * RDG-099-create-quick-links-sidebar
        - The rdg quick links sidebar block was created.
-   1.1.2 (2023-04-25)
    * RDG-098-update-custom-post-type-review
        - The rdg bookie summary sidebar block was created.
-   1.1.1 (2023-04-24)
    * RDG-098-updating-to-1-version
        - Fixing rdg memberships block.
-   1.1.0 (2023-04-24)
    * RDG-097-update-custom-post-type-review-block
        - Parameters of the custom post type were updated.
-   1.0.95 (2023-04-22)
    * RDG-095-create-bookie-sidebar-block
        - The rdg bookie summary block was created.
        - The rdg quick links block was created.
- 1.0.94 (2023-04-21)
    * RDG-096-rdg-memberships:
        - RDG Memberships added.
- 1.0.93 (2023-04-19)
    * RDG-094-create-heading-paragraph-block:
        - The rdg heading paragraph block was created.
- 1.0.92 (2023-04-19)
    * RDG-093-create-pros-cons-block:
        - The rdg pros and cons block was created.
- 1.0.91 (2023-04-18)
    * RDG-091-create-rdg-headinh-block:
        - The rdg heading block was created.
- 1.0.90 (2023-04-16)
    * RDG-095-fixing-secondary-banner-responsive :
        - Fixing responsive style in secondary banner block.
- 1.0.89 (2023-04-15)
    * RDG-093-simple-post-list-block:
        - Simple Post List block added.
- 1.0.88 (2023-04-14)
    * RDG-090-create-single-top-handicappers-block:
        - Fix previews and predictions.
        - Single Top Handicappers finished.
- 1.0.87 (2023-04-14)
    * RDG-092-fic-best-pph-block:
        - Fix form in best pph block.
- 1.0.86 (2023-04-14)
    * RDG-089-create-best-pph-block:
        - The best pph block was created.
- 1.0.85 (2023-04-13)
    * RDG-091-previews-and-predictions-fix:
        - Fixing previews and predictions block.
- 1.0.84 (2023-04-12)
    * RDG-089-create-product-report-block:
        - The product report block was created.
- 1.0.83 (2023-04-12)
    * RDG-088-create-bookie-logo-block:
        - The bookie logo block was created.
- 1.0.82 (2023-04-11)
    * RDG-087-create-rating-bookie-block:
        - The rating bookie block was created.
- 1.0.81 (2023-04-11)
    * RDG-086-create-column-buttons-block:
        - The buttons column block was created.
- 1.0.80 (2023-04-09)
    * RDG-087-adding-secondary-banner-experts-banner-and-previews-and-predictions-blocks:
        - Added secondary banner.
        - Added experts banner.
        - Added previews and predictions.
- 1.0.79 (2023-04-06)
    * RDG-085-update-picks-vs-block:
        - Added link in picks.
- 1.0.78 (2023-04-04)
    * RDG-084-create-link-title-posts-ajax:
        - Added link in post title.
- 1.0.77 (2023-04-03)
    * RDG-083-fix-template-posts-ajax-block:
        - The presentation of the posts was modified.
- 1.0.76 (2023-04-03)
    * RDG-082-fix-posts-ajax-block:
        - Filters are repaired.
- 1.0.75 (2023-03-31)
    * RDG-081-implement-posts-plugin:
        - Ajax posts block updated.
- 1.0.74 (2023-03-30)
    * RDG-080-create-posts-ajax-blocks:
        - Ajax posts block finished.
- 1.0.73 (2023-03-24)
    * RDG-079-fixes-blocks:
        - Fixed rdg post list and rdg image columns blocks.
- 1.0.72 (2023-03-14)
    * RDG-078-create-consensus-block:
        - The Consensus block is created.
- 1.0.71 (2023-03-13)
    * RDG-077-fix-max-texts-in-blocks:
        - Maximum text sizes are adjusted in the rdg latest posts and rdg slider lates post blocks.
- 1.0.70 (2023-03-10)
    * RDG-076-picks-vs-redis:
        - Redis was implemented in rdg picks vs block.
- 1.0.69 (2023-03-09)
    * RDG-075-create-redis-helpers:
        - Methods are created to manage redis.
- 1.0.68 (2023-03-09)
    * RDG-074-fix-configuration-menu-load:
        - The loading of configuration menus is validated, since it generates an error in wp cli.
- 1.0.67 (2023-02-27)
    * RDG-072-fix-latest-post-block:
        - Fix Latest Post block.
- 1.0.66 (2023-02-27)
    * RDG-071-fix-latest-post-block:
        - Fix Latest Post block.
- 1.0.65 (2023-02-24)
    * RDG-070-fix-leader-board-block:
        - Fix leader board block.
- 1.0.64 (2023-02-24)
    * RDG-069-implement-filter-range-leader-board-block:
        - Date range filter is implemented in leaderboard block.
- 1.0.63 (2023-02-23)
    * RDG-068-update-leader-board-block:
        - Basic filter is implemented in leaderboard block.
- 1.0.62 (2023-02-15)
    * RDG-061-implement-ajax-request:
        - Load all categories in the dropdown.
        - Filter by sub categories was created.
        - Filter by date was created.
- 1.0.61 (2023-02-13)
    * RDG-061-update-picks-vs-block:
        - Updated Picks Vs API block.
- 1.0.60 (2023-02-09)
    * RDG-065-create-socials-icons-block:
        - The Socials Icons block is created.
- 1.0.59 (2023-02-09)
    * RDG-064-update-picks-list-block:
        - Adjusted Picks List block.
- 1.0.58 (2023-02-07)
    * RDG-063-create-multiple-block:
        - The Register block is created.
        - The Login block is created.
        - The List is created.
- 1.0.57 (2023-02-07)
    * RDG-062-create-paragraph-color-block:
        - The Paragraph Color block is created.
- 1.0.56 (2023-01-31)
    * RDG-060-update-top-cappers-block:
        - Adjusted Top cappers block.
- 1.0.55 (2023-01-30)
    * RDG-059-create-single-pick-block:
        - The Single Pick block is created.
- 1.0.54 (2023-01-30)
    * RDG-058-create-columns-picks:
        - The Columns Picks block is created.
        - The Separator block is created.
- 1.0.53 (2023-01-28)
    * RDG-057-update-favorite-cappers-block:
        - Updated Favorite Cappers block.
        - Updated Admin Cappers block.
- 1.0.52 (2023-01-27)
    * RDG-056-create-table-leagues-block:
        - The Table Leagues block is created.
- 1.0.51 (2023-01-27)
    * RDG-055-create-admin-cappers-simple-block:
        - The Admin Cappers Simple block is created.
- 1.0.50 (2023-01-26)
    * RDG-054-update-call-to-action-block:
        - Updated Call To Action block.
- 1.0.49 (2023-01-26)
    * RDG-053-create-table-block:
        - The Table block is created.
- 1.0.48 (2023-01-26)
    * RDG-052-create-logo-ranking-block:
        - The Logo Ranking block is created.
- 1.0.47 (2023-01-25)
    * RDG-051-create-leader-board-block:
        - The Leader Board block is created.
- 1.0.46 (2023-01-25)
    * RDG-050-create-favorite-cappers-block:
        - The Favorite Cappers block is created.
- 1.0.45 (2023-01-24)
    * RDG-049-create-top-cappers-block:
        - The Top Cappers block is created.
- 1.0.44 (2023-01-24)
    * RDG-048-create-main-promotions-block:
        - The Main Promotions block is created.
- 1.0.43 (2023-01-23)
    * RDG-045-create-picks-vs-block:
        - The Picks Vs block is created.
- 1.0.42 (2023-01-21)
    * RDG-045-update-buttons-block:
        - Updated rdg buttons block.
- 1.0.41 (2023-01-20)
    * RDG-044-create-new-paragraph-custom-block:
        - The New Paragraph Custom block is created.
- 1.0.40 (2023-01-20)
    * RDG-043-adapt-blocks-full-screen:
        - It is allowed to show the selected blocks as full screen.
- 1.0.39 (2023-01-20)
    * RDG-042-create-posts-list-block:
        - The Posts List is created.
- 1.0.38 (2023-01-19)
    * RDG-041-update-faq-block:
        - Updated faq block.
- 1.0.37 (2023-01-18)
    * RDG-040-create-paragraph-custom-block:
        - The Paragraph Custom block is created.
- 1.0.36 (2023-01-18)
    * RDG-039-create-sports-picks-vs-block:
        - The Sports Picks Vs block is created.
- 1.0.35 (2023-01-12)
    * RDG-038-create-odd-betting-block:
        - The odd betting select block is created.
        - The odd betting date block is created.
        - The title block is approved.
        - The main banner block is modified.
- 1.0.34 (2023-01-11)
    * RDG-037-update-main-banner-block:
        - The main banner block is updated.
- 1.0.33 (2023-01-10)
    * RDG-036-create-logo-team-block:
        - The rdg logo team block was created.
- 1.0.32 (2023-01-10)
    * RDG-035-buttons-block:
        - The rdg buttons block was created.
- 1.0.31 (2023-01-10)
    * RDG-034-faq-block:
        - Frequently asked questions on how to adapt the block.
- 1.0.30 (2023-01-09)
    * RDG-033-fix-next-game-block:
        - The media query of the block next game is fixed.
- 1.0.29 (2023-01-09)
    * RDG-032-update-next-game-block:
        - The media queries of the block are modified.
- 1.0.28 (2023-01-06)
    * RDG-030-adapt-image-column:
        - The Image Column block was created.
- 1.0.27 (2023-01-05)
    * RDG-029-fit-multiple-blocks:
        - Multiple blocks were adjusted.
- 1.0.26 (2023-01-04)
    * RDG-028-create-picks-list-block:
        - The picks list block was created.
- 1.0.25 (2023-01-04)
    * RDG-027-create-latest-post-block:
        - The latest post block was created.
- 1.0.24 (2023-01-03)
    * RDG-026-create-slider-latest-post:
        - The slider latest post block was created.
- 1.0.23 (2022-12-23)
    * RDG-025-create-next-game-block:
        - The next game block was created.
- 1.0.22 (2022-12-22)
    * RDG-024-create-admin-cappers-block:
        - The admin cappers block was created.
- 1.0.21 (2022-12-20)
    * RDG-023-call-to-action-block:
        - The design of the call to action block is adapted.
- 1.0.20 (2022-12-19)
    * RDG-022-main-banner-block:
        - The design of the main banner block was adapted for the generatePress theme.
- 1.0.19 (2022-12-17)
    * RDG-021-sports-picks-api-fix:
        - Sports picks block is repaired.
- 1.0.18 (2022-12-17)
    * RDG-020-sports-picks-api:
        - API was implemented in the sports picks block. 
- 1.0.17 (2022-12-09)
    * RDG-019-create-block-sports-picks:
        - The design of the sports picks block was adapted to the generatePress template. 
        - Fixed cache problem, when a block that supports it, uses manual data.
- 1.0.16 (2022-12-08)
    * RDG-018-top-winners-done:
        - The top winners block is finished.
- 1.0.15 (2022-12-07)
    * RDG-017-top-winners-multi_caching:
        - A cache file is generated for each block.
- 1.0.14 (2022-12-06)
    * RDG-016-top-winners-cache-fix:
        - Blocks are identified for cache and processed on save.
- 1.0.13 (2022-12-02)
    * RDG-015-top-winners-cache-uploads:
        - Cache storage path changed.
- 1.0.12 (2022-12-02)
    * RDG-014-top-winners-cache-fix:
        - The directory for the cache is created if it does not exist.
- 1.0.11 (2022-12-02)
    * RDG-013-top-winners-cache:
        - Implement cache api.
- 1.0.10 (2022-12-01)
    * RDG-012-top-winner-api:
        - Adapted the Top Winner block to connect with API.
- 1.0.9 (2022-11-30)
    * RDG-011-adapt-top-winner-block:
        - Adapt top winner block to generatePress theme.
- 1.0.8 (2022-11-22)
    * RDG-010-create-sports-picks-block:
        - The RDG Sports Picks block was created.
        - Sources ACF .json updated.
- 1.0.7 (2022-11-21)
    * RDG-009-create-top-winners-block:
        - The RDG Top Winners block was created.
        - Sources ACF .json updated.
- 1.0.6 (2022-11-18)
    * RDG-008-update-image-column-block:
        - Removed manual adjustments from the block image column.
- 1.0.5 (2022-11-18)
    * RDG-006-fix-image-column-block:
        - It is validated that the link should not be blank.
- 1.0.4 (2022-11-17)
    * RDG-005-create-image-column-block:
        - The RDG Image Column block was created.
        - Sources ACF .json updated.
- 1.0.3 (2022-11-16)
    * RDG-004-create-call-to-action-block:
        - The RDG Call to Action block was created.
        - Sources ACF .json updated.
- 1.0.2 (2022-11-16)
    * RDG-003-modify-main-banner-block:
        - Removed main banner block title. 
        - The RDG Title block was created.
        - Sources ACF .json updated.
- 1.0.1 (2022-11-15)
    * RDG-002-create-main-banner-block:
        - Main banner block was created. 
        - Common structures are created for the different blocks.
        - Sources ACF .json created.
- 1.0.0 (2022-11-11)
    - RDG-001: Block base structure is implemented.
