<?php
$logo_label = true;

if (isset($api_attributes) && is_array($api_attributes) && isset($api_attributes['category_primary'])) {
    if ($api_attributes['category_primary'] == '2') {
        $logo_label = false;
    }

    if ($api_attributes['category_primary'] == '7') {
        $logo_label = false;
    }
}

$fields = $block_sports_picks->getFieldsValidate();
?>
<?php foreach($picks as $pick):?>
    <?php if (!$rdgb->helpers->validateFields($fields, $pick)) continue; ?>
    <div class="pick">
        <div class="pick-header">
            <div class="title">
                <span class="header-title">
                    <?php echo (isset($sports[$pick['id_sport']])) ? $sports[$pick['id_sport']] : ''; ?>
                </span>
            </div>
            <div class="content">
                <div class="sport"><span><?php echo $pick['sport_name']; ?></span></div>
                <div class="date-time"><span><?php echo $pick['game_date']; ?></span></div>
                <div class="status"><span><?php echo $pick['game_stat']; ?></span></div>
            </div>
        </div>
        <div class="pick-body">
            <div class="teams">
                <div class="team team-a">
                    <div class="team-logo">
                        <?php
                            $home_image = $block_sports_picks->get_image($pick['home_image'], [
                                'image_type' => 'team_image',
                                'image_alt' => $pick['home_name'],
                                'logo_label' => $logo_label
                            ]);
                        ?>
                        <img src="<?php echo $home_image['url']; ?>" alt="<?php echo $home_image['alt']; ?>">
                    </div>
                    <div class="team-name"><span><?php echo $pick['home_name']; ?></span></div>
                </div>
                <div class="team team-vs">
                    <div class="vs-logo"><span>vs</span></div>
                    <div class="vs-name">
                        <?php if ($link_options != 'none'): ?>
                            <?php
                                $url = '';
                                $target = '_self';

                                if ($link_options == 'custom') {
                                    if (is_array($custom_link)) {
                                        if (isset($custom_link['url'])) {
                                            $url = $custom_link['url'];
                                        }
        
                                        if (isset($custom_link['target']) && !empty($custom_link['target'])) {
                                            $target = $custom_link['target'];
                                        }
                                    }
                                } else {
                                    $url = (!empty($pick['game_url'])) ? $pick['game_url'] : '#';
                                    $target = '_blank';
                                }
                            ?>
                            <a href="<?php echo $url; ?>" target="<?php echo $target; ?>" rel="noopener nofollow">
                        <?php endif; ?>
                            <span>
                                <?php
                                    $link_title = $pick['num_picks'].' PICKS';
                                    if ($link_options == 'custom') {
                                        $link_title = (!empty($custom_link['title'])) ? $custom_link['title'] : $pick['num_picks'].' PICKS';
                                    }
                                ?>
                                <?php echo $link_title; ?>
                            </span>
                        <?php if ($link_options != 'none'): ?>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="team team-b">
                    <div class="team-logo">
                        <?php
                            $visitor_image = $block_sports_picks->get_image($pick['visitor_image'], [
                                'image_type' => 'team_image',
                                'image_alt' => $pick['visitor_name'],
                                'logo_label' => $logo_label
                            ]);
                        ?>
                        <img src="<?php echo $visitor_image['url']; ?>" alt="<?php echo $visitor_image['alt']; ?>">
                    </div>
                    <div class="team-name"><span><?php echo $pick['visitor_name']; ?></span></div>
                </div>
            </div>
        </div>
    </div>
<?php endforeach; ?>
