<?php foreach($picks as $pick):?>
    <div class="pick">
        <div class="pick-header">
            <div class="title">
                <span class="header-title"><?php echo $pick['title']; ?></span>
            </div>
            <div class="content">
                <div class="sport"><span><?php echo $pick['category']; ?></span></div>
                <div class="date-time"><span><?php echo $pick['time']; ?></span></div>
                <div class="status"><span><?php echo $pick['status']; ?></span></div>
            </div>
        </div>
        <div class="pick-body">
            <?php if (isset($pick['teams']) && count($pick['teams']) > 0 && count($pick['teams']) == 2): ?>
                <div class="teams">
                    <?php $teams = 0; ?>
                    <?php foreach($pick['teams'] as $team): ?>
                        <?php $class_team = ($teams == 0) ? 'team-a' : 'team-b'; ?>

                        <div class="team <?php echo $class_team; ?>">
                            <div class="team-logo">
                                <?php if (isset($team['logo']['url']) && $team['logo']['url'] != ''): ?>
                                    <img src="<?php echo $team['logo']['url']; ?>" alt="">
                                <?php endif; ?>
                            </div>
                            <div class="team-name"><span><?php echo $team['name']; ?></span></div>
                        </div>

                        <?php if ($teams == 0): ?>
                            <div class="team team-vs">
                                <div class="vs-logo"><span>vs</span></div>
                                <div class="vs-name"><span><?php echo $pick['vs']; ?></span></div>
                            </div>
                        <?php endif;?>

                        <?php $teams++; ?>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>

            <?php if (!empty($pick['ranking']) && count($pick['ranking']) > 0): ?>
                <div class="numbers">
                    <?php foreach($pick['ranking'] as $ranking): ?>
                        <div class="number"><span><?php echo $ranking['value']; ?></span></div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>

        <?php if (!empty($pick['link'])): ?>
            <div class="pick-footer">
                <a href="<?php echo $pick['link']['url']; ?>" target="<?php echo (empty($pick['link']['target'])) ? '_self' : $pick['link']['target']; ?>"><?php echo $pick['link']['title']; ?></a>
            </div>
        <?php endif; ?>
    </div>
<?php endforeach; ?>