<?php

namespace Rdgcorp\MasterFeed\Application;

use Rdgcorp\MasterFeed\Infrastructure\MasterFeedClient;

class GetDirectSchedules
{
    private MasterFeedClient $masterFeedClient;

    public function __construct(MasterFeedClient $masterFeedClient)
    {
        $this->masterFeedClient = $masterFeedClient;
    }

    public function __invoke(?string $teamId = null, ?string $seasonId = null): array
    {
        $responseData = $this->masterFeedClient->getDirectSchedules($teamId, $seasonId);

        return $responseData[0]['data-content'][0][0]['games'];
    }
}
