<?php
    if (isset($block['data']['isExample']) && $block['data']['isExample']) {
        echo '<img src="' . esc_url( $block['data']['preview_image'] ) . '"style="max-width:100%; min-width:100%" alt="Preview" />';
        return;
    }

    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_name = BLOCK_RDG_TRENDS;
    $block_classes = [$block_name];
    $block_trends = $rdgb->settings->getBlock($block_name);
    $block_id = (isset($block['data']['custom_id']) && !empty($block['data']['custom_id'])) ? $block['data']['custom_id'] : $block['id'];

    $cache = new Rdg_Blocks_Cache();
    $connect = $cache->getRedisConnect();
    if (!$connect) {
        error_log(sprintf('%s / %s: Redis connection failed.', RDGBLOCKS_NAME, $block_name));
        return;
    }

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $position_block = $rdgb->helpers->getBlocksSpaces(get_fields());

    $title = (!empty(get_field('rdg_trends_title'))) ? get_field('rdg_trends_title') : ' ';
    $sport = (!empty(get_field('rdg_trends_sports'))) ? get_field('rdg_trends_sports') : null;
    $team = (!empty(get_field('rdg_trends_teams'))) ? get_field('rdg_trends_teams') : null;
    $type = (!empty(get_field('rdg_trends_type'))) ? get_field('rdg_trends_type') : 'over_under_trend';
    $items = (!empty(get_field('number_of_items'))) ? get_field('number_of_items') : 10;
    
    $trends = null;
    $cache_name = null;
    $post_id = get_the_ID();
    $post_type = get_post_type($post_id);

    if ($block_trends->isCaching() && !empty($block_id)) {
        $cache_name = $rdgb->helpers->getBlocksCacheName($block_name, $post_type, $post_id, $block_id);
        $cache_block = $cache->getCacheBlock($cache_name);
        $cache_block_array = $rdgb->helpers->isJson($cache_block);

        if ($cache_block_array && is_array($cache_block_array['api_response'])) {
            $api_attributes = $cache_block_array['api_attributes'];
            $trends = $cache_block_array['api_response'][0]['data-content'][0][0]['trends'];
            $items = $cache_block_array['items'];
        }
    }
?>

<?php if (is_array($trends) && count($trends) > 0): ?>
    <div class="rdg-blocks">
        <?php
            $params = ['cache_name' => $cache_name, 'api_request' => $api_attributes];
            $block_trends->getLogDebug($params);
        ?>
        <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
            <div class="content">
                <div class="trends-box">
                    <div class="trends-title"><?php echo $title; ?></div>
                    <div class="trends-body">
                        <div class="trends">
                            <?php foreach ($trends as $trend): ?>
                                <div class="trend">
                                    <div class="content"><?php echo $trend['description']; ?></div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>