/**
 * RDG AV Picks Sticky Block JavaScript
 * Handles expand/collapse and close functionality
 */
(function() {
    'use strict';
    
    let initialized = false;
    
    function initStickyPicksBar() {
        // Prevent multiple initializations
        if (initialized) {
            return;
        }
        
        const expandBtn = document.getElementById('rdg-sticky-picks-expand-btn');
        const stickyBar = document.getElementById('rdg-sticky-picks-bar');
        
        // If elements don't exist yet, don't mark as initialized
        if (!expandBtn || !stickyBar) {
            return;
        }
        
        const sportsNav = stickyBar.querySelector('.container.content .custom-header-sports-nav');
        const closeBtn = stickyBar.querySelector('.rdg-sticky-picks-close-btn');
        
        // Expand button functionality
        if (expandBtn && sportsNav) {
            expandBtn.addEventListener('click', function(e) {
                e.preventDefault();
                e.stopPropagation();
                sportsNav.classList.toggle('expanded');
            });
        }
        
        // Close button functionality
        if (closeBtn && stickyBar) {
            closeBtn.addEventListener('click', function(e) {
                e.preventDefault();
                e.stopPropagation();
                stickyBar.classList.add('hidden');
            });
        }
        
        // Mark as initialized
        initialized = true;
    }
    
    // Initialize on DOM ready
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', initStickyPicksBar);
    } else {
        initStickyPicksBar();
    }
    
    // Also run after a short delay to catch dynamically loaded content
    setTimeout(initStickyPicksBar, 100);
})();

