<?php 
    if (isset($block['data']['isExample']) && $block['data']['isExample']) {
        echo '<img src="' . esc_url( $block['data']['preview_image'] ) . '"style="max-width:100%; min-width:100%" alt="Preview" />';
        return;
    }

    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_name = BLOCK_RDG_HANDICAPPER_PICK_RESULTS;
    $block_classes = [$block_name];
    $block_handicapper_pick_results = $rdgb->settings->getBlock($block_name);
    $block_id = (isset($block['data']['custom_id']) && !empty($block['data']['custom_id'])) ? $block['data']['custom_id'] : $block['id'];

    $cache = new Rdg_Blocks_Cache();
    $connect = $cache->getRedisConnect();
    if (!$connect) {
        error_log(sprintf('%s / %s: Redis connection failed.', RDGBLOCKS_NAME, $block_name));
        return;
    }

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $primary_date = (!empty(get_field('primary_date'))) ? get_field('primary_date') : null;
    $secondary_date = (!empty(get_field('secondary_date'))) ? get_field('secondary_date') : null;

    $sports = (!empty(get_field('sports'))) ? get_field('sports') : '';
    $handicapper = (!empty(get_field('handicapper'))) ? get_field('handicapper') : '';
    
    $source = get_field('source');

    $titles = get_field('titles');
    $position_block = $rdgb->helpers->getBlocksSpaces(get_fields());

    $items = null;
    $pick_results = null;
    $cache_name = null;
    $api_attributes = null;
    $post_id = get_the_ID();
    $post_type = get_post_type($post_id);

    if ($source == 'api' && $block_handicapper_pick_results->isCaching() && !empty($block_id)) {
        $cache_name = $rdgb->helpers->getBlocksCacheName($block_name, $post_type, $post_id, $block_id);
        $cache_block = $cache->getCacheBlock($cache_name);
        $cache_block_array = $rdgb->helpers->isJson($cache_block);

        if ($cache_block_array && is_array($cache_block_array['api_response'])) {
            $api_attributes = $cache_block_array['api_attributes'];
            $pick_results = isset($cache_block_array['api_response']['data']) ? $cache_block_array['api_response']['data'] : [];
            $items = $cache_block_array['items'];
        }
    }
?>

<?php if (is_array($pick_results) && count($pick_results) > 0): ?>
    <div class="rdg-blocks">
        <?php
            $params = ['cache_name' => $cache_name, 'api_request' => $api_attributes];
            $block_handicapper_pick_results->getLogDebug($params);
        ?>
        <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
            <div class="hpr-container">
            <?php
                if ($source == 'api') {
                    require 'partials/api.php';
                } else {
                    require 'partials/manual.php';
                }
            ?>
            </div>
        </div>

        <script>
            document.addEventListener("DOMContentLoaded", function () {
            const rows = document.querySelectorAll(".table-row"); 
            const loadMoreBtn = document.getElementById("load-more");
            let visibleCount = 10; 

            if (!loadMoreBtn || rows.length <= 10) return; 

            loadMoreBtn.addEventListener("click", function () {
                let newVisibleCount = visibleCount + 10; 
                rows.forEach((row, index) => {
                    if (index < newVisibleCount) {
                        row.style.display = "table-row"; 
                    }
                });
                visibleCount = newVisibleCount;

                if (visibleCount >= rows.length) {
                    loadMoreBtn.style.display = "none";
                }
            });
        });
        </script>
    </div>
<?php endif; ?>