<?php
$logo_label = false;
$fields = $block_picks_vs_multi->getFieldsValidate();

// Debug output
if (defined('WP_DEBUG') && WP_DEBUG) {
    error_log(sprintf(
        '[RDG Picks VS Multi API Partial] Picks isset: %s | Is array: %s | Empty: %s | Count: %s | Type: %s',
        isset($picks) ? 'YES' : 'NO',
        is_array($picks) ? 'YES' : 'NO',
        empty($picks) ? 'YES' : 'NO',
        is_array($picks) ? count($picks) : 'N/A',
        gettype($picks ?? null)
    ));
    if (is_array($picks) && count($picks) > 0) {
        error_log('[RDG Picks VS Multi API Partial] First group type: ' . gettype($picks[0]) . ' | First group count: ' . (is_array($picks[0]) ? count($picks[0]) : 'N/A'));
    }
}

// Temporary visible debug for admins
if (current_user_can('administrator') && defined('WP_DEBUG') && WP_DEBUG) {
    echo '<!-- API Partial Debug: picks isset=' . (isset($picks) ? 'YES' : 'NO') . ' | is_array=' . (is_array($picks) ? 'YES' : 'NO') . ' | empty=' . (empty($picks) ? 'YES' : 'NO') . ' | count=' . (is_array($picks) ? count($picks) : 'N/A') . ' -->';
}

if (isset($picks) && is_array($picks) && !empty($picks)):
    $group_index = 0;
    foreach ($picks as $pick_group):
        if (!is_array($pick_group)) {
            if (defined('WP_DEBUG') && WP_DEBUG) {
                error_log('[RDG Picks VS Multi API Partial] Skipping non-array pick_group at index ' . $group_index);
            }
            $group_index++;
            continue;
        }
        $pick_index = 0;
        foreach ($pick_group as $pick): 
            if (!$rdgb->helpers->validateFields($fields, $pick)) {
                if (defined('WP_DEBUG') && WP_DEBUG) {
                    // Log which fields are failing validation
                    $missing_fields = [];
                    $empty_fields = [];
                    foreach ($fields as $field => $validations) {
                        if (in_array('required', $validations) && !isset($pick[$field])) {
                            $missing_fields[] = $field;
                        }
                        if (in_array('notnull', $validations) && isset($pick[$field]) && empty($pick[$field])) {
                            $empty_fields[] = $field . ' (value: ' . var_export($pick[$field], true) . ')';
                        }
                    }
                    error_log(sprintf(
                        '[RDG Picks VS Multi API Partial] Pick validation failed at group %s, pick %s | Missing: [%s] | Empty: [%s]',
                        $group_index,
                        $pick_index,
                        implode(', ', $missing_fields),
                        implode(', ', $empty_fields)
                    ));
                }
                $pick_index++;
                continue;
            }
            $pick_index++; ?>
            
            <div class="pick">
                <div class="pick-header">
                    <div class="sport"><?php echo $pick['sport_name']; ?></div>
                    <div class="date-time">
                        <?php
                            // Robust date parsing with multiple formats
                            $game_datetime = false;
                            $date_formats = [
                                'Y-m-d H:i:s',      // 2025-11-03 12:00:00
                                'Y-m-d H:i',        // 2025-11-03 12:00
                                'Y-m-d\TH:i:s',     // 2025-11-03T12:00:00 (ISO)
                                'Y-m-d\TH:i:sP',    // 2025-11-03T12:00:00+00:00 (ISO with timezone)
                                'Y-m-d\TH:i:s.uP',  // 2025-11-03T12:00:00.000000+00:00 (ISO with microseconds)
                            ];
                            
                            foreach ($date_formats as $format) {
                                $game_datetime = DateTime::createFromFormat($format, $pick['game_date']);
                                if ($game_datetime !== false) {
                                    break;
                                }
                            }
                            
                            // If all formats fail, try strtotime as fallback
                            if ($game_datetime === false) {
                                $timestamp = strtotime($pick['game_date']);
                                if ($timestamp !== false) {
                                    $game_datetime = new DateTime();
                                    $game_datetime->setTimestamp($timestamp);
                                }
                            }
                            
                            // Display formatted date if valid
                            if ($game_datetime !== false) {
                                echo $game_datetime->format('Y-m-d H:i');
                            }
                        ?>
                    </div>
                    <div class="status"><?= $pick['game_stat']; ?></div>
                </div>
                <div class="pick-body">
                    <div class="team team-b">
                        <div class="team-logo">
                            <?php
                                $visitor_image = $block_picks_vs_multi->get_image($pick['visitor_image'], [
                                    'image_type' => 'team_image',
                                    'image_alt' => $pick['visitor_name'],
                                    'logo_label' => $logo_label
                                ]);
                            ?>
                            <img width="90" height="90" src="<?php echo $visitor_image['url']; ?>" alt="<?php echo $visitor_image['alt']; ?>">
                        </div>
                        <div class="team-name"><span><?php echo $pick['visitor_name']; ?></span></div>
                    </div>
                    <div class="team-vs">
                        <div class="vs-logo">
                            <span>vs</span>
                        </div>
                    </div>
                    <div class="team team-a">
                        <div class="team-logo">
                            <?php
                                $home_image = $block_picks_vs_multi->get_image($pick['home_image'], [
                                    'image_type' => 'team_image',
                                    'image_alt' => $pick['home_name'],
                                    'logo_label' => $logo_label
                                ]);
                            ?>
                            <img width="90" heigt="90" src="<?php echo $home_image['url']; ?>" alt="<?php echo $home_image['alt']; ?>">
                        </div>
                        <div class="team-name"><span><?php echo $pick['home_name']; ?></span></div>
                    </div>
                </div>
                <div class="pick-footer">
                    <a href="<?= $pick['game_url']; ?>" target="_blank" class="pick-btn"><?php echo $pick['num_picks']; ?> PICKS</a>
                </div>
            </div>
            
        <?php endforeach;
    endforeach;
endif;
?>
