<div class="items">
    <?php if (!empty($posts)): ?>
        <?php foreach($posts as $post): ?>
            <div class="item">
            <?php
                $link_url = '';
                $link_target = '_self';
                // $link_name = 'Read more';
                $link_url = get_permalink($post);
            ?>
            <a href="<?php echo $link_url; ?>" target="<?php echo $link_target; ?>">
                <div class="image" style="background-image: url(<?php echo posts_ajax_get_image($post->ID); ?>);"></div>
            </a>
                <footer>
                    <a href="<?php echo get_permalink($post); ?>">
                        <h4 class="footer-title">
                            <?php echo (!empty($post->post_title)) ? $post->post_title : ''; ?>
                        </h4>
                    </a>

                    <div class="meta">
                        <span>by</span>
                        <span class="author">
                            <?php echo get_the_author_meta('display_name', $post->post_author).' / '; ?>
                        </span>
                        <span class="date">
                            <?php
                                // Robust date parsing with multiple formats
                                $game_datetime = false;
                                $date_formats = [
                                    'Y-m-d H:i:s',      // 2025-11-03 12:00:00
                                    'Y-m-d H:i',        // 2025-11-03 12:00
                                    'Y-m-d\TH:i:s',     // 2025-11-03T12:00:00 (ISO)
                                    'Y-m-d\TH:i:sP',    // 2025-11-03T12:00:00+00:00 (ISO with timezone)
                                    'Y-m-d\TH:i:s.uP',  // 2025-11-03T12:00:00.000000+00:00 (ISO with microseconds)
                                ];
                                
                                foreach ($date_formats as $format) {
                                    $game_datetime = DateTime::createFromFormat($format, $post->post_date);
                                    if ($game_datetime !== false) {
                                        break;
                                    }
                                }
                                
                                // If all formats fail, try strtotime as fallback
                                if ($game_datetime === false) {
                                    $timestamp = strtotime($post->post_date);
                                    if ($timestamp !== false) {
                                        $game_datetime = new DateTime();
                                        $game_datetime->setTimestamp($timestamp);
                                    }
                                }
                                
                                // Display formatted date if valid
                                if ($game_datetime !== false) {
                                    echo $game_datetime->format('F j, Y');
                                } else {
                                    echo 'Invalid date';
                                }
                            ?>
                        </span>
                    </div>
                    <?php
                        if (!empty($post->post_excerpt)) {
                            $excerpt = $post->post_excerpt;
                        } else {
                            $excerpt = $post->post_content;
                        }
                    ?>
                    <?php if (!empty($excerpt)): ?>
                        <div class="footer-description">
                            <?php echo wp_trim_words($excerpt, 35, false); ?>
                        </div>
                    <?php endif; ?>

                   
                    <!-- <a href="" target=""></a> If u want to active the "Read more" just enter the variables inside the "" and the <a> </a>--> 
                </footer>
            </div>
        <?php endforeach; ?>
    <?php endif; ?>
</div>