<?php

namespace Rdgcorp\MasterFeed\Application;

use Rdgcorp\MasterFeed\Infrastructure\MasterFeedClient;

class GetDirectLeagues
{
    private MasterFeedClient $masterFeedClient;

    public function __construct(MasterFeedClient $masterFeedClient)
    {
        $this->masterFeedClient = $masterFeedClient;
    }

    public function __invoke(?string $sportId = null): array
    {
        $responseData = $this->masterFeedClient->getDirectLeagues();

        $data = $responseData[0]['data-content'][0][0]['leagues'];

        if ($sportId) {
            foreach ($data as $key => $item) {
                if ($item['sport_id'] !== $sportId) {
                    unset($data[$key]);
                }
            }
        }

        return $data;
    }
}
