<div class="cappers">
<?php if ($theme === 'regular'): ?>
    <?php foreach($cappers as $capper):?>
        <div class="capper">
            <div class="capper-header">
                <div class="title">
                    <span class="header-title"><?php echo $capper['title']; ?></span>
                </div>
            </div>
            <div class="capper-body">
                <?php if (isset($capper['logo']['url'])): ?>
                    <?php $primary_capper++;  ?>
                    <div class="logo">
                        <img src="<?php echo $capper['logo']['url']; ?>" alt="Image">
                    </div>
                <?php endif; ?>

                <?php if (!empty($capper['name'])): ?>
                    <?php $primary_capper++;  ?>
                    <div class="name">
                        <span><?php echo $capper['name']; ?></span>
                    </div>
                <?php endif; ?>

                <?php if (!empty($capper['score'])): ?>
                    <?php $primary_capper++;  ?>
                    <div class="score separator">
                        <span><?php echo $capper['score']; ?></span>
                    </div>
                <?php endif; ?>

                <?php if (is_array($capper['more_cappers']) && count($capper['more_cappers']) > 0): ?>
                    <div class="scores">
                        <?php $i = ($primary_capper == 0) ? 1 : 2; ?>
                        <?php foreach($capper['more_cappers'] as $more): ?>
                            <div class="score separator">
                                <div class="score-name"><?php echo $i.'. '.$more['name'] ?></div>
                                <div class="score-score"><?php echo $more['score']; ?></div>
                            </div>
                            <?php $i++; ?>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    <?php endforeach; ?>
<?php else: ?>   
    <?php foreach($cappers as $capper):?>
        <div class="capper-inline">
            <div class="capper-body">
                <?php if (isset($capper['logo']['url']) && !empty($capper['logo']['url'])): ?>
                    <?php
                        $capper_image = $block_top_cappers_sport->get_image($capper['logo']['url'], [
                            'image_type' => 'top_capper',
                            'image_alt' => $capper['name'],
                            'logo_label' => false,
                        ]);
                    ?>
                    <div class="logo">
                        <img src="<?php echo $capper_image['url']; ?>" alt="<?php echo $capper_image['alt']; ?>">
                    </div>
                <?php endif; ?>

                <div class="capper-info">
                    <?php if (!empty($capper['name'])): ?>
                        <div class="name">
                            <span><?php echo $capper['name']; ?></span>
                        </div>
                    <?php endif; ?>
                    <div class="package">
                        <span><?php echo $group_name; ?></span>
                    </div>
                    <div class="profit">
                        <span>Won in the last <?php echo $days; ?> days: $<?php echo number_format($capper['score'], 0, '.', ','); ?></span>
                    </div>
                </div>
            </div>
            <div class="score separator"></div>
        </div>
    <?php endforeach; ?>
</div>
<?php endif; ?>
</div>