<?php
    $authors = $block_query_posts->getAuthors($post_type);
    $terms = $block_query_posts->getTermsFromTaxonomy($taxonomy);

    if (!empty($category_type)) {
        if ($category_type == 'include' && is_array($category_include_array) && count($category_include_array) > 0) {
            $terms = $block_query_posts->getTermsFromConfigure($taxonomy, $category_type, $category_include_array);
        } elseif ($category_type == 'exclude' && is_array($category_exclude_array) && count($category_exclude_array) > 0) {
            $terms = $block_query_posts->getTermsFromConfigure($taxonomy, $category_type, $category_exclude_array);
        }
    }
?>

<?php if (is_array($authors) && count($authors) > 0): ?>
    <select name="author" id="author">
        <option value="">Author</option>
        <?php foreach ($authors as $author_id => $author_name): ?>
            <option value="<?php echo $author_id; ?>"><?php echo $author_name; ?></option>
        <?php endforeach; ?>
    </select>
<?php endif; ?>

<?php if (is_array($terms) && count($terms) > 0): ?>
    <select name="taxonomy" id="taxonomy">
        <option value="">Category</option>
        <?php foreach ($terms as $term_id => $term_name): ?>
            <option value="<?php echo $term_id; ?>"><?php echo $term_name; ?></option>
        <?php endforeach; ?>
    </select>
<?php endif; ?>