<?php
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_name = BLOCK_RDG_REGISTER;
    $block_classes = [$block_name];
    $block_paragraph_custom = $rdgb->settings->getBlock($block_name);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $titles = get_field('titles');
    $content = (!empty(get_field('content'))) ? get_field('content') : '';
    $position_block = $rdgb->helpers->getBlocksSpaces(get_fields());
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

        <div class="body">
            <div class="box">
                <div class="box-title">
                    <span>become a member</span>
                </div>
                <div class="box-body">
                    <label for="first_name">First Name</label>
                    <input type="text" name="first_name">
                    <label for="email">Email</label>
                    <input type="text" name="email">
                    <input type="checkbox"><span class="remember">Agree Terms & Conditions</span>
                    <div class="link">
                        <a href="">register</a>
                    </div>

                    <div class="box-footer">
                        <a href="#">Login Here</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
