<?php  
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_name = BLOCK_RDG_SAS_NAVBAR;
    $block_classes = [$block_name];
    $block_admin_cappers = $rdgb->settings->getBlock($block_name);

    // Variables
    
    $full_container = get_field('full_container');
    $site_logo = get_field('site_logo');
    $login_link = get_field('login_link');
    $sign_up_link = get_field('sign_up_link');

?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" >
        <!-- Navbar section -->
        <div class="sas-navbar-container <?php if ($full_container == 'fullwidth') { echo "full-width"; } ?>">
        <form id="search-form" role="search" method="get" action="<?php echo home_url( '/' ); ?>">
            <div class="input-container">
                <div class="input-wrapper">
                    <input type="text" value="<?php echo get_search_query(); ?>" name="s" id="s" id="search-input" placeholder="Buscar..." />
                    <img src="<?php echo plugins_url('assets/images/search-icon.svg', __FILE__); ?>" alt="search icon" class="search-svg">
                </div>
            </div>
        </form>

            <!-- Navbar inner container -->
            <div class="navbar-container container content grid-container">

                <!-- Secondary Menu -->
                <div class="secondary-menu">
                    <?php if( have_rows('secondary_menu') ): ?>
                        <?php while( have_rows('secondary_menu') ): the_row(); 
                            $secondary_link = get_sub_field('secondary_link');
                            ?>
                            <?php if( $secondary_link ): 
                                $secondary_link_url = $secondary_link['url'];
                                $secondary_link_title = $secondary_link['title'];
                                $secondary_link_target = $secondary_link['target'] ? $secondary_link['target'] : '_self';
                                ?>
                                <a href="<?php echo esc_url( $secondary_link_url ); ?>" target="<?php echo esc_attr( $secondary_link_target ); ?>"><?php echo esc_html( $secondary_link_title ); ?></a>
                            <?php endif; ?>
                            
                        <?php endwhile; ?>
                    <?php endif;?>
                    
                    <?php if( have_rows('lenguage') ): ?>
                        <?php while( have_rows('lenguage') ): the_row(); 
                            $lenguage_link = get_sub_field('lenguage_link');
                            $lenguage_flag = get_sub_field('lenguage_flag');
                        ?>
                            <?php if( $lenguage_link ): 
                                $lenguage_link_url = $lenguage_link['url'];
                                $lenguage_link_title = $lenguage_link['title'];
                                $lenguage_link_target = $lenguage_link['target'] ? $lenguage_link['target'] : '_self';
                            ?>
                                
                                <a href="<?php echo esc_url( $lenguage_link_url ); ?>" target="<?php echo esc_attr( $lenguage_link_target ); ?>" class="lenguage-btn">
                                    <?php if( !empty( $lenguage_flag ) ): ?>
                                        <img src="<?php echo esc_url($lenguage_flag['url']); ?>" alt="<?php echo esc_attr($lenguage_flag['alt']); ?>" />
                                    <?php endif; ?>
                                    <?php echo esc_html( $lenguage_link_title ); ?>
                                </a>
                            <?php endif;?>
                        <?php endwhile; ?>
                    <?php endif;?>
                </div>

                <!-- Main Menu -->
                <div class="primary-menu">
                    <div class="top-container">
                        <!-- Site Logo -->
                        <div class="site-logo-wrapper">
                            <?php if( !empty( $site_logo ) ): ?>
                                <img src="<?php echo esc_url($site_logo['url']); ?>" alt="<?php echo esc_attr($site_logo['alt']); ?>" />
                            <?php endif; ?>
                        </div>

                        <!-- Main Nav -->
                        <div class="primary-navigation">
                            <?php if( have_rows('main_menu') ): ?>
                                <div class="toggle-container">
                                    <span class="toggle-button" id="navbar-toggle">
                                        &#9776;
                                    </span>
                                    <span class="toggle-button-x" id="navbar-toggle-x">
                                        &#10005;
                                    </span>
                                </div>
                                <div class="navbar-links" id="navbar-links">
                                    <ul>
                                    <?php while( have_rows('main_menu') ): the_row(); 
                                        $menu_link = get_sub_field('menu_link');
                                    ?>
                                        <?php if( have_rows('submenu') ) { ?>
                                            
                                                <li class="dropdown">

                                                <?php if( $menu_link ): 
                                                $menu_link_url = $menu_link['url'];
                                                $menu_link_title = $menu_link['title'];
                                                $menu_link_target = $menu_link['target'] ? $menu_link['target'] : '_self'; ?>

                                                    <a class="dropbtn" href="<?php echo esc_url( $menu_link_url ); ?>" target="<?php echo esc_attr( $menu_link_target ); ?>">

                                                        <?php echo esc_html( $menu_link_title ); ?>
                                                        <img src="<?php echo plugins_url('assets/images/arrow-down-icon.svg', __FILE__); ?>" alt="arrow icon" class="arrow-down">
                                                    </a>
                                                <?php endif; ?>
                                                    <div class="dropdown-content">
                                                        <?php while( have_rows('submenu') ): the_row(); 
                                                            $submenu_link = get_sub_field('submenu_link');
                                                            $submenu_icon = get_sub_field('submenu_icon');
                                                            ?>
                                                                <?php if( $submenu_link ): 
                                                                    $submenu_link_url = $submenu_link['url'];
                                                                    $submenu_link_title = $submenu_link['title'];
                                                                    $submenu_link_target = $submenu_link['target'] ? $submenu_link['target'] : '_self'; ?>
                                                                    
                                                                    <a class="dropbtn submenu-icon" href="<?php echo esc_url( $submenu_link_url ); ?>" target="<?php echo esc_attr( $submenu_link_target ); ?>">
                                                                    <?php if ($submenu_icon == 'football') {?>
                                                                        <img src="<?php echo plugins_url('assets/images/football-icon.svg', __FILE__); ?>" alt="icon">
                                                                    <?php } else if ($submenu_icon == 'baseball') {?>
                                                                        <img src="<?php echo plugins_url('assets/images/baseball-icon.svg', __FILE__); ?>" alt="icon">
                                                                    <?php } else if ($submenu_icon == 'basketball') {?>
                                                                        <img src="<?php echo plugins_url('assets/images/basketball-icon.svg', __FILE__); ?>" alt="icon">
                                                                    <?php } else if ($submenu_icon == 'hockey') {?>
                                                                        <img src="<?php echo plugins_url('assets/images/hockey-icon.svg', __FILE__); ?>" alt="icon">
                                                                    <?php } else if ($submenu_icon == 'soccer') {?>
                                                                        <img src="<?php echo plugins_url('assets/images/soccer-icon.svg', __FILE__); ?>" alt="icon">
                                                                    <?php } ?>
                                                                    <?php echo esc_html( $submenu_link_title ); ?>
                                                                    </a>

                                                                <?php endif; ?>
                                                            <?php endwhile; ?>
                                                    </div>
                                                </li>
                                            <?php } else {?>
                                            
                                            <?php if( $menu_link ): 
                                                $menu_link_url = $menu_link['url'];
                                                $menu_link_title = $menu_link['title'];
                                                $menu_link_target = $menu_link['target'] ? $menu_link['target'] : '_self'; ?>

                                                <li>
                                                    <a href="<?php echo esc_url( $menu_link_url ); ?>" target="<?php echo esc_attr( $menu_link_target ); ?>">
                                                        <?php echo esc_html( $menu_link_title ); ?>
                                                    </a>
                                                </li>
                                            <?php endif; ?>
                                            <?php } ?>
                                            
                                    <?php endwhile; ?>
                                    </ul>
                                    <div class="secondary-menu-mobile">
                                        <?php if( have_rows('secondary_menu') ): ?>
                                            <?php while( have_rows('secondary_menu') ): the_row(); 
                                                $secondary_link = get_sub_field('secondary_link');
                                                ?>
                                                <?php if( $secondary_link ): 
                                                    $secondary_link_url = $secondary_link['url'];
                                                    $secondary_link_title = $secondary_link['title'];
                                                    $secondary_link_target = $secondary_link['target'] ? $secondary_link['target'] : '_self';
                                                    ?>
                                                    <a href="<?php echo esc_url( $secondary_link_url ); ?>" target="<?php echo esc_attr( $secondary_link_target ); ?>"><?php echo esc_html( $secondary_link_title ); ?></a>
                                                <?php endif; ?>
                                                
                                            <?php endwhile; ?>
                                        <?php endif;?>
                                        
                                        <?php if( have_rows('lenguage') ): ?>
                                            <?php while( have_rows('lenguage') ): the_row(); 
                                                $lenguage_link = get_sub_field('lenguage_link');
                                                $lenguage_flag = get_sub_field('lenguage_flag');
                                            ?>
                                                <?php if( $lenguage_link ): 
                                                    $lenguage_link_url = $lenguage_link['url'];
                                                    $lenguage_link_title = $lenguage_link['title'];
                                                    $lenguage_link_target = $lenguage_link['target'] ? $lenguage_link['target'] : '_self';
                                                ?>
                                                    
                                                    <a href="<?php echo esc_url( $lenguage_link_url ); ?>" target="<?php echo esc_attr( $lenguage_link_target ); ?>" class="lenguage-btn">
                                                        <?php if( !empty( $lenguage_flag ) ): ?>
                                                            <img src="<?php echo esc_url($lenguage_flag['url']); ?>" alt="<?php echo esc_attr($lenguage_flag['alt']); ?>" />
                                                        <?php endif; ?>
                                                        <?php echo esc_html( $lenguage_link_title ); ?>
                                                    </a>
                                                <?php endif;?>
                                            <?php endwhile; ?>
                                        <?php endif;?>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <!-- Search -->
                            <div class="search-container">
                                <div class="search-icon" onclick="toggleSearch()">
                                    <span id="search-icon" class="icon">
                                        <img src="<?php echo plugins_url('assets/images/search-icon.svg', __FILE__); ?>" alt="search icon">
                                    </span>
                                    <div id="search-connector"></div>
                                </div>
                            </div>
                            
                        </div>
                    </div>
                    <!-- Nav Buttons -->
                    <div class="nav-mobile-container">
                        <div class="search-mobile">
                            <div class="search-icon-mobile" onclick="toggleSearch()">
                                <span id="search-icon-mobile" class="icon">
                                    <img src="<?php echo plugins_url('assets/images/search-icon.svg', __FILE__); ?>" alt="search icon">
                                </span>
                                <div id="search-connector-mobile"></div>
                            </div>
                        </div>
                        <div class="nav-buttons">
                        <?php if( $login_link ): 
                                $login_link_url = $login_link['url'];
                                $login_link_title = $login_link['title'];
                                $login_link_target = $login_link['target'] ? $login_link['target'] : '_self'; ?>
                            <a href="<?php echo esc_url( $login_link_url ); ?>" class="login-btn" target="<?php echo esc_attr( $login_link_target ); ?>">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                                    <g clip-path="url(#clip0_713_6)">
                                    <path d="M0 8C0 8.368 0.298666 8.66667 0.666666 8.66667H10.024L7.862 10.8287C7.60133 11.0893 7.60133 11.5107 7.862 11.7713C7.992 11.9013 8.16267 11.9667 8.33333 11.9667C8.504 11.9667 8.67467 11.9013 8.80467 11.7713L11.6333 8.94267C12.1533 8.42267 12.1533 7.57733 11.6333 7.05733L8.80467 4.22867C8.544 3.968 8.12267 3.968 7.862 4.22867C7.60133 4.48933 7.60133 4.91067 7.862 5.17133L10.024 7.33333H0.666666C0.298666 7.33333 0 7.632 0 8ZM0.924 10.0453C1.268 9.91133 1.654 10.0813 1.78733 10.424C2.794 13.0013 5.232 14.6667 7.99933 14.6667C11.6753 14.6667 14.666 11.676 14.666 8C14.666 4.324 11.676 1.33333 8 1.33333C5.23267 1.33333 2.794 2.99867 1.788 5.576C1.654 5.91867 1.26933 6.088 0.924665 5.95467C0.581332 5.82067 0.412 5.434 0.546 5.09133C1.75333 1.99867 4.67933 0 8 0C12.4113 0 16 3.58867 16 8C16 12.4113 12.4113 16 8 16C4.67933 16 1.75333 14.0013 0.545334 10.9093C0.411333 10.566 0.580666 10.18 0.924 10.046V10.0453Z" fill="white"/>
                                    </g>
                                    <defs>
                                    <clipPath id="clip0_713_6">
                                        <rect width="16" height="16" fill="white" transform="matrix(-1 0 0 1 16 0)"/>
                                    </clipPath>
                                    </defs>
                                </svg>
                                <?php echo esc_html( $login_link_title ); ?>
                            </a>
                            <?php endif; ?>
                            <?php if( $sign_up_link ): 
                                $sign_up_link_url = $sign_up_link['url'];
                                $sign_up_link_title = $sign_up_link['title'];
                                $sign_up_link_target = $sign_up_link['target'] ? $sign_up_link['target'] : '_self'; ?>
                            <a href="<?php echo esc_url( $sign_up_link_url ); ?>" class="sign-up-btn" target="<?php echo esc_attr( $sign_up_link_target ); ?>">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                                    <g clip-path="url(#clip0_713_11)">
                                    <path d="M12.6667 1.33325H3.33333C1.49333 1.33325 0 2.82659 0 4.66659V11.3333C0 13.1733 1.49333 14.6666 3.33333 14.6666H8C8.36667 14.6666 8.66667 14.3666 8.66667 13.9999C8.66667 13.6333 8.36667 13.3333 8 13.3333H3.33333C2.23333 13.3333 1.33333 12.4333 1.33333 11.3333V5.99992H14.6667V9.33325C14.6667 9.69992 14.9667 9.99992 15.3333 9.99992C15.7 9.99992 16 9.69992 16 9.33325V4.66659C16 2.82659 14.5067 1.33325 12.6667 1.33325ZM1.33333 4.66659C1.33333 3.56659 2.23333 2.66659 3.33333 2.66659H12.6667C13.7667 2.66659 14.6667 3.56659 14.6667 4.66659H1.33333ZM10.94 8.11325C10.4333 7.60659 9.76667 7.33325 9.05333 7.33325H7.99333C7.62667 7.33325 7.32667 7.63325 7.32667 7.99992V9.05992C7.32667 9.77325 7.60667 10.4399 8.10667 10.9466L12.58 15.4199C12.96 15.7999 13.46 16.0066 13.9933 16.0066C14.5267 16.0066 15.0267 15.7999 15.4067 15.4199C15.7867 15.0399 15.9933 14.5399 15.9933 14.0066C15.9933 13.4733 15.7867 12.9733 15.4067 12.5933L10.9333 8.11992L10.94 8.11325ZM14.4667 14.4733C14.2133 14.7266 13.7733 14.7266 13.5267 14.4733L9.05333 9.99992C8.8 9.74659 8.66 9.41325 8.66 9.05992V8.66659H9.05333C9.40667 8.66659 9.74667 8.80659 9.99333 9.05992L14.4667 13.5333C14.5933 13.6599 14.66 13.8266 14.66 14.0066C14.66 14.1866 14.5933 14.3533 14.4667 14.4799V14.4733Z" fill="white"/>
                                    </g>
                                    <defs>
                                    <clipPath id="clip0_713_11">
                                        <rect width="16" height="16" fill="white"/>
                                    </clipPath>
                                    </defs>
                                </svg>
                                <?php echo esc_html( $sign_up_link_title ); ?>
                            </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    
        <script>
            document.getElementById("navbar-toggle").addEventListener("click", function () {
                this.classList.toggle("active");
                document.getElementById("navbar-toggle-x").classList.toggle("active");
                document.getElementById("navbar-links").classList.toggle("active");
            });

            document.getElementById("navbar-toggle-x").addEventListener("click", function () {
                this.classList.toggle("active");
                document.getElementById("navbar-toggle").classList.toggle("active");
                document.getElementById("navbar-links").classList.toggle("active");
            });

            const dropdowns = document.querySelectorAll('.dropdown');

            dropdowns.forEach(dropdown => {
                dropdown.addEventListener('click', function(e) {
                    if (window.innerWidth <= 768) {
                        e.stopPropagation();
                        this.classList.toggle('active');
                    }
                });
            });

            // Search
            function toggleSearch() {
                // Desktop
                const searchForm = document.getElementById('search-form');
                const searchIcon = document.querySelector('.search-icon');
                const searchConnector = document.getElementById('search-connector');

                // Mobile
                const searchIconMobile = document.querySelector('.search-icon-mobile');
                const searchConnectorMobile = document.getElementById('search-connector-mobile');

                if (searchForm.classList.contains('expanded')) {
                    searchForm.classList.remove('expanded');
                    searchIcon.style.borderBottomLeftRadius = '50%';
                    searchIcon.style.borderBottomRightRadius = '50%';
                    searchConnector.classList.remove('show');
                    // Mobile
                    searchIconMobile.style.borderBottomLeftRadius = '50%';
                    searchIconMobile.style.borderBottomRightRadius = '50%';
                    searchConnectorMobile.classList.remove('show');
                } else {
                    searchForm.classList.add('expanded');
                    searchConnector.classList.add('show');
                    searchIcon.style.borderBottomLeftRadius = '0';
                    searchIcon.style.borderBottomRightRadius = '0';
                    // Mobile
                    searchIconMobile.style.borderBottomLeftRadius = '0';
                    searchIconMobile.style.borderBottomRightRadius = '0';
                    searchConnectorMobile.classList.add('show');
                }
            }
        </script>
    
    </div>
</div>
