<?php
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_name = BLOCK_RDG_TOP_WINNERS;
    $block_top_winners = $rdgb->settings->getBlock($block_name);

    $message = '';
    $link = get_field('link');
    $tops = get_field('tops');
    $source = get_field('source');
    $position_block = $rdgb->helpers->getBlocksSpaces(get_fields());
    list($heading, $title, $styles) = $block_top_winners->getTitle(get_fields());
    $presentation = (!empty(get_field('presentation'))) ? get_field('presentation') : 'small';

    $cache_file = null;
    $api_attributes = null;
    if ($source == 'api' && $block_top_winners->isCaching()) {
        $api_url = get_field('top_winners_api_url', 'option');
        $api_token = get_field('top_winners_api_token', 'option');
        $items = (!empty(get_field('number_of_items'))) ? intval(get_field('number_of_items')) : 1;
        $period = (!empty(get_field('period'))) ? get_field('period') : '';

        if (!empty($api_url) && !empty($api_token)) {
            $api_attributes = $block_top_winners->getApiAttributes($items, ['period' => $period]);
            $block_custom_id = (!empty($block['data']['custom_id'])) ? $block['data']['custom_id'] : '';
            $post_id_custom = (!empty($block['data']['post_id'])) ? $block['data']['post_id'] : $post_id;
            $cache_file = $rdgb->helpers->getCacheName($block_name, $post_id_custom, $block_custom_id);
            $response = $block_top_winners->getResources($api_attributes, $cache_file);

            if (empty($response->message) && is_array($response->json)) {
                $tops = $response->json;
            } else {
                $tops = null;
                $message = $response->message;
            }
        } else {
            $message = __('Configure API connection correctly.');
        }
    }
?>

<div class="rdg-blocks">
    <?php
        $params = ['cache_file' => $cache_file, 'api_request' => $api_attributes];
        $block_top_winners->getLogDebug($params);
    ?>
    <div id="<?php echo $block['id']; ?>" class="rdg-top-winners" style="<?php echo $position_block; ?>">
        <div class="header">
            <?php if(!empty($title)): ?>
                <div class="title" style="<?php echo $styles; ?>">
                    <<?php echo $heading; ?> class="header-title"><?php echo $title; ?></<?php echo $heading; ?>>
                </div>
            <?php endif; ?>
        </div>

        <div class="body<?php echo ($presentation == 'small') ? ' small' : ''; ?>">
            <div class="legend">
                <div class="legend-logo"></div>
                <div class="legend-win">Win</div>
                <div class="legend-dra">Dra</div>
            </div>
            <div class="tops">
                <?php if (!empty($tops)): ?>
                    <?php
                        if ($source == 'api') {
                            require 'partials/api.php';
                        } else {
                            require 'partials/manual.php';
                        }
                    ?>
                <?php else: ?>
                    <?php if (!empty($message)): ?>
                        <span class="message"><?php echo $message; ?></span>
                    <?php endif; ?>
                <?php endif; ?>
            </div>
        </div>

        <div class="footer">
            <?php if(!empty($link)): ?>
                <div class="footer-link">
                    <a href="<?php echo $link['url']; ?>" target="<?php echo $link['target']; ?>">
                        <?php echo $link['title']; ?>
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
