<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Table_Leagues extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_TABLE_LEAGUES;
    private $block_folder_name = 'rdg-table-leagues';
    protected $block_title = 'RDG Table Leagues';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'table', 'leagues'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_styles_load = true;

    public function init() {
        $this->register_block();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_table_leagues.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'rdg-table-leagues-select','slug' => 'rdg-table-leagues-select','color' => '#0160ac'],
            ['name' => 'rdg-table-leagues-select-class','slug' => 'rdg-table-leagues-select-class','color' => '#0160ac'],
            ['name' => 'rdg-table-leagues-select-bg','slug' => 'rdg-table-leagues-select-bg','color' => '#F1F1F1'],
            ['name' => 'rdg-table-leagues-button-bg','slug' => 'rdg-table-leagues-button-bg','color' => '#0160ac'],
            ['name' => 'rdg-table-leagues-button','slug' => 'rdg-table-leagues-button','color' => '#ffffff'],
            ['name' => 'color-table-leagues-item-border','slug' => 'color-table-leagues-item-border','color' => '#CCC'],
            ['name' => 'color-table-leagues-team','slug' => 'color-table-leagues-team','color' => '#0160ac'],
            ['name' => 'color-table-leagues-button','slug' => 'color-table-leagues-button','color' => '#56a213'],
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [
            [
                'customSelector' => '.rdg-table-leagues .items .item .date .date',
                'fontSize' => '1rem',
                'fontSizeTablet' => '0.9rem',
            ],
            [
                'customSelector' => '.rdg-table-leagues .items .item .date .type',
                'fontWeight' => '700',
                'fontSize' => '1rem',
                'fontSizeTablet' => '0.9rem',
            ],
            [
                'customSelector' => '.rdg-table-leagues .items .item .teams .team-home, .rdg-table-leagues .items .item .teams .team-visitor',
                'fontWeight' => '600',
                'fontSize' => '1rem',
                'fontSizeTablet' => '0.9rem',
            ],
            [
                'customSelector' => '.rdg-table-leagues .items .item .teams .team-home, .rdg-table-leagues .items .item .teams .team-visitor',
                'fontWeight' => '600',
                'fontSize' => '1rem',
                'fontSizeTablet' => '0.9rem',
            ],
            [
                'customSelector' => '.rdg-table-leagues .items .item .teams .team-vs',
                'fontWeight' => '600',
                'fontSize' => '1rem',
                'fontSizeTablet' => '0.9rem',
            ],
            [
                'customSelector' => '.rdg-table-leagues .items .item .results span',
                'fontWeight' => '600',
                'fontSize' => '1rem',
                'fontSizeTablet' => '0.9rem',
            ],
            [
                'customSelector' => '.rdg-table-leagues .items .item .units span',
                'fontWeight' => '600',
                'fontSize' => '1rem',
                'fontSizeTablet' => '0.9rem',
            ],
            [
                'customSelector' => '.rdg-table-leagues .table .filter .select:after',
                'fontWeight' => '700',
            ],
            [
                'customSelector' => '.rdg-table-leagues .table .filter .select select',
                'fontWeight' => '700',
            ],
            [
                'customSelector' => '.rdg-table-leagues .table .filter .select select option',
                'fontWeight' => '700',
            ],
            [
                'customSelector' => '.rdg-table-leagues .table .filter .button',
                'fontWeight' => '600',
            ],
        ];
    }
}

$rdg_table_leagues_class = new Rdg_Blocks_Table_Leagues();
$rdg_table_leagues_class->init();

return $rdg_table_leagues_class;
