<?php
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_name = BLOCK_RDG_PICKS_VS_CATEGORIES;
    $block_classes = [$block_name];
    $block_picks_vs_categories = $rdgb->settings->getBlock($block_name);
    $block_id = (isset($block['data']['custom_id']) && !empty($block['data']['custom_id'])) ? 
        $block['data']['custom_id'] : $block['id'];

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $sports_picks = [];
    $titles = get_field('titles');
    $sports = (!empty(get_field('sports'))) ? get_field('sports') : null;
    $sports_array = $block_picks_vs_categories->get_categories_sports($sports);

    $link_options = (!empty(get_field('link_options'))) ? get_field('link_options') : 'none';
    $custom_link = (!empty(get_field('custom_link'))) ? get_field('custom_link') : null;
    $date_type = (!empty(get_field('date_type'))) ? get_field('date_type') : null;
    $since_date = (!empty(get_field('since_date'))) ? get_field('since_date') : null;
    $to_date = (!empty(get_field('to_date'))) ? get_field('to_date') : null;

    $position_block = $rdgb->helpers->getBlocksSpaces(get_fields());
    $date_request = $block_picks_vs_categories->get_date_filter($date_type, $since_date, $to_date);
    $show = (!empty(get_field('show_in'))) ? get_field('show_in') : 'column';
    $category_heading = (!empty(get_field('category_heading'))) ? get_field('category_heading') : 'h1';

    $cache_file = null;
    $api_attributes = null;
    if (is_array($sports) && count($sports) > 0 && $block_picks_vs_categories->isCaching()) {
        $api_url = get_field('picks_vs_api_url', 'option');
        $api_token = get_field('picks_vs_api_token', 'option');

        if (!empty($api_url) && !empty($api_token)) {
            $api_attributes = $block_picks_vs_categories->getApiAttributes(null, ['sports' => $sports, 'date' => $date_request]);
            $block_custom_id = (!empty($block['data']['custom_id'])) ? $block['data']['custom_id'] : '';
            $post_id_custom = (!empty($block['data']['post_id'])) ? $block['data']['post_id'] : $post_id;
            $cache_file = $rdgb->helpers->getCacheName($block_name, $post_id_custom, $block_custom_id);
            $response = $block_picks_vs_categories->getResources($api_attributes, $cache_file);
            $titles_sports = $rdgb->helpers->getSporstCategoriesTitles(true);

            if (empty($response->message) && is_array($response->json)) {
                $sports_picks = $response->json;
            } else {
                $message = $response->message;
            }
        } else {
            $message = __('Configure API connection correctly.');
        }
    }
?>

<div class="rdg-blocks">
    <?php
        $params = ['cache_file' => $cache_file, 'api_request' => $api_attributes];
        $block_picks_vs_categories->getLogDebug($params);
    ?>
    <div <?php echo (!empty($block_id)) ? 'id="'.$block_id.'"' : ''; ?> class="<?php echo esc_attr(join(' ', $block_classes)); ?> <?php echo $show; ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container content grid-container">
            <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

            <?php if (is_array($sports_picks) && count($sports_picks) > 0): ?>
                <div class="sports">
                    <?php foreach($sports_picks as $sport_pick_key => $sport_picks): ?>
                        <?php
                            if (is_array($sport_picks) && count($sport_picks) == 0) continue;
                            $id_sport_category = (isset($sports_array[$sport_pick_key]) && $sports_array[$sport_pick_key] == 'NULL') ? $sport_pick_key : $sport_pick_key.'-'.$sports_array[$sport_pick_key];

                            $custom_title = 1;
                            $api_title = (is_array($titles_sports) && isset($titles_sports[$id_sport_category])) ? $titles_sports[$id_sport_category] : '';
                            $format_title = (is_array($titles) && count($titles) > 0) ? $titles[0] : [];

                            if (!isset($format_title['title']) || $format_title['title'] == '') {
                                $format_title['title'] = $api_title;
                                $custom_title = 0;
                            }

                            list($heading, $title, $styles) = $rdgb->helpers->getTitle($format_title, true, false);
                        ?>
                        <div class="title" style="<?php echo $styles; ?>" data-heading="<?php echo $heading; ?>" data-custom-title="<?php echo $custom_title; ?>">
                            <<?php echo $category_heading; ?>><?php echo $block_picks_vs_categories->get_picks_vs_title_format($api_title); ?></<?php echo $category_heading; ?>>
                        </div>

                        <div class="picks">
                            <?php if (!empty($sport_picks)): ?>
                                <?php
                                    require 'partials/api.php';
                                ?>
                            <?php else: ?>
                                <?php if (!empty($message)): ?>
                                    <span class="message"><?php echo $message; ?></span>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
