<?php
    if (!isset($cappers['Sports']) && is_array($cappers['Sports']) && count($cappers['Sports']) > 0) {
        return;
    }

    $all_cappers = array_slice($cappers['Sports'], 0, 1);
    $all_cappers_array = array_values($all_cappers);
    $first_cappers = $all_cappers_array[0][0];
    unset($all_cappers_array[0][0]);
?>

<div class="cappers">
    <div class="capper">
        <div class="capper-header">
            <div class="title">
                <span class="header-title">
                    <?php echo (!empty($title)) ? $title : ''; ?>
                </span>
            </div>
        </div>
        <div class="capper-body">
            <?php if (isset($first_cappers['image'])): ?>
                <?php
                    $capper_image = $block_top_cappers_sport->get_image($first_cappers['image'], [
                        'image_type' => 'top_capper',
                        'image_alt' => $first_cappers['name'],
                        'logo_label' => false,
                    ]);
                ?>
                <div class="logo">
                    <img src="<?php echo $capper_image['url']; ?>" alt="<?php echo $capper_image['alt']; ?>">
                </div>
            <?php endif; ?>

            <?php if (!empty($first_cappers['name'])): ?>
                <div class="name">
                    <span><?php echo $first_cappers['name']; ?></span>
                </div>
            <?php endif; ?>

            <?php if (!empty($first_cappers['Net'])): ?>
                <div class="score separator">
                    <span>$<?php echo number_format($first_cappers['Net'], 0, '.', ','); ?></span>
                </div>
            <?php endif; ?>

            <?php if (isset($all_cappers_array[0]) && is_array($all_cappers_array[0]) && count($all_cappers_array[0]) > 0): ?>
                <div class="scores">
                    <?php $i = 2; ?>
                    <?php $fields = $block_top_cappers_sport->getFieldsValidate(); ?>
                    <?php foreach($all_cappers_array[0] as $capper):?>
                        <?php if (!$rdgb->helpers->validateFields($fields, $capper)) continue; ?>
                        <div class="score separator">
                            <div class="score-name"><?php echo $i.'. '.$capper['name'] ?></div>
                            <div class="score-score">$<?php echo number_format($capper['Net'], 0, '.', ','); ?></div>
                        </div>
                        <?php $i++; ?>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>