<?php  
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_name = BLOCK_RDG_CAROUSEL;
    $block_classes = [$block_name];
    $block_carousel = $rdgb->settings->getBlock($block_name);

    // Variables
    $post_type = get_field('post_type');
    $quantity = get_field('quantity');
    $order_by = get_field('order_by');
    $order = get_field('order');
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" >
        <div class="wrapper container grid-container">
            <button id="left" class="carousel-btn left">
                <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 60 60" fill="none">
                    <path d="M33.606 21.947L24.891 30.6245L33.606 39.302" stroke="#3469AB" stroke-width="2" stroke-linecap="square"/>
                </svg>
            </button>
            <div class="carousel">
                <?php
                $args = array(
                    'post_type' => $post_type, 
                    'posts_per_page' => $quantity, 
                    'orderby' => $order,
                    'order' => $order_by
                );

                $the_query = new WP_Query( $args );

                // Iniciar el loop
                if ( $the_query->have_posts() ) :
                    while ( $the_query->have_posts() ) : $the_query->the_post(); ?> 
                    
                        <div class="carousel-item" draggable="false">
                            <div class="featured-img">
                                <a href="<?php echo get_permalink(); ?>">
                                    <?php the_post_thumbnail('full') ?>
                                </a>
                            </div>
                            <p class="date"><?php echo  get_the_modified_date(); ?></p>
                            <a href="<?php echo get_permalink(); ?>" class="title"><?php the_title(); ?></a>
                            <p class="excerpt"><?php echo wp_trim_words( get_the_excerpt(), 30, '' ); ?></p>
                        </div>            
                    <?php endwhile;
                    wp_reset_postdata();

                else : 
                    echo 'No post found.';
                endif;
                ?>
            </div>
            <button id="right" class="carousel-btn right">
                <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 60 60" fill="none">
                <path d="M26.394 38.053L35.109 29.3755L26.394 20.698" stroke="#3469AB" stroke-width="2" stroke-linecap="square"/>
                </svg>
            </button>
        </div>
    </div>
    <script>
        const carousel= document.querySelector('.carousel');
        firstItem = carousel.querySelectorAll('.carousel-item')[0];
        const arrowIcons= document.querySelectorAll('.wrapper .carousel-btn');

        console.log(arrowIcons[1]);

        let isDragStart = false, prevPageX, prevScrollLeft, positionDiff;

        const showHideIcons = () => {
            let scrollWidth = carousel.scrollWidth - carousel.clientWidth;
            arrowIcons[0].style.display = carousel.scrollLeft == 0 ? 'none' : 'grid';
            arrowIcons[1].style.display = carousel.scrollLeft == scrollWidth ? 'none' : 'grid';
        }

        arrowIcons.forEach(icon => {
            icon.addEventListener('click', () => {
                let firstItemWidth = firstItem.clientWidth + 32;
                carousel.scrollLeft += icon.id == 'left' ? -firstItemWidth : firstItemWidth;
                setTimeout(() => showHideIcons(), 60);
            });
        });

        const dragStart = (e) => {
            isDragStart = true;
            prevPageX = e.pageX || e.touches[0].pageX;
            prevScrollLeft = carousel.scrollLeft;
        }

        const dragging = (e) => {
            if(!isDragStart) return;
            e.preventDefault();
            carousel.classList.add('dragging');
            positionDiff = (e.pageX || e.touches[0].pageX) - prevPageX;
            carousel.scrollLeft = prevScrollLeft - positionDiff;
            showHideIcons();
        }

        const dragStop = () => {
            isDragStart = false;
            carousel.classList.remove('dragging');
        }

        carousel.addEventListener('mousedown', dragStart);
        carousel.addEventListener('touchstart', dragStart);

        carousel.addEventListener('mousemove', dragging);
        carousel.addEventListener('touchmove', dragging);

        carousel.addEventListener('mouseup', dragStop);
        carousel.addEventListener('mouseleave', dragStop);
        carousel.addEventListener('touchend', dragStop);
    </script>
</div>
