<?php 
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_classes = ['rdg-main-banner'];
    $block_main_banner = $rdgb->settings->getBlock(BLOCK_RDG_MAIN_BANNER);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }
    
    $texts = get_field('texts');
    $member = get_field('member');
    $padding_spaces = get_field('padding_spaces');
    $position_block = $rdgb->helpers->getBlocksSpaces(get_fields());
    $style_block = $block_main_banner->get_style('block', get_field('background'));
    $style_position = $block_main_banner->get_style('position', get_field('padding_spaces'));
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container content grid-container">
            <div class="body" style="<?php echo $style_block; ?>">
                <div class="positions" style="<?php echo $style_position; ?>">
                    <?php $block_main_banner->get_texts($padding_spaces, $texts, $member); ?>
                </div>
            </div>
        </div>
    </div>
</div>
