<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Bookie_Summary extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_BOOKIE_SUMMARY;
    private $block_folder_name = 'rdg-bookie-summary';
    protected $block_title = 'RDG Bookie Summary';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'bookie', 'summary'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_styles_load = true;

    public function init() {
        $this->register_block();
        $this->register_fields();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_bookie_summary.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    private function register_fields() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'group_rdg_bookie_summary_block_sadw5r4r4rd2r',
                'title' => 'Block_rdg_bookie_summary',
                'fields' => array(
                    array(
                        'key' => 'field_644149899084d',
                        'label' => 'Separator',
                        'name' => 'separator',
                        'aria-label' => '',
                        'type' => 'group',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_644149999084e',
                                'label' => 'Border',
                                'name' => 'border',
                                'aria-label' => '',
                                'type' => 'number',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => 1,
                                'min' => 1,
                                'max' => 10,
                                'placeholder' => '',
                                'step' => '',
                                'prepend' => '',
                                'append' => '',
                            ),
                            array(
                                'key' => 'field_644174849330f',
                                'label' => 'Margin',
                                'name' => 'margin',
                                'aria-label' => '',
                                'type' => 'number',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => 1,
                                'min' => 0,
                                'max' => 10,
                                'placeholder' => '',
                                'step' => '',
                                'prepend' => '',
                                'append' => '',
                            ),
                            array(
                                'key' => 'field_644149ae9084f',
                                'label' => 'Color',
                                'name' => 'color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#CCC',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_6441758487519',
                        'label' => 'Logo',
                        'name' => 'logo_show',
                        'aria-label' => '',
                        'type' => 'radio',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'show' => 'Show',
                            'hide' => 'Hide',
                        ),
                        'default_value' => 'show',
                        'return_format' => 'value',
                        'allow_null' => 0,
                        'other_choice' => 0,
                        'layout' => 'horizontal',
                        'save_other_choice' => 0,
                    ),
                    array(
                        'key' => 'field_644147e481c7a',
                        'label' => 'Bookie Logo',
                        'name' => 'bookie_logo',
                        'aria-label' => '',
                        'type' => 'image',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_6441758487519',
                                    'operator' => '==',
                                    'value' => 'show',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'return_format' => 'array',
                        'library' => 'all',
                        'min_width' => '',
                        'min_height' => '',
                        'min_size' => '',
                        'max_width' => '',
                        'max_height' => '',
                        'max_size' => '',
                        'mime_types' => '',
                        'preview_size' => 'medium',
                    ),
                    array(
                        'key' => 'field_64417946ca168',
                        'label' => 'Review',
                        'name' => 'review_show',
                        'aria-label' => '',
                        'type' => 'radio',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'show' => 'Show',
                            'hide' => 'Hide',
                        ),
                        'default_value' => 'show',
                        'return_format' => 'value',
                        'allow_null' => 0,
                        'other_choice' => 0,
                        'layout' => 'horizontal',
                        'save_other_choice' => 0,
                    ),
                    array(
                        'key' => 'field_6441798aca169',
                        'label' => 'Ranking',
                        'name' => 'ranking',
                        'aria-label' => '',
                        'type' => 'number',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64417946ca168',
                                    'operator' => '==',
                                    'value' => 'show',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => 0,
                        'min' => 0,
                        'max' => 5,
                        'placeholder' => '',
                        'step' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_644179adca16a',
                        'label' => 'Site',
                        'name' => 'site',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64417946ca168',
                                    'operator' => '==',
                                    'value' => 'show',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_644179bcca16b',
                        'label' => 'Since',
                        'name' => 'since',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64417946ca168',
                                    'operator' => '==',
                                    'value' => 'show',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_644179c9ca16c',
                        'label' => 'Description',
                        'name' => 'description',
                        'aria-label' => '',
                        'type' => 'wysiwyg',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64417946ca168',
                                    'operator' => '==',
                                    'value' => 'show',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => 'height-150',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'tabs' => 'text',
                        'media_upload' => 0,
                        'toolbar' => 'full',
                        'delay' => 0,
                    ),
                    array(
                        'key' => 'field_64417dd0f6f09',
                        'label' => 'Offers',
                        'name' => 'offers',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_64417de8f6f0a',
                                'label' => 'Type',
                                'name' => 'type',
                                'aria-label' => '',
                                'type' => 'radio',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => array(
                                    'image' => 'Image',
                                    'basic' => 'Basic',
                                ),
                                'default_value' => 'image',
                                'return_format' => 'value',
                                'allow_null' => 0,
                                'other_choice' => 0,
                                'layout' => 'horizontal',
                                'save_other_choice' => 0,
                                'parent_repeater' => 'field_64417dd0f6f09',
                            ),
                            array(
                                'key' => 'field_64417e23f6f0b',
                                'label' => 'Image',
                                'name' => 'image',
                                'aria-label' => '',
                                'type' => 'image',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_64417de8f6f0a',
                                            'operator' => '==',
                                            'value' => 'image',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                                'library' => 'all',
                                'min_width' => '',
                                'min_height' => '',
                                'min_size' => '',
                                'max_width' => '',
                                'max_height' => '',
                                'max_size' => '',
                                'mime_types' => '',
                                'preview_size' => 'medium',
                                'parent_repeater' => 'field_64417dd0f6f09',
                            ),
                            array(
                                'key' => 'field_64417e51f6f0c',
                                'label' => 'Background Color',
                                'name' => 'background_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_64417de8f6f0a',
                                            'operator' => '==',
                                            'value' => 'image',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#f2f2f2',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                                'parent_repeater' => 'field_64417dd0f6f09',
                            ),
                            array(
                                'key' => 'field_64417e82f6f0d',
                                'label' => 'Padding Button',
                                'name' => 'padding_button',
                                'aria-label' => '',
                                'type' => 'number',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => 0,
                                'min' => '',
                                'max' => '',
                                'placeholder' => '',
                                'step' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_64417dd0f6f09',
                            ),
                            array(
                                'key' => 'field_64417e97f6f0e',
                                'label' => 'Texts',
                                'name' => 'texts',
                                'aria-label' => '',
                                'type' => 'repeater',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_64417de8f6f0a',
                                            'operator' => '==',
                                            'value' => 'image',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'layout' => 'block',
                                'min' => 0,
                                'max' => 0,
                                'collapsed' => '',
                                'button_label' => 'Add Row',
                                'rows_per_page' => 20,
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_64417ebaf6f0f',
                                        'label' => 'Text',
                                        'name' => 'text',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_64417e97f6f0e',
                                    ),
                                    array(
                                        'key' => 'field_64417ecef6f10',
                                        'label' => 'Padding',
                                        'name' => 'text_padding',
                                        'aria-label' => '',
                                        'type' => 'number',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'min' => '',
                                        'max' => '',
                                        'placeholder' => '',
                                        'step' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_64417e97f6f0e',
                                    ),
                                    array(
                                        'key' => 'field_64417ee4f6f11',
                                        'label' => 'Size',
                                        'name' => 'size',
                                        'aria-label' => '',
                                        'type' => 'number',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => 1,
                                        'min' => '',
                                        'max' => '',
                                        'placeholder' => '',
                                        'step' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_64417e97f6f0e',
                                    ),
                                    array(
                                        'key' => 'field_64417ef2f6f12',
                                        'label' => 'Weight',
                                        'name' => 'weight',
                                        'aria-label' => '',
                                        'type' => 'select',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'choices' => array(
                                            100 => '100',
                                            200 => '200',
                                            300 => '300',
                                            400 => '400',
                                            500 => '500',
                                            600 => '600',
                                            700 => '700',
                                            800 => '800',
                                            900 => '900',
                                        ),
                                        'default_value' => 400,
                                        'return_format' => 'value',
                                        'multiple' => 0,
                                        'allow_null' => 0,
                                        'ui' => 0,
                                        'ajax' => 0,
                                        'placeholder' => '',
                                        'parent_repeater' => 'field_64417e97f6f0e',
                                    ),
                                    array(
                                        'key' => 'field_64417f0cf6f13',
                                        'label' => 'Color',
                                        'name' => 'color',
                                        'aria-label' => '',
                                        'type' => 'color_picker',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '#FFFFFF',
                                        'enable_opacity' => 0,
                                        'return_format' => 'string',
                                        'parent_repeater' => 'field_64417e97f6f0e',
                                    ),
                                ),
                                'parent_repeater' => 'field_64417dd0f6f09',
                            ),
                            array(
                                'key' => 'field_64417f73f6f14',
                                'label' => 'Text',
                                'name' => 'text_basic',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_64417de8f6f0a',
                                            'operator' => '==',
                                            'value' => 'basic',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_64417dd0f6f09',
                            ),
                            array(
                                'key' => 'field_64417f94f6f15',
                                'label' => 'Text Size',
                                'name' => 'size_basic',
                                'aria-label' => '',
                                'type' => 'number',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_64417de8f6f0a',
                                            'operator' => '==',
                                            'value' => 'basic',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => 1,
                                'min' => '',
                                'max' => '',
                                'placeholder' => '',
                                'step' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_64417dd0f6f09',
                            ),
                            array(
                                'key' => 'field_64417fbff6f16',
                                'label' => 'Text Weight',
                                'name' => 'weight_basic',
                                'aria-label' => '',
                                'type' => 'select',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_64417de8f6f0a',
                                            'operator' => '==',
                                            'value' => 'basic',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => array(
                                    100 => '100',
                                    200 => '200',
                                    300 => '300',
                                    400 => '400',
                                    500 => '500',
                                    600 => '600',
                                    700 => '700',
                                    800 => '800',
                                    900 => '900',
                                ),
                                'default_value' => 400,
                                'return_format' => 'value',
                                'multiple' => 0,
                                'allow_null' => 0,
                                'ui' => 0,
                                'ajax' => 0,
                                'placeholder' => '',
                                'parent_repeater' => 'field_64417dd0f6f09',
                            ),
                            array(
                                'key' => 'field_64417fe2f6f17',
                                'label' => 'Text Color',
                                'name' => 'color_basic',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_64417de8f6f0a',
                                            'operator' => '==',
                                            'value' => 'basic',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#FFFFFF',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                                'parent_repeater' => 'field_64417dd0f6f09',
                            ),
                            array(
                                'key' => 'field_64418011f6f18',
                                'label' => 'Style',
                                'name' => 'style',
                                'aria-label' => '',
                                'type' => 'select',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_64417de8f6f0a',
                                            'operator' => '==',
                                            'value' => 'basic',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => array(
                                    'info' => 'Info',
                                    'success' => 'Success',
                                    'warning' => 'Warning',
                                    'danger' => 'Danger',
                                    'custom' => 'Custom',
                                ),
                                'default_value' => 'info',
                                'return_format' => 'value',
                                'multiple' => 0,
                                'allow_null' => 0,
                                'ui' => 0,
                                'ajax' => 0,
                                'placeholder' => '',
                                'parent_repeater' => 'field_64417dd0f6f09',
                            ),
                            array(
                                'key' => 'field_6441804af6f19',
                                'label' => 'Border Color',
                                'name' => 'border_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_64418011f6f18',
                                            'operator' => '==',
                                            'value' => 'custom',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#3a96e0',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                                'parent_repeater' => 'field_64417dd0f6f09',
                            ),
                            array(
                                'key' => 'field_64418073f6f1a',
                                'label' => 'Background Color',
                                'name' => 'background_color_button',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_64418011f6f18',
                                            'operator' => '==',
                                            'value' => 'custom',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#0160ac',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                                'parent_repeater' => 'field_64417dd0f6f09',
                            ),
                            array(
                                'key' => 'field_64418090f6f1b',
                                'label' => 'Hover Color',
                                'name' => 'hover_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_64418011f6f18',
                                            'operator' => '==',
                                            'value' => 'custom',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#03467d',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                                'parent_repeater' => 'field_64417dd0f6f09',
                            ),
                            array(
                                'key' => 'field_644180a5f6f1c',
                                'label' => 'Link',
                                'name' => 'link',
                                'aria-label' => '',
                                'type' => 'link',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                                'parent_repeater' => 'field_64417dd0f6f09',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_644188848cf00',
                        'label' => 'Payment Methods',
                        'name' => 'payment_methods',
                        'aria-label' => '',
                        'type' => 'radio',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'show' => 'Show',
                            'hide' => 'Hide',
                        ),
                        'default_value' => 'show',
                        'return_format' => 'value',
                        'allow_null' => 0,
                        'other_choice' => 0,
                        'layout' => 'horizontal',
                        'save_other_choice' => 0,
                    ),
                    array(
                        'key' => 'field_6441895f0a782',
                        'label' => 'Methods',
                        'name' => 'methods',
                        'aria-label' => '',
                        'type' => 'group',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_644188848cf00',
                                    'operator' => '==',
                                    'value' => 'show',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_644188a68cf01',
                                'label' => 'Title',
                                'name' => 'title',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_644188848cf00',
                                            'operator' => '==',
                                            'value' => 'show',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                            ),
                            array(
                                'key' => 'field_644188c68cf02',
                                'label' => 'Images',
                                'name' => 'images',
                                'aria-label' => '',
                                'type' => 'repeater',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_644188848cf00',
                                            'operator' => '==',
                                            'value' => 'show',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'layout' => 'block',
                                'pagination' => 0,
                                'min' => 0,
                                'max' => 0,
                                'collapsed' => '',
                                'button_label' => 'Add Row',
                                'rows_per_page' => 20,
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_644188e48cf03',
                                        'label' => '',
                                        'name' => 'method',
                                        'aria-label' => '',
                                        'type' => 'image',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'return_format' => 'array',
                                        'library' => 'all',
                                        'min_width' => '',
                                        'min_height' => '',
                                        'min_size' => '',
                                        'max_width' => '',
                                        'max_height' => '',
                                        'max_size' => '',
                                        'mime_types' => '',
                                        'preview_size' => 'medium',
                                        'parent_repeater' => 'field_644188c68cf02',
                                    ),
                                ),
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_644197a4d40e0',
                        'label' => 'Buttons',
                        'name' => 'buttons',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_644197a4d40e1',
                                'label' => 'Type',
                                'name' => 'type',
                                'aria-label' => '',
                                'type' => 'radio',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => array(
                                    'image' => 'Image',
                                    'basic' => 'Basic',
                                ),
                                'default_value' => 'image',
                                'return_format' => 'value',
                                'allow_null' => 0,
                                'other_choice' => 0,
                                'save_other_choice' => 0,
                                'layout' => 'horizontal',
                                'parent_repeater' => 'field_644197a4d40e0',
                            ),
                            array(
                                'key' => 'field_644197a4d40e2',
                                'label' => 'Image',
                                'name' => 'image',
                                'aria-label' => '',
                                'type' => 'image',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_644197a4d40e1',
                                            'operator' => '==',
                                            'value' => 'image',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                                'library' => 'all',
                                'min_width' => '',
                                'min_height' => '',
                                'min_size' => '',
                                'max_width' => '',
                                'max_height' => '',
                                'max_size' => '',
                                'mime_types' => '',
                                'preview_size' => 'medium',
                                'parent_repeater' => 'field_644197a4d40e0',
                            ),
                            array(
                                'key' => 'field_644197a4d40e3',
                                'label' => 'Background Color',
                                'name' => 'background_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_644197a4d40e1',
                                            'operator' => '==',
                                            'value' => 'image',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#f2f2f2',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                                'parent_repeater' => 'field_644197a4d40e0',
                            ),
                            array(
                                'key' => 'field_644197a4d40e4',
                                'label' => 'Padding Button',
                                'name' => 'padding_button',
                                'aria-label' => '',
                                'type' => 'number',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => 0,
                                'min' => '',
                                'max' => '',
                                'placeholder' => '',
                                'step' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_644197a4d40e0',
                            ),
                            array(
                                'key' => 'field_644197a4d40e5',
                                'label' => 'Texts',
                                'name' => 'texts',
                                'aria-label' => '',
                                'type' => 'repeater',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_644197a4d40e1',
                                            'operator' => '==',
                                            'value' => 'image',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'layout' => 'block',
                                'min' => 0,
                                'max' => 0,
                                'collapsed' => '',
                                'button_label' => 'Add Row',
                                'rows_per_page' => 20,
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_644197a4d40e6',
                                        'label' => 'Text',
                                        'name' => 'text',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_644197a4d40e5',
                                    ),
                                    array(
                                        'key' => 'field_644197a4d40e7',
                                        'label' => 'Padding',
                                        'name' => 'text_padding',
                                        'aria-label' => '',
                                        'type' => 'number',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'min' => '',
                                        'max' => '',
                                        'placeholder' => '',
                                        'step' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_644197a4d40e5',
                                    ),
                                    array(
                                        'key' => 'field_644197a4d40e8',
                                        'label' => 'Size',
                                        'name' => 'size',
                                        'aria-label' => '',
                                        'type' => 'number',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => 1,
                                        'min' => '',
                                        'max' => '',
                                        'placeholder' => '',
                                        'step' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_644197a4d40e5',
                                    ),
                                    array(
                                        'key' => 'field_644197a4d40e9',
                                        'label' => 'Weight',
                                        'name' => 'weight',
                                        'aria-label' => '',
                                        'type' => 'select',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'choices' => array(
                                            100 => '100',
                                            200 => '200',
                                            300 => '300',
                                            400 => '400',
                                            500 => '500',
                                            600 => '600',
                                            700 => '700',
                                            800 => '800',
                                            900 => '900',
                                        ),
                                        'default_value' => 400,
                                        'return_format' => 'value',
                                        'multiple' => 0,
                                        'allow_null' => 0,
                                        'ui' => 0,
                                        'ajax' => 0,
                                        'placeholder' => '',
                                        'parent_repeater' => 'field_644197a4d40e5',
                                    ),
                                    array(
                                        'key' => 'field_644197a4d40ea',
                                        'label' => 'Color',
                                        'name' => 'color',
                                        'aria-label' => '',
                                        'type' => 'color_picker',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '#FFFFFF',
                                        'enable_opacity' => 0,
                                        'return_format' => 'string',
                                        'parent_repeater' => 'field_644197a4d40e5',
                                    ),
                                ),
                                'parent_repeater' => 'field_644197a4d40e0',
                            ),
                            array(
                                'key' => 'field_644197a4d40eb',
                                'label' => 'Text',
                                'name' => 'text_basic',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_644197a4d40e1',
                                            'operator' => '==',
                                            'value' => 'basic',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_644197a4d40e0',
                            ),
                            array(
                                'key' => 'field_644197a4d40ec',
                                'label' => 'Text Size',
                                'name' => 'size_basic',
                                'aria-label' => '',
                                'type' => 'number',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_644197a4d40e1',
                                            'operator' => '==',
                                            'value' => 'basic',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => 2,
                                'min' => '',
                                'max' => '',
                                'placeholder' => '',
                                'step' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_644197a4d40e0',
                            ),
                            array(
                                'key' => 'field_644197a4d40ed',
                                'label' => 'Text Weight',
                                'name' => 'weight_basic',
                                'aria-label' => '',
                                'type' => 'select',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_644197a4d40e1',
                                            'operator' => '==',
                                            'value' => 'basic',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => array(
                                    100 => '100',
                                    200 => '200',
                                    300 => '300',
                                    400 => '400',
                                    500 => '500',
                                    600 => '600',
                                    700 => '700',
                                    800 => '800',
                                    900 => '900',
                                ),
                                'default_value' => 400,
                                'return_format' => 'value',
                                'multiple' => 0,
                                'allow_null' => 0,
                                'ui' => 0,
                                'ajax' => 0,
                                'placeholder' => '',
                                'parent_repeater' => 'field_644197a4d40e0',
                            ),
                            array(
                                'key' => 'field_644197a4d40ee',
                                'label' => 'Text Color',
                                'name' => 'color_basic',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_644197a4d40e1',
                                            'operator' => '==',
                                            'value' => 'basic',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#FFFFFF',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                                'parent_repeater' => 'field_644197a4d40e0',
                            ),
                            array(
                                'key' => 'field_644197a4d40ef',
                                'label' => 'Style',
                                'name' => 'style',
                                'aria-label' => '',
                                'type' => 'select',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_644197a4d40e1',
                                            'operator' => '==',
                                            'value' => 'basic',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => array(
                                    'info' => 'Info',
                                    'success' => 'Success',
                                    'warning' => 'Warning',
                                    'danger' => 'Danger',
                                    'custom' => 'Custom',
                                ),
                                'default_value' => 'info',
                                'return_format' => 'value',
                                'multiple' => 0,
                                'allow_null' => 0,
                                'ui' => 0,
                                'ajax' => 0,
                                'placeholder' => '',
                                'parent_repeater' => 'field_644197a4d40e0',
                            ),
                            array(
                                'key' => 'field_644197a4d40f0',
                                'label' => 'Border Color',
                                'name' => 'border_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_644197a4d40ef',
                                            'operator' => '==',
                                            'value' => 'custom',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#3a96e0',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                                'parent_repeater' => 'field_644197a4d40e0',
                            ),
                            array(
                                'key' => 'field_644197a4d40f1',
                                'label' => 'Background Color',
                                'name' => 'background_color_button',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_644197a4d40ef',
                                            'operator' => '==',
                                            'value' => 'custom',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#0160ac',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                                'parent_repeater' => 'field_644197a4d40e0',
                            ),
                            array(
                                'key' => 'field_644197a4d40f2',
                                'label' => 'Hover Color',
                                'name' => 'hover_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_644197a4d40ef',
                                            'operator' => '==',
                                            'value' => 'custom',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#03467d',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                                'parent_repeater' => 'field_644197a4d40e0',
                            ),
                            array(
                                'key' => 'field_644197a4d40f3',
                                'label' => 'Link',
                                'name' => 'link',
                                'aria-label' => '',
                                'type' => 'link',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                                'parent_repeater' => 'field_644197a4d40e0',
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-bookie-summary',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function get_stars(float $stars) {
        $fills = intval($stars);
        $half = ($stars - $fills == 0) ? 0 : 1;
        $emptys = 5 - $fills - $half;

        for ($i = 0; $i < $fills; $i++) {
            echo '<span class="star star-fill"></span>';
        }

        if ($half > 0) {
            echo '<span class="star star-half"></span>';
        }

        for ($i = 0; $i < $emptys; $i++) {
            echo '<span class="star star-empty"></span>';
        }
    }

    public function get_style($fields, $type) {
        $style = [];

        if ($type == 'separator') {
            if (isset($fields['separator']) && is_array($fields['separator'])) {
                $style[] = (!empty($fields['separator']['border'])) 
                    ? '--separator-border:'.intval($fields['separator']['border']).'px' 
                    : '--separator-border:1px';
                $style[] = (!empty($fields['separator']['margin'])) 
                    ? '--separator-margin:'.intval($fields['separator']['margin']).'rem' 
                    : '--separator-margin:1rem';
                $style[] = (!empty($fields['separator']['color'])) 
                    ? '--separator-color:'.$fields['separator']['color'] 
                    : '--separator-color:#CCC';
            }

            return implode('; ', $style).';';
        }

        return '';
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'color-bookie-summary-url','slug' => 'color-bookie-summary-url','color' => '#111111'],
            ['name' => 'color-bookie-summary-since','slug' => 'color-bookie-summary-since','color' => '#7F8C8D'],
            ['name' => 'color-bookie-summary-description','slug' => 'color-bookie-summary-description','color' => '#111111'],
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [
            [
                'customSelector' => '.rdg-bookie-summary .content .site .url',
                'fontWeight' => '700',
                'fontSize' => '1.43rem',
            ],
            [
                'customSelector' => '.rdg-bookie-summary .content .site .since',
                'fontSize' => '0.9rem',
            ],
            [
                'customSelector' => '.rdg-bookie-summary .content .site .description',
                'fontSize' => '1rem',
            ],
            [
                'customSelector' => '.acf-block-preview .rdg-bookie-summary a',
                'textDecoration' => 'none'
            ]
        ];
    }
}

$rdg_bookie_sumary_class = new Rdg_Blocks_Bookie_Summary();
$rdg_bookie_sumary_class->init();

return $rdg_bookie_sumary_class;
