<?php
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_name = BLOCK_RDG_TRENDS;
    $block_classes = [$block_name];
    $block_trends = $rdgb->settings->getBlock($block_name);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $position_block = $rdgb->helpers->getBlocksSpaces(get_fields());

    $trends = [];
    $title = (!empty(get_field('rdg_trends_title'))) ? get_field('rdg_trends_title') : ' ';
    $sport = (!empty(get_field('rdg_trends_sports'))) ? get_field('rdg_trends_sports') : null;
    $team = (!empty(get_field('rdg_trends_teams'))) ? get_field('rdg_trends_teams') : null;
    $items = (!empty(get_field('number_of_items'))) ? get_field('number_of_items') : 10;

    if ($block_trends->isCaching()) {
        $api_url = get_field('trends_api_url', 'option');
        $api_token = get_field('trends_api_token', 'option');

        if (!empty($api_url) && !empty($api_token)) {
            $api_attributes = $block_trends->getApiAttributes($items, ['sport' => $sport, 'team' => $team]);
            $block_custom_id = (!empty($block['data']['custom_id'])) ? $block['data']['custom_id'] : '';
            $post_id_custom = (!empty($block['data']['post_id'])) ? $block['data']['post_id'] : $post_id;
            $cache_file = $rdgb->helpers->getCacheName($block_name, $post_id_custom, $block_custom_id);
            $response = $block_trends->getResources($api_attributes, $cache_file);

            if (empty($response->message)) {
                $trends = $response->json[0]['data-content'][0][0]['trends'];
            } else {
                $trends = null;
                $message = $response->message;
            }
        } else {
            $message = __('Configure API connection correctly.');
        }
    }
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="content">
            <?php if (is_array($trends) && count($trends) > 0): ?>
                <div class="trends-box">
                    <div class="trends-title"><?php echo $title; ?></div>
                    <div class="trends-body">
                        <div class="trends">
                            <?php foreach ($trends as $trend): ?>
                                <div class="trend">
                                    <div class="content"><?php echo $trend['description']; ?></div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
