<?php 
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_name = BLOCK_RDG_TABLE_LEAGUES;
    $block_classes = [$block_name];
    $block_title = $rdgb->settings->getBlock($block_name);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $titles = get_field('titles');
    $position_block = $rdgb->helpers->getBlocksSpaces(get_fields());
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container content grid-container">
            <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

            <div class="table">
                <div class="filter">
                    <div class="select">
                        <select name="leagues" id="leagues">
                            <option value="all">All Leagues</option>
                        </select>
                    </div>
                    <div class="select">
                        <select name="types" id="types">
                            <option value="all">All Bet Types</option>
                        </select>
                    </div>
                    <div class="button">
                        <span>FILTER</span>
                    </div>
                </div>

                <div class="items">
                    <div class="item">
                        <div class="date">
                            <span class="date">2020/01/05</span>
                            <span class="type">NFL</span>
                        </div>
                        <div class="teams">
                            <span class="team-home">Seattle</span>
                            <span class="team-vs">@</span>
                            <span class="team-visitor">Philadelphia</span>
                        </div>
                        <div class="results">
                            <span>(17 - 9)</span>
                            <span>SPREAD</span>
                            <span>SEATTLE-1 (-110)</span>
                        </div>
                        <div class="units">
                            <span>1 UNITS</span>
                        </div>
                        <div class="status">
                            <span>WIN</span>
                        </div>
                    </div>
                    <div class="item">
                        <div class="date">
                            <span class="date">2020/01/05</span>
                            <span class="type">NFL</span>
                        </div>
                        <div class="teams">
                            <span class="team-home">Seattle</span>
                            <span class="team-vs">@</span>
                            <span class="team-visitor">Philadelphia</span>
                        </div>
                        <div class="results">
                            <span>(17 - 9)</span>
                            <span>SPREAD</span>
                            <span>SEATTLE-1 (-110)</span>
                        </div>
                        <div class="units">
                            <span>1 UNITS</span>
                        </div>
                        <div class="status">
                            <span>WIN</span>
                        </div>
                    </div>
                    <div class="item">
                        <div class="date">
                            <span class="date">2020/01/05</span>
                            <span class="type">NFL</span>
                        </div>
                        <div class="teams">
                            <span class="team-home">Seattle</span>
                            <span class="team-vs">@</span>
                            <span class="team-visitor">Philadelphia</span>
                        </div>
                        <div class="results">
                            <span>(17 - 9)</span>
                            <span>SPREAD</span>
                            <span>SEATTLE-1 (-110)</span>
                        </div>
                        <div class="units">
                            <span>1 UNITS</span>
                        </div>
                        <div class="status">
                            <span>WIN</span>
                        </div>
                    </div>
                    <div class="item">
                        <div class="date">
                            <span class="date">2020/01/05</span>
                            <span class="type">NFL</span>
                        </div>
                        <div class="teams">
                            <span class="team-home">Seattle</span>
                            <span class="team-vs">@</span>
                            <span class="team-visitor">Philadelphia</span>
                        </div>
                        <div class="results">
                            <span>(17 - 9)</span>
                            <span>SPREAD</span>
                            <span>SEATTLE-1 (-110)</span>
                        </div>
                        <div class="units">
                            <span>1 UNITS</span>
                        </div>
                        <div class="status">
                            <span>WIN</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
