<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Odd_Betting_Date extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_ODD_BETTING_DATE;
    private $block_folder_name = 'rdg-odd-betting-date';
    protected $block_title = 'RDG Odd Betting Date';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'odd', 'betting', 'date'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_styles_load = true;

    public function init() {
        $this->register_block();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_odd_betting_date.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'color-odd-betting-date-bg','slug' => 'color-odd-betting-date-bg','color' => '#ffffff'],
            ['name' => 'color-odd-betting-date-i','slug' => 'color-odd-betting-date-i','color' => '#0160ac'],
            ['name' => 'color-odd-betting-date-input','slug' => 'color-odd-betting-date-input','color' => '#3a96e0'],
            ['name' => 'color-odd-betting-date-input-bg','slug' => 'color-odd-betting-date-input-bg','color' => '#ffffff'],
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [
            [
                'customSelector' => '.rdg-odd-betting-date .date i',
                'fontWeight' => '900',
                'fontSize' => '1.3rem',
            ],
            [
                'customSelector' => '.rdg-odd-betting-date .date .date-center input[type=date]',
                'fontWeight' => '700',
                'fontSize' => '1rem',
            ],
        ];
    }
}

$rdg_odd_betting_date_class = new Rdg_Blocks_Odd_Betting_Date();
$rdg_odd_betting_date_class->init();

return $rdg_odd_betting_date_class;
