<?php
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_classes = ['rdg-favorite-cappers'];
    $block_name = BLOCK_RDG_FAVORITE_CAPPERS;
    $block_admin_cappers = $rdgb->settings->get_block($block_name);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $titles = get_field('titles');
    $cappers = get_field('cappers');

    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container content grid-container">
            <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>
            
            <?php if (!empty($cappers) && count($cappers) > 0): ?>
                <div class="cappers">
                    <?php foreach($cappers as $capper):?>
                        <div class="capper">
                            <div class="content">
                                <div class="capper-header">
                                    <div class="header-avatar">
                                        <?php if (isset($capper['logo']['url']) && !empty($capper['logo']['url'])): ?>
                                        <img src="<?php echo  $capper['logo']['url']; ?>" alt="">
                                        <?php endif; ?>
                                    </div>
                                    <div class="header-content">
                                        <span class="title"><?php echo $capper['title']; ?></span>
                                        <span class="sub-title"><?php echo $capper['sub_title']; ?></span>
                                        <span class="total"><?php echo $capper['total']; ?>
                                            <span class="picks"><?php echo $capper['picks']; ?></span>
                                        </span>
                                    </div>
                                </div>
                                <?php if (!empty($capper['description'])): ?>
                                    <div class="capper-description">
                                        <?php echo $capper['description']; ?>
                                    </div>
                                <?php endif; ?>
                                <div class="picks-available">
                                    <span><?php echo $capper['pick_available']; ?></span>
                                </div>
                                <?php if (!empty($capper['link'])): ?>
                                    <div class="capper-footer">
                                        <span><a href="<?php echo $capper['link']['url'];?>" target="<?php echo $capper['link']['target'];?>"><?php echo $capper['link']['title'];?></a></span>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
