<?php

global $rdgb;

$rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

$block_styles = [];
$block_classes = ['rdg-top-sites'];
$block_top_sites = $rdgb->settings->getBlock(BLOCK_RDG_TOP_SITES);

if (!empty($block['backgroundColor'])) {
    $block_classes[] = 'has-background';
    $block_classes[] = 'has-' . $block['backgroundColor'] . '-background-color';
}

if (!empty($block['style']['color']['background'])) {
    $block_styles[] = 'background-color: ' . $block['style']['color']['background'] . ';';
}

$titles = get_field('titles');
$position_block = $rdgb->helpers->getBlocksSpaces(get_fields());

$data = $block_top_sites->get_data();

?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>"
         style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container content grid-container">
            <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

            <?php if ($data): ?>
                <div class="rdg-top-sites-card">
                    <?php if (isset($data['title'])): ?>
                        <div class="card-header">
                            <h5><?php echo $data['title'] ?></h5>
                        </div>
                    <?php endif; ?>
                    <div class="card-content">
                        <?php if (isset($data['items']) && is_array($data['items'])): ?>
                            <table>
                                <?php foreach ($data['items'] as $item): ?>
                                    <tr>
                                        <td>
                                            <?php if (isset($item['image']) && is_array($item['image'])): ?>
                                                <img src="<?php echo $item['image']['url'] ?>"
                                                     alt="<?php echo $item['image']['alt'] ?>">
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo $item['description'] ?></td>
                                        <td>
                                            <?php if (isset($item['link']) && is_array($item['link'])): ?>
                                                <a href="<?php echo $item['link']['url'] ?>"
                                                   target="<?php echo $item['link']['target'] ?>">
                                                    <?php echo $item['link']['title'] ?>
                                                </a>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </table>
                        <?php endif; ?>
                    </div>
                    <div class="card-footer">
                        <?php if (isset($data['button']) && $data['button'] && isset($data['link']) && is_array($data['link'])): ?>
                            <a href="<?php echo $data['link']['url'] ?>"
                               target="<?php echo $data['link']['target'] ?>">
                                <?php echo $data['link']['title'] ?>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            <?php else: ?>
                <p>Please, complete the form.</p>
            <?php endif; ?>
        </div>
    </div>
</div>
