<?php 
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_classes = [];
    $block_bookie_selector = $rdgb->settings->getBlock(BLOCK_RDG_BOOKIE_SELECTOR);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $position_block = $rdgb->helpers->getBlocksSpaces(get_fields());

    $fields = [];
    $bookie_selected = (!empty(get_field('bookie_selected'))) ? get_field('bookie_selected') : null;

    
    if (!empty($bookie_selected)) {
        $fields = get_fields($bookie_selected);

        if (isset($fields['separator_group'])) {
            $fields['separator'] = $fields['separator_group'];
        }
    }

    if (is_array($fields) && count($fields) > 0) {
        $separator_style = $block_bookie_selector->get_style($fields, 'separator');
    }

    $logo_show = (!empty(get_field('logo_show'))) ? get_field('logo_show') : 'hide';
    $bookie_logo = (!empty($fields['logo']['bookie_logo'])) ? $fields['logo']['bookie_logo'] : null;

    $review_show = (!empty(get_field('review_show'))) ? get_field('review_show') : 'hide';
    $review_ranking = (!empty($fields['review_group']['ranking'])) ? $fields['review_group']['ranking'] : 0;
    $review_site = (!empty($fields['review_group']['site'])) ? $fields['review_group']['site'] : null;
    $review_since = (!empty($fields['review_group']['since'])) ? $fields['review_group']['since'] : null;
    $review_description = (!empty($fields['review_group']['description'])) ? $fields['review_group']['description'] : null;
    $offers_show = (!empty(get_field('offers_show'))) ? get_field('offers_show') : 'hide';
    $offers = (!empty($fields['offers_group']['offer'])) ? $fields['offers_group']['offer'] : null;

    if (is_array($offers) && count($offers) > 0) {
        $offers = $block_bookie_selector->get_buttons_attributes($offers);
    }
    
    $buttons_show = (!empty(get_field('buttons_show'))) ? get_field('buttons_show') : 'hide';
    $buttons = (!empty($fields['buttons_group']['buttons'])) ? $fields['buttons_group']['buttons'] : null;

    if (is_array($buttons) && count($buttons) > 0) {
        $buttons = $block_bookie_selector->get_buttons_attributes($buttons);
    }

    $items = null;
?>
<?php if (is_array($fields) && count($fields) > 0): ?>
<?php if ($logo_show == 'show' || $review_show == 'show' || $offers_show == 'show' || $buttons_show == 'show'): ?>
<div class="rdg-blocks">
    <div class="<?php echo BLOCK_RDG_BOOKIE_SELECTOR; ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="content <?php echo esc_attr(join(' ', $block_classes)); ?>">
            <?php if ($logo_show == 'show' && !empty($bookie_logo)): ?>
                <div class="header">
                    <div class="logo">
                        <img src="<?php echo $bookie_logo['url']; ?>" alt="Image">
                    </div>
                    <hr style="<?php echo $separator_style; ?>">
                </div>
            <?php endif; ?>

            <?php if ($review_show == 'show'): ?>
                <div class="bookie">
                    <?php if (!empty($review_ranking)): ?>
                        <div class="stars <?php echo (empty($sub_title)) ? 'ml-0' : ''; ?>">
                            <?php $block_bookie_selector->get_stars($review_ranking); ?>
                        </div>
                    <?php endif; ?>

                    <?php if (!empty($review_site) || !empty($review_since) || !empty($review_description)): ?>
                        <div class="site">
                            <?php if (!empty($review_site)): ?>
                                <span class="url"><?php echo $review_site; ?></span>
                            <?php endif; ?>

                            <?php if (!empty($review_since)): ?>
                                <span class="since"><?php echo $review_since; ?></span>
                            <?php endif; ?>

                            <?php if (!empty($review_description)): ?>
                                <span class="description"><?php echo $review_description; ?></span>
                            <?php endif; ?>

                            <?php if ($offers_show == 'show' && is_array($offers) && count($offers) > 0): ?>
                                <?php $items = $offers; ?>
                                <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/buttons.php'; ?>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endif; ?>

            <?php if ($buttons_show == 'show' && is_array($buttons) && count($buttons) > 0): ?>
                <hr style="<?php echo $separator_style; ?>">
                <?php $items = $buttons; ?>
                <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/buttons.php'; ?>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php endif; ?>
<?php endif; ?>