<?php
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_classes = ['rdg-admin-cappers'];
    $block_name = BLOCK_RDG_ADMIN_CAPPERS;
    $block_admin_cappers = $rdgb->settings->getBlock($block_name);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $titles = get_field('titles');
    $cappers = get_field('cappers');
    $links = get_field('links');

    $position_block = $rdgb->helpers->getBlocksSpaces(get_fields());
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

        <?php if (!empty($cappers) && is_array($cappers) && count($cappers) > 0): ?>
            <div class="cappers">
                <?php foreach($cappers as $capper):?>
                    <?php if (is_array($capper)): ?>
                        <div class="capper">
                            <div class="content">
                                <div class="capper-header">
                                    <div class="header-avatar">
                                        <?php if (isset($capper['logo']['url']) && !empty($capper['logo']['url'])): ?>
                                            <img src="<?php echo $capper['logo']['url']; ?>" alt="">
                                        <?php endif; ?>
                                    </div>
                                    <div class="header-content">
                                        <span class="title"><?php echo $capper['title']; ?></span>
                                        <span class="sub-title"><?php echo $capper['sub_title']; ?></span>
                                        <span class="total"><?php echo $capper['total']; ?>
                                            <span class="picks"><?php echo $capper['picks']; ?></span>
                                        </span>
                                    </div>
                                </div>

                                <div class="capper-content">
                                    <?php if (!empty($capper['description'])): ?>
                                        <div class="content-description"><?php echo $capper['description']; ?> </div>
                                    <?php endif; ?>

                                    <?php if (is_array($capper['teams']) && count($capper['teams']) > 0): ?>
                                        <div class="teams">
                                            <?php foreach($capper['teams'] as $team): ?>
                                                <div class="team">
                                                    <div class="content-category">
                                                        <div class="category">
                                                            <span><?php echo $team['category']; ?></span>
                                                        </div>
                                                        <div class="date">
                                                            <span><?php echo $team['date']; ?></span>
                                                        </div>
                                                        <div class="status">
                                                            <span><?php echo $team['status']; ?></span>
                                                        </div>
                                                    </div>

                                                    <div class="content-teams">
                                                        <span class="team-home">
                                                                <?php echo $team['home_team']; ?>
                                                        </span>
                                                        <span class="team-vs">@</span>
                                                        <span class="team-visitor">
                                                            <?php echo $team['visitor_team']; ?>
                                                        </span>
                                                    </div>

                                                    <div class="content-release">
                                                        <span class="release-date">Release Date:
                                                            <span><?php echo $team['release_date']; ?></span>
                                                        </span>
                                                    </div>
                                                </div>
                                            <?php endforeach; ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <div class="capper-footer">
                                <div class="footer-link">
                                    <?php if (isset($capper['link']['url']) && !empty($capper['link']['url'])): ?>
                                        <a href="<?php echo $capper['link']['url']; ?>"><?php echo $capper['link']['title']; ?></a>
                                    <?php endif; ?>
                                </div>
                                <div class="footer-status">
                                    <span><?php echo $capper['status']; ?></span>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>

        <?php if (is_array($links) && count($links) > 0): ?>
            <div class="buttons">
                <?php foreach($links as $link): ?>
                    <?php
                        $link_class = '';
                        $link_style = '';
                        if ($link['default_styles'] != 'custom') {
                            $link_class = 'class="'.$link['default_styles'].'"';
                        } else {
                            $link_style = 'onMouseOut="this.style.backgroundColor=\''.$link['background_color'].'\'" onmouseover="this.style.backgroundColor=\''.$link['background_hover_color'].'\'" class="link-default" style="'.$block_admin_cappers->get_style('buttons', $link).'"';
                        }
                    ?>
                    <?php if (!empty($link['link']['url']) && $link['link']['title']): ?>
                        <a href="<?php echo $link['link']['url']; ?>" <?php echo $link_class; ?> <?php echo $link_style; ?>><?php echo $link['link']['title']; ?></a>
                    <?php endif; ?>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</div>
