<?php 
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_name = BLOCK_RDG_HANDICAPPERS_HUB;
    $block_classes = [$block_name];
    $block_handicappers_hub = $rdgb->settings->getBlock($block_name);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $titles = get_field('titles');
    $position_block = $rdgb->helpers->getBlocksSpaces(get_fields());

    $items = (!empty(get_field('number_of_items'))) ? get_field('number_of_items') : 8;
    $sport = (!empty(get_field('handicapppers_hub_sport'))) ? get_field('handicapppers_hub_sport') : null;
    $duration = (!empty(get_field('handicapppers_hub_date_range'))) ? get_field('handicapppers_hub_date_range') : 365;
    $package = (!empty(get_field('handicapppers_hub_package'))) ? get_field('handicapppers_hub_package') : null;

    $handicappers = null;
    $api_attributes = [];
    $block_custom_id = (!empty($block['data']['custom_id'])) ? $block['data']['custom_id'] : '';
    $post_id_custom = (!empty($block['data']['post_id'])) ? $block['data']['post_id'] : $post_id;
    $cache_file = $rdgb->helpers->getCacheName($block_name, $post_id_custom, $block_custom_id);

    if ($block_handicappers_hub->isCaching()) {
        $api_url = get_field('handicappers_hub_api_url', 'option');
        $api_token = get_field('handicappers_hub_api_token', 'option');

        if (!empty($api_url) && !empty($api_token)) {
            $api_attributes = $block_handicappers_hub->getApiAttributes($items, ['sport' => $sport, 'duration' => $duration, 'package' => $package]);
            $response = $block_handicappers_hub->getResources($api_attributes, $cache_file);

            if (empty($response->message) && is_array($response->json)) {
                $handicappers = $response->json['handicappers'];
            } else {
                $handicappers = null;
                $message = $response->message;
            }
        } else {
            $message = __('Configure API connection correctly.');
        }
    }

    $fields = $block_handicappers_hub->getFieldsValidate();
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container content grid-container">
            <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

            <?php if (is_array($handicappers) && count($handicappers) > 0): ?>
            <div class="handicappers">
                <?php foreach ($handicappers as $handicapper): ?>
                    <?php if (!$rdgb->helpers->validateFields($fields, $handicapper)) continue; ?>
                    <div class="handicapper">
                        <div class="handicapper-header">
                            <div class="header-image">
                                <?php
                                    $image = $block_handicappers_hub->getImage($handicapper['image'], [
                                        'image_type' => 'handicappers_hub',
                                        'image_alt' => $handicapper['name'],
                                        'logo_label' => true
                                    ]);
                                ?>
                                <img src="<?php echo $image['url']; ?>" alt="<?php echo $image['alt']; ?>">
                            </div>
                            <div class="header-content">
                                <div class="header-name"><a href="<?php echo $handicapper['profile_url']; ?>"><?php echo $handicapper['name']; ?></a></div>
                                <?php if (isset($handicapper['group'][0]['name']) && !empty($handicapper['group'][0]['name']) && isset($handicapper['group_url']) && !empty($handicapper['group_url'])): ?>
                                    <div class="header-package">
                                        <a href="<?php echo $handicapper['group_url']; ?>"><?php echo $handicapper['group'][0]['name']; ?></a>
                                    </div>
                                <?php endif; ?>
                                <?php
                                    $stat_class = (strpos($handicapper['last_days_amount'], '-') === 0) ? 'danger' : 'success';
                                    if ($stat_class === 'success') {
                                        $handicapper['last_days_amount'] = '+' . $handicapper['last_days_amount'];
                                    }
                                ?>
                                <div class="header-stats">Won in Last <?php echo $handicapper['last_days']; ?> days <span class="<?php echo $stat_class; ?>"><?php echo $handicapper['last_days_amount']; ?></span></div>
                            </div>
                        </div>
                        <div class="handicapper-body">
                            <div class="body-content">
                                <?php
                                    $paragraphs = preg_split('/\n+/', trim(strip_tags($handicapper['bio'])));
                                    $result = implode('. ', array_map('trim', $paragraphs));
                                    echo $result;
                                ?>
                            </div>
                        </div>
                        <div class="handicapper-footer">
                            <div class="footer-content">
                                <a href="<?php echo $handicapper['profile_url']; ?>">
                                    <div class="footer-button primary">Get All Picks</div>
                                </a>
                                <a href="<?php echo $handicapper['profile_url']; ?>">
                                    <div class="footer-button">
                                        <span class="button-picks"><?php echo $handicapper['today_picks']; ?> Picks available</span>
                                        <span class="button-capper"><?php echo $handicapper['name']; ?></span>
                                    </div>
                                </a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>
