<?php
    $betTypeMap = [
    '-1' => 'Spread', '0'  => 'Spread', '1'  => 'Spread',
    '-1,0,1'  => 'Spread', '-1,0,1,>' => 'Spread + Dogs', '-1,0,1,<' => 'Spread - Fav',
    '4'  => 'Money Line', '5'  => 'Money Line', '6'  => 'Money Line',
    '4,5,6'  => 'Money Line', '4,5,6,>' => 'Money Line + Dogs', '4,5,6,<' => 'Money Line - Fav',
    '2'  => 'Over Bet', '3'  => 'Under Bet', '2,3'  => 'Totals',
    ];

    if (!function_exists('getBetTypeName')) {
        function getBetTypeName($betType, $betTypeMap) {
            return $betTypeMap[$betType] ?? 'Unknown';
        }
    }
?>

<?php if (!empty($pick_results['data']) && is_array($pick_results['data'])): ?>
    <?php $fields = $block_handicapper_pick_results->getFieldsValidate(); ?>
    
    <table>
        <thead>
            <tr>
                <th scope="col">GAME DATE</th>
                <th scope="col">SPORT</th>
                <th scope="col">TEAMS</th>
                <th scope="col">SCORE</th>
                <th scope="col">BET TYPE</th>
                <th scope="col">DESCRIPTION</th>
                <th scope="col">RESULT</th>
            </tr>
        </thead>
        <tbody id="table-body">
            <?php foreach ($pick_results['data'] as $index => $pick_result): 
                    $formatted_date = date('Y-m-d', strtotime($pick_result['date_settled']));
                ?>
                <?php if ($rdgb->helpers->validateFields($fields, $pick_result)): ?>
                    <tr class="table-row" <?= $index >= 10 ? 'style="display: none;"' : ''; ?>>
                        <td data-label="Date"><?= htmlspecialchars($formatted_date ); ?></td>
                        <td data-label="Sport" class="sport"><?= htmlspecialchars($pick_result['pick_details'][0]['game']['id_sport']['sport_name'] ?? 'N/A'); ?></td>
                        <td data-label="Teams" class="teams">
                            <div class="team-wrapper">
                                <p class="team"><?= htmlspecialchars($pick_result['pick_details'][0]['game']['id_visitor_team']['name'] ?? 'N/A'); ?></p>
                                @ 
                                <p class="team"><?= htmlspecialchars($pick_result['pick_details'][0]['game']['id_home_team']['name'] ?? 'N/A'); ?></p>
                            </div>
                        </td>
                        <td data-label="Score" class="score">
                            <?= htmlspecialchars($pick_result['pick_details'][0]['game']['visitor_score'] ?? 'N/A'); ?> - 
                            <?= htmlspecialchars($pick_result['pick_details'][0]['game']['home_score'] ?? 'N/A'); ?>
                        </td>
                        <td data-label="Bet Type" class="bet-type">
                            <?= htmlspecialchars(getBetTypeName($pick_result['bet_type'], $betTypeMap)); ?>
                        </td>
                        <td data-label="Description" class="description"><?= htmlspecialchars($pick_result['pick_details'][0]['description'] ?? 'N/A'); ?></td>
                        <td data-label="Result">
                            <?php if ($pick_result['result'] === 'Win') : ?>
                                <span class="win"><?= $pick_result['result']?></span>
                            <?php elseif ($pick_result['result'] === 'Lose') : ?>
                                <span class="lose"><?= $pick_result['result']?></span>
                            <?php else : ?>
                                <span class="draw"><?= $pick_result['result']?></span>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endif; ?>
            <?php endforeach; ?>
        </tbody>
    </table>

    <?php if (count($pick_results['data']) > 10): ?>
    <div class="load-more">
        <button id="load-more">Load More</button>
    </div>
        
    <?php endif; ?>
<?php else: ?>
    <p>No picks available for this selection.</p>
<?php endif; ?>
