<?php if (!empty($picks) && is_array($picks)): ?>
    <?php $fields = $block_scores_and_odds->getFieldsValidate(); ?>
    <?php foreach ($picks as $pick): ?>
        <?php
        if (!$rdgb->helpers->validateFields($fields, $pick)) continue;

        $game_datetime = DateTime::createFromFormat('Y-m-d H:i:s', $pick['game_date']);
        $formatted_game_date = sprintf('%s EST', $game_datetime->format('M d, Y H:i'));

        $odds = $pick['opener_game_odds'][0] ?? [];

        $format_odds = function ($value) {
            return isset($value) && $value !== null ? (strpos($value, "-") === 0 ? "" : "+") . $value : "-";
        };

        $valid_extensions = ['png', 'jpg', 'jpeg', 'webp', 'gif', 'svg'];
        $is_valid_image = function ($url) use ($valid_extensions) {
            $path_info = pathinfo($url);
            return isset($path_info['extension']) && in_array(strtolower($path_info['extension']), $valid_extensions);
        };

        $pick_text = ($pick['game_picks_count'] == 1) ? "1 Pick" : "{$pick['game_picks_count']} Picks";
        $pick_text .= ($pick['game_stat'] === "Final") ? " Made" : " Available";
        ?>

        <div class="sao-wrapper">
            <div class="header">
                <p><?= $pick['home_team']; ?></p>
                <p>vs</p>
                <p><?= $pick['visitor_team']; ?></p>
            </div>
            <div class="body">
                <div class="versus">
                    <div class="team-a">
                        <?php if (!empty($pick['home_image']) && $is_valid_image($pick['home_image'])): ?>
                            <?php $home_image = $block_scores_and_odds->get_image($pick['home_image'], [
                                'image_type' => 'scores_and_odds',
                                'image_alt' => $pick['home_team'] . ' Game Odds',
                                'logo_label' => false,
                            ]); ?>
                            <img src="<?= $home_image['url']; ?>" alt="<?= $home_image['alt']; ?>">
                        <?php endif; ?>
                    </div>
                    <div class="vs">
                        <p class="state"> <?= $pick['game_stat']; ?> </p>
                        <p class="vs-p">vs</p>
                        <p class="date"> <?= $formatted_game_date; ?> </p>
                    </div>
                    <div class="team-b">
                        <?php if (!empty($pick['visitor_image']) && $is_valid_image($pick['visitor_image'])): ?>
                            <?php $visitor_image = $block_scores_and_odds->get_image($pick['visitor_image'], [
                                'image_type' => 'scores_and_odds',
                                'image_alt' => $pick['visitor_team'] . ' Game Odds',
                                'logo_label' => false,
                            ]); ?>
                            <img src="<?= $visitor_image['url']; ?>" alt="<?= $visitor_image['alt']; ?>">
                        <?php endif; ?>
                    </div>
                </div>
                <div class="stats">
                    <div class="stat">
                        <p class="team-a"> <?= $pick['home_score'] ?? '-'; ?> </p>
                        <p class="name">Score</p>
                        <p class="team-b"> <?= $pick['visitor_score'] ?? '-'; ?> </p>
                    </div>
                    <div class="stat">
                        <p class="team-a">
                            <?php
                            $spread_home_points = $odds['spread_home_points'] ?? null;
                            $spread_home_odds = $odds['spread_home_odds'] ?? null;

                            if ($spread_home_points !== null || $spread_home_odds !== null) {
                                echo trim(($spread_home_points !== null ? $format_odds($spread_home_points) : '-') . ' ' .
                                        ($spread_home_odds !== null ? $format_odds($spread_home_odds) : '-'));
                            } else {
                                echo '-';
                            }
                            ?>
                        </p>
                        <p class="name">Spread</p>
                        <p class="team-b">
                            <?php
                            $spread_visitor_points = $odds['spread_visitor_points'] ?? null;
                            $spread_visitor_odds = $odds['spread_visitor_odds'] ?? null;

                            if ($spread_visitor_points !== null || $spread_visitor_odds !== null) {
                                echo trim(($spread_visitor_points !== null ? $format_odds($spread_visitor_points) : '-') . ' ' .
                                        ($spread_visitor_odds !== null ? $format_odds($spread_visitor_odds) : '-'));
                            } else {
                                echo '-';
                            }
                            ?>
                        </p>
                    </div>
                    <div class="stat">
                        <p class="team-a"> <?= !empty($odds['total_over_points']) ? 'o' . $format_odds($odds['total_over_points']) . $format_odds($odds['total_over_odds']) : '-'; ?> </p>
                        <p class="name">Total</p>
                        <p class="team-b"> <?= !empty($odds['total_under_points']) ? 'u' . $format_odds($odds['total_under_points']) . $format_odds($odds['total_under_odds']) : '-'; ?> </p>
                    </div>
                    <div class="stat">
                        <p class="team-a">
                            <?= isset($odds['money_line_home_odds']) && $odds['money_line_home_odds'] !== null 
                                ? (is_numeric($odds['money_line_home_odds']) 
                                    ? (strpos($odds['money_line_home_odds'], "-") === 0 ? "" : "+") . $odds['money_line_home_odds']
                                    : "-")
                                : "-"; ?>
                        </p>
                        <p class="name">Moneyline</p>
                        <p class="team-b">
                            <?= isset($odds['money_line_visitor_odds']) && $odds['money_line_visitor_odds'] !== null 
                                ? (is_numeric($odds['money_line_visitor_odds']) 
                                    ? (strpos($odds['money_line_visitor_odds'], "-") === 0 ? "" : "+") . $odds['money_line_visitor_odds']
                                    : "-")
                                : "-"; ?>
                        </p>
                    </div>
                </div>
                <div class="ctas">
                    <?php
                        $preview = false;
                        if (is_array($games_previews) && isset($pick['id_preview']) 
                            && !empty($pick['id_preview']) && isset($games_previews[$pick['id_preview']]) 
                            && !empty($games_previews[$pick['id_preview']])) {
                                $preview = true;
                        }
                    ?>
                    <?php if (!empty($pick['game_url'])): ?>
                        <a href="<?= $pick['game_url']; ?>" target="_blank" class="pick">
                            <?= $pick_text; ?>
                        </a>
                    <?php endif; ?>
                    <?php if ($preview): ?>
                        <a href="<?= get_permalink($games_previews[$pick['id_preview']]); ?>" target="_blank" class="preview">
                            <?= __('Preview & Prediction', BLOCK_RDG_SCORES_AND_ODDS); ?>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    <?php endforeach; ?>
<?php else: ?>
    <p>No picks available.</p>
<?php endif; ?>