<?php 
    if (isset($block['data']['isExample']) && $block['data']['isExample']) {
        echo '<img src="' . esc_url( $block['data']['preview_image'] ) . '"style="max-width:100%; min-width:100%" alt="Preview" />';
        return;
    }

    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_name = BLOCK_RDG_SCORES_AND_ODDS;
    $block_classes = [$block_name];
    $block_scores_and_odds = $rdgb->settings->getBlock($block_name);
    $block_id = (isset($block['data']['custom_id']) && !empty($block['data']['custom_id'])) ? 
        $block['data']['custom_id'] : $block['id'];

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $source = get_field('block_type');
    $date_type = (!empty(get_field('date_type'))) ? get_field('date_type') : 'latest';
    $specific_date = (!empty(get_field('specific_date'))) ? get_field('specific_date') : date("Y-m-d");
    $from_day = (!empty(get_field('from_day'))) ? get_field('from_day') : date("Y-m-d");
    $to_day = (!empty(get_field('to_day'))) ? get_field('to_day') : date("Y-m-d");
    $sports = (!empty(get_field('sports'))) ? get_field('sports') : '';

    $titles = get_field('titles');
    $position_block = $rdgb->helpers->getBlocksSpaces(get_fields());

    $cache_file = null;
    $api_attributes = null;
    $post_id = get_the_ID();
    $picks = [];

    if ($source == 'api' && $block_scores_and_odds->isCaching()) {
        $api_url = get_field('scores_and_odds_api_url', 'option');
        $api_token = get_field('scores_and_odds_api_token', 'option');
        $items = (!empty(get_field('number_of_items'))) ? intval(get_field('number_of_items')) : 1;

        if (!empty($api_url) && !empty($api_token)) {
            $api_attributes = $block_scores_and_odds->getApiAttributes($items, ['date_type' => $date_type, 'specific' => $specific_date, 'from_day' => $from_day, 'to_day' => $to_day, 'sports' => $sports]);

            $block_custom_id = (!empty($block['data']['custom_id'])) ? $block['data']['custom_id'] : '';
            $post_id_custom = (!empty($block['data']['post_id'])) ? $block['data']['post_id'] : $post_id;
            $cache_file = $rdgb->helpers->getCacheName($block_name, $post_id_custom, $block_custom_id);
            $response = $block_scores_and_odds->getResources($api_attributes, $cache_file);

            if (empty($response->message) && is_array($response->json)) {
                $picks = $response->json;
            } else {
                $picks = null;
                $message = $response->message;
            }
        } else {
            $message = __('Configure API connection correctly.');
        }
    }

    $games_previews = $block_scores_and_odds->getPreviews($picks);
?>
<?php if (is_array($picks) && count($picks) > 0): ?>
    <div class="rdg-blocks">
        <?php
            $params = ['cache_file' => $cache_file, 'api_request' => $api_attributes];
            $block_scores_and_odds->getLogDebug($params);
        ?>
        <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
            <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>
            <div class="sao-container">
                <?php
                    if ($source == 'api') {
                        require 'partials/api.php';
                    } else {
                        require 'partials/manual.php';
                    }
                ?>
            </div>
        </div>
    </div>
<?php endif; ?>
