<?php  
    if (isset($block['data']['isExample']) && $block['data']['isExample']) {
        echo '<img src="' . esc_url( $block['data']['preview_image'] ) . '"style="max-width:100%; min-width:100%" alt="Preview" />';
        return;
    }
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_name = BLOCK_RDG_SECONDARY_BANNER;
    $block_classes = [$block_name];
    $block_admin_cappers = $rdgb->settings->getBlock($block_name);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $description = get_field('description');
    $background = get_field('background');
    $linkBtn = esc_url(get_field('link_btn'));
    $textBtn = esc_html(get_field('text_btn'));
    $position_block = $rdgb->helpers->getBlocksSpaces(get_fields());
    $link_attributes = get_field('link_attributes');
    $show_image_mobile = get_field('show_image_mobile');
    $image_class = $show_image_mobile ? '' : 'hide-on-mobile';
    $image_description = get_field('image_description');
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="secondary-banner-container">
            <div class="left">
                <?php echo $description; ?>
            </div>
            <?php
                $image_style = isset($background['url'])
                    ? sprintf("background-image: url('%s');", $background['url'])
                    : '';
            
                if($textBtn && $linkBtn):
                    $rel_attributes = '';

                    if( !empty( $link_attributes ) ) {
                        $rel_attributes = implode(' ', $link_attributes);
                    }

            ?>
                    <div class="right" style="<?php echo $image_style; ?>">

                        <?php
                            if( get_field('field_image_description') ): ?>
                                <img src="<?php echo esc_url( get_field('field_image_description') ); ?>" class="<?php echo esc_attr( $image_class ); ?>" alt="Secondary Banner Image">
                        <?php endif; ?>
                        <a href="<?php echo $linkBtn; ?>"
                            class="btn" 
                            <?php if( $rel_attributes ): ?>rel="<?php echo esc_attr( $rel_attributes ); ?>"<?php endif; ?>><?php echo $textBtn; ?>
                        </a>
                    </div>
                <?php endif; ?>
        </div>
    </div>
</div>
