<?php  
    if (isset($block['data']['isExample']) && $block['data']['isExample']) {
        echo '<img src="' . esc_url( $block['data']['preview_image'] ) . '"style="max-width:100%; min-width:100%" alt="Preview" />';
        return;
    }
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_name = BLOCK_RDG_SAS_NAVBAR;
    $block_classes = [$block_name];
    $block_admin_cappers = $rdgb->settings->getBlock($block_name);
    
    $full_container = get_field('full_container');
    $site_logo = get_field('site_logo');
    $site_logo_link = get_field('site_logo_link');
    $login_link = get_field('login_link');
    $sign_up_link = get_field('sign_up_link');
?>

<div class="rdg-blocks">
    <style>
        @property --color-rdg-navbar-hyperlink {syntax: "<color>";inherits: true;initial-value: #fff;}@property --color-rdg-navbar-hyperlink-hover {syntax: "<color>";inherits: true;initial-value: #6aa0e5;}@property --color-rdg-navbar-hyperlink-submenu {syntax: "<color>";inherits: true;initial-value: #000;}@property --color-rdg-navbar-hyperlink-submenu-bg {syntax: "<color>";inherits: true;initial-value: #275fa6;}@property --color-rdg-navbar-hyperlink-submenu-hover {syntax: "<color>";inherits: true;initial-value: #fff;}@property --color-rdg-navbar-background {syntax: "<color>";inherits: true;initial-value: #275fa6;}@property --color-rdg-navbar-input-container {syntax: "<color>";inherits: true;initial-value: #6aa0e5;}@property --color-rdg-navbar-secondary-hyperlink {syntax: "<color>";inherits: true;initial-value: #6aa0e5;}@property --color-rdg-navbar-divider {syntax: "<color>";inherits: true;initial-value: #6aa0e5;}@property --color-rdg-secondary-bg-mobile {syntax: "<color>";inherits: true;initial-value: #efefef;}@property --color-rdg-secondary-link-mobile {syntax: "<color>";inherits: true;initial-value: #6aa0e5;}@property --color-rdg-search {syntax: "<color>";inherits: true;initial-value: #6aa0e5;}@property --color-rdg-sign-up {syntax: "<color>";inherits: true;initial-value: #ff7a00;}@property --color-rdg-login {syntax: "<color>";inherits: true;initial-value: #6aa0e5;}.rdg-blocks .rdg-sas-navbar a {color: var(--color-rdg-navbar-hyperlink);text-wrap: nowrap;text-decoration: none;}.rdg-blocks .rdg-sas-navbar .dont-show {display: none;}.rdg-blocks .rdg-sas-navbar #inputWrapper {display: none;}.rdg-blocks .rdg-sas-navbar .full-width {margin-left: calc(-100vw / 2 + 100% / 2);margin-right: calc(-100vw / 2 + 100% / 2);max-width: 100vw;width: auto;}.rdg-blocks .rdg-sas-navbar input[type="text"] {background-color: var(--color-white);border-color: transparent;width: 100%;}.rdg-blocks .rdg-sas-navbar .sas-navbar-container {background-color: var(--color-rdg-navbar-background);padding: 1rem 0;position: relative;}.rdg-blocks .rdg-sas-navbar .sas-navbar-container #search-form {position: absolute;top: 100%;left: 0;width: 100vw;display: none;}.rdg-blocks .rdg-sas-navbar .sas-navbar-container #search-form .input-container {display: flex;width: 100%;background-color: var(--color-rdg-navbar-input-container);padding: 1rem 20px;justify-content: center;}.rdg-blocks .rdg-sas-navbar .sas-navbar-container #search-form .input-container .input-wrapper {display: flex;justify-content: space-between;align-items: center;width: 100%;max-width: 659px;background-color: var(--color-white);}.rdg-blocks .rdg-sas-navbar .sas-navbar-container #search-form .input-container .input-wrapper #search-input {width: 100%;height: 32px;border: none;padding: 0 8px;box-sizing: border-box;}.rdg-blocks .rdg-sas-navbar .sas-navbar-container #search-form .input-container .input-wrapper #search-input:focus, .rdg-blocks .rdg-sas-navbar .sas-navbar-container #search-form .input-container .input-wrapper #search-input:focus-visible {outline: none;border-color: transparent;background-color: var(--color-white);}.rdg-blocks .rdg-sas-navbar .sas-navbar-container #search-form .input-container .input-wrapper .search-svg {filter: brightness(0) saturate(100%) invert(77%) sepia(43%) saturate(5336%) hue-rotate(187deg) brightness(99%) contrast(81%);padding: 10px 15px;}.rdg-blocks .rdg-sas-navbar .sas-navbar-container #search-form.expanded {display: block;}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container {padding-left: 20px;padding-right: 20px;}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .secondary-menu {display: flex;align-items: center;justify-content: flex-end;gap: 0.5rem;margin-bottom: 1rem;}@media (max-width: 768px) {.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .secondary-menu {display: none;}}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .secondary-menu a {color: var(--color-rdg-navbar-secondary-hyperlink);font-size: 13px;font-weight: 400;line-height: normal;letter-spacing: 0.26px;border-right: 1px solid var(--color-rdg-navbar-secondary-hyperlink);padding-right: 0.5rem;transition: all ease 0.3s;}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .secondary-menu a:hover {color: var(--color-white);text-decoration: underline;}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .secondary-menu a:last-child {border-right: none;padding-right: 0;}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .secondary-menu .lenguage-btn {display: flex;align-items: center;gap: 4px;}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu {display: flex;align-items: center;justify-content: space-between;}@media (max-width: 768px) {.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu {flex-direction: column;}}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .top-container {display: flex;align-items: center;flex: 3;}@media (max-width: 768px) {.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .top-container {justify-content: space-between;width: 100%;border-bottom: 2px solid var(--color-rdg-navbar-divider);margin-bottom: 1rem;padding-bottom: 1rem;}}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .top-container .site-logo-wrapper {flex: 1;display: flex;align-items: center;margin-right: 0.5rem;}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .top-container .primary-navigation {flex: 2;display: flex;align-items: center;justify-content: center;}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .top-container .primary-navigation .toggle-container {display: none;}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .top-container .primary-navigation .navbar-links ul {margin: 0;padding: 0;list-style: none;display: flex;transition: max-height 0.3s ease-out;gap: 0 2rem;}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .top-container .primary-navigation .navbar-links ul li {position: relative;}@media (max-width: 768px) {.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .top-container .primary-navigation .navbar-links ul li {padding: 0 20px;}}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .top-container .primary-navigation .navbar-links ul .nav-dropdown .dropdown-wrapper {display: flex;align-items: center;justify-content: space-between;gap: 4px;width: 100%;}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .top-container .primary-navigation .navbar-links ul .nav-dropdown .dropdown-wrapper a {text-decoration: none;}@media (max-width: 768px) {.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .top-container .primary-navigation .navbar-links ul .nav-dropdown .dropdown-wrapper a {padding: 1rem 0;font-weight: 600;}}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .top-container .primary-navigation .navbar-links ul .nav-dropdown .dropdown-wrapper .dropdown {padding: 4px;cursor: pointer;}@media (max-width: 768px) {.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .top-container .primary-navigation .navbar-links ul .nav-dropdown .dropdown-wrapper .dropdown.active + .dropdown-content {display: block !important;}}@media (min-width: 769px) {.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .top-container .primary-navigation .navbar-links ul .nav-dropdown .dropdown-content {position: absolute;top: 100%;left: 0;z-index: 999 !important;}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .top-container .primary-navigation .navbar-links ul .nav-dropdown:hover .dropdown-content {display: block !important;}}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .top-container .primary-navigation .navbar-links ul .nav-dropdown .dropdown-content {display: none;background-color: var(--color-white);min-width: 160px;box-shadow: 0px 8px 16px rgba(0, 0, 0, 0.2);}@media (min-width: 769px) {.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .top-container .primary-navigation .navbar-links ul .nav-dropdown .dropdown-content {position: absolute;top: 100%;left: 0;}}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .top-container .primary-navigation .navbar-links ul .nav-dropdown .dropdown-content .submenu-icon {display: flex;align-items: center;gap: 8px;}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .top-container .primary-navigation .navbar-links ul .nav-dropdown .dropdown-content a {color: var(--color-rdg-navbar-hyperlink-submenu);padding: 12px 16px;text-decoration: none;width: 100%;min-width: max-content;}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .top-container .primary-navigation .navbar-links ul .nav-dropdown .dropdown-content a:hover {background-color: var(--color-rdg-navbar-hyperlink-submenu-bg);color: var(--color-rdg-navbar-hyperlink-submenu-hover);text-decoration: none;}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .top-container .primary-navigation .navbar-links a {color: var(--color-rdg-navbar-hyperlink);text-decoration: none;display: block;padding: 10px 0;font-size: 16px;line-height: normal;letter-spacing: 0.32px;}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .top-container .primary-navigation .navbar-links a:hover {text-decoration: underline;color: var(--color-rdg-navbar-hyperlink-hover);}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .top-container .primary-navigation .toggle-button, .rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .top-container .primary-navigation .toggle-button-x {font-size: 1.5em;color: var(--color-white);cursor: pointer;display: none;}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .top-container .primary-navigation .toggle-button-x {display: none;}@media (max-width: 768px) {.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .top-container .primary-navigation .primary-navigation {position: relative;}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .top-container .primary-navigation .navbar-links {display: none;flex-direction: column;width: 100%;background-color: var(--color-white);position: absolute;top: 135px;left: 0;z-index: 2 !important;}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .top-container .primary-navigation .navbar-links a {color: var(--color-rdg-navbar-hyperlink-submenu);}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .top-container .primary-navigation .navbar-links a:hover {background-color: var(--color-rdg-navbar-hyperlink-submenu-bg);color: var(--color-rdg-navbar-hyperlink);text-decoration: none;}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .top-container .primary-navigation .navbar-links.active {display: flex;max-height: 100%;}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .top-container .primary-navigation .navbar-links ul {flex-direction: column;justify-content: center;align-items: start;background-color: var(--color-white);}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .top-container .primary-navigation .navbar-links ul li {width: 100%;}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .top-container .primary-navigation .toggle-button {display: block;}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .top-container .primary-navigation .toggle-button.active {display: none;}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .top-container .primary-navigation .toggle-button-x.active {display: block;}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .top-container .primary-navigation .toggle-container {display: flex;justify-content: flex-end;width: 100%;}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .top-container .primary-navigation .dropdown-content {display: none;box-shadow: none !important;}}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .top-container .primary-navigation .secondary-menu-mobile {display: none;}@media (max-width: 768px) {.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .top-container .primary-navigation .secondary-menu-mobile {display: flex;flex-direction: column;align-items: flex-start;background-color: var(--color-rdg-secondary-bg-mobile);padding: 0 20px;}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .top-container .primary-navigation .secondary-menu-mobile a {color: var(--color-rdg-secondary-link-mobile);padding: 13px 0;border-bottom: 1px solid var(--color-white);width: 100%;font-size: 14px;line-height: normal;letter-spacing: 0.28px;}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .top-container .primary-navigation .secondary-menu-mobile a.last-child {border-bottom: none;}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .top-container .primary-navigation .secondary-menu-mobile .lenguage-btn {display: flex;gap: 4px;}}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .nav-mobile-container {flex: 1;}@media (max-width: 768px) {.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .nav-mobile-container {width: 100%;display: flex;align-items: center;justify-content: space-between;}}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .nav-mobile-container .search-mobile {display: none;}@media (max-width: 768px) {.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .nav-mobile-container .search-mobile {display: flex;}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .nav-mobile-container .search-mobile .search-icon-mobile {width: 32px;height: 32px;background-color: var(--color-rdg-search);border-radius: 50%;display: flex;justify-content: center;align-items: center;cursor: pointer;position: relative;transition: border-radius 0.3s ease;}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .nav-mobile-container .search-mobile .search-icon-mobile #search-connector-mobile {width: 32px;height: 32px;background-color: var(--color-rdg-search);position: absolute;left: 50%;top: 100%;transform: translateX(-50%);display: none;}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .nav-mobile-container .search-mobile .search-icon-mobile #search-connector-mobile.show {display: block;}}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .nav-mobile-container .nav-buttons {display: flex;align-items: center;justify-content: flex-end;gap: 1rem;}@media (max-width: 945px) {.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .nav-mobile-container .nav-buttons {gap: 0.5rem;}}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .nav-mobile-container .nav-buttons .search-container {display: inline-block;padding: 0 0 0 2rem;}@media (max-width: 768px) {.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .nav-mobile-container .nav-buttons .search-container {display: none;}}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .nav-mobile-container .nav-buttons .search-container .search-icon {width: 32px;height: 32px;background-color: var(--color-rdg-search);border-radius: 50%;display: flex;justify-content: center;align-items: center;cursor: pointer;position: relative;transition: border-radius 0.3s ease;}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .nav-mobile-container .nav-buttons .search-container .search-icon #search-connector {width: 32px;height: 32px;background-color: var(--color-rdg-search);position: absolute;left: 50%;top: 100%;transform: translateX(-50%);display: none;}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .nav-mobile-container .nav-buttons .search-container .search-icon #search-connector.show {display: block;}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .nav-mobile-container .nav-buttons .sign-up-btn, .rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .nav-mobile-container .nav-buttons .login-btn {padding: 12px 24px;border-radius: 4px;display: flex;align-items: center;justify-content: center;gap: 6px;font-size: 16px;font-weight: 700;line-height: normal;letter-spacing: 0.32px;}@media (max-width: 945px) {.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .nav-mobile-container .nav-buttons .sign-up-btn, .rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .nav-mobile-container .nav-buttons .login-btn {display: flex;position: relative;cursor: pointer;overflow: hidden;}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .nav-mobile-container .nav-buttons .sign-up-btn svg, .rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .nav-mobile-container .nav-buttons .login-btn svg{display: none;}}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .nav-mobile-container .nav-buttons .sign-up-btn {border: 1px solid var(--color-rdg-sign-up);transition: all ease 0.3s;}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .nav-mobile-container .nav-buttons .sign-up-btn:hover {background-color: var(--color-rdg-sign-up);}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .nav-mobile-container .nav-buttons .login-btn {border: 1px solid var(--color-rdg-login);transition: all ease 0.3s;}.rdg-blocks .rdg-sas-navbar .sas-navbar-container .navbar-container .primary-menu .nav-mobile-container .nav-buttons .login-btn:hover {background-color: var(--color-rdg-login);}
    </style>
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" >
        <!-- Navbar section -->
        <div class="sas-navbar-container <?php if ($full_container == 'fullwidth') { echo "full-width"; } ?>">
        <?php get_search_form(); ?>

            <!-- Navbar inner container -->
            <div class="navbar-container container content grid-container">
                <!-- Secondary Menu -->
                <div class="secondary-menu">
                    <?php if( have_rows('secondary_menu') ): ?>
                        <?php while( have_rows('secondary_menu') ): the_row(); 
                            $secondary_link = get_sub_field('secondary_link');
                            ?>
                            <?php if( $secondary_link ): 
                                $secondary_link_url = $secondary_link['url'];
                                $secondary_link_title = $secondary_link['title'];
                                $secondary_link_target = $secondary_link['target'] ? $secondary_link['target'] : '_self';
                                ?>
                                <a href="<?php echo esc_url( $secondary_link_url ); ?>" target="<?php echo esc_attr( $secondary_link_target ); ?>"><?php echo esc_html( $secondary_link_title ); ?></a>
                            <?php endif; ?>
                            
                        <?php endwhile; ?>
                    <?php endif;?>
                    
                    <?php if( have_rows('language') ): ?>
                        <?php while( have_rows('language') ): the_row(); 
                            $language_link = get_sub_field('language_link');
                            $language_flag = get_sub_field('language_flag');
                        ?>
                            <?php if( $language_link ): 
                                $language_link_url = $language_link['url'];
                                $language_link_title = $language_link['title'];
                                $language_link_target = $language_link['target'] ? $language_link['target'] : '_self';
                            ?>
                                
                                <a href="<?php echo esc_url( $language_link_url ); ?>" target="<?php echo esc_attr( $language_link_target ); ?>" class="lenguage-btn">
                                    <?php if( !empty( $language_flag ) ): ?>
                                        <img src="<?php echo esc_url($language_flag['url']); ?>" alt="<?php echo esc_attr($language_flag['alt']); ?>" />
                                    <?php endif; ?>
                                    <?php echo esc_html( $language_link_title ); ?>
                                </a>
                            <?php endif;?>
                        <?php endwhile; ?>
                    <?php endif;?>
                </div>

                <!-- Main Menu -->
                <div class="primary-menu">
                    <div class="top-container">
                        <!-- Site Logo -->
                        <div class="site-logo-wrapper">
                        <?php if( $site_logo_link ): 
                            $site_logo_link_url = $site_logo_link['url']; ?>

                            <a href="<?php echo esc_url( $site_logo_link_url ); ?>">
                            <?php if( !empty( $site_logo ) ): ?>
                                <img src="<?php echo esc_url($site_logo['url']); ?>" alt="<?php echo esc_attr($site_logo['alt']); ?>" />
                            <?php endif; ?>                         
                            </a>
                        <?php endif; ?>
                        </div>

                        <!-- Main Nav -->
                        <div class="primary-navigation">
                            <?php if( have_rows('main_menu') ): ?>
                                <div class="toggle-container">
                                    <span class="toggle-button" id="navbar-toggle">
                                        &#9776;
                                    </span>
                                    <span class="toggle-button-x" id="navbar-toggle-x">
                                        &#10005;
                                    </span>
                                </div>
                                <div class="navbar-links" id="navbar-links">
                                    <ul>
                                    <?php while( have_rows('main_menu') ): the_row(); 
                                        $menu_link = get_sub_field('menu_link');
                                    ?>
                                        <?php if( have_rows('submenu') ) { ?>
                                            
                                                <li class="nav-dropdown">

                                                <?php if( $menu_link ): 
                                                $menu_link_url = $menu_link['url'];
                                                $menu_link_title = $menu_link['title'];
                                                $menu_link_target = $menu_link['target'] ? $menu_link['target'] : '_self'; ?>

                                                    <div class="dropdown-wrapper">
                                                        <a class="dropbtn" href="<?php echo esc_url( $menu_link_url ); ?>" target="<?php echo esc_attr( $menu_link_target ); ?>">
                                                            <?php echo esc_html( $menu_link_title ); ?>
                                                        </a>
                                                        <img src="<?php echo plugins_url('assets/images/arrow-down-icon.svg', __FILE__); ?>" alt="arrow icon" class="dropdown">
                                                    </div>
                                                    
                                                <?php endif; ?>
                                                    <div class="dropdown-content">
                                                        <?php while( have_rows('submenu') ): the_row(); 
                                                            $submenu_link = get_sub_field('submenu_link');
                                                            $submenu_icon = get_sub_field('submenu_icon');
                                                            ?>
                                                                <?php if( $submenu_link ): 
                                                                    $submenu_link_url = $submenu_link['url'];
                                                                    $submenu_link_title = $submenu_link['title'];
                                                                    $submenu_link_target = $submenu_link['target'] ? $submenu_link['target'] : '_self'; ?>
                                                                    
                                                                    <a class="dropbtn submenu-icon" href="<?php echo esc_url( $submenu_link_url ); ?>" target="<?php echo esc_attr( $submenu_link_target ); ?>">
                                                                    <?php if ($submenu_icon == 'football') {?>
                                                                        <img src="<?php echo plugins_url('assets/images/football-icon.svg', __FILE__); ?>" alt="icon">
                                                                    <?php } else if ($submenu_icon == 'baseball') {?>
                                                                        <img src="<?php echo plugins_url('assets/images/baseball-icon.svg', __FILE__); ?>" alt="icon">
                                                                    <?php } else if ($submenu_icon == 'basketball') {?>
                                                                        <img src="<?php echo plugins_url('assets/images/basketball-icon.svg', __FILE__); ?>" alt="icon">
                                                                    <?php } else if ($submenu_icon == 'hockey') {?>
                                                                        <img src="<?php echo plugins_url('assets/images/hockey-icon.svg', __FILE__); ?>" alt="icon">
                                                                    <?php } else if ($submenu_icon == 'soccer') {?>
                                                                        <img src="<?php echo plugins_url('assets/images/soccer-icon.svg', __FILE__); ?>" alt="icon">
                                                                    <?php } ?>
                                                                    <?php echo esc_html( $submenu_link_title ); ?>
                                                                    </a>

                                                                <?php endif; ?>
                                                            <?php endwhile; ?>
                                                    </div>
                                                </li>
                                            <?php } else {?>
                                            
                                            <?php if( $menu_link ): 
                                                $menu_link_url = $menu_link['url'];
                                                $menu_link_title = $menu_link['title'];
                                                $menu_link_target = $menu_link['target'] ? $menu_link['target'] : '_self'; ?>

                                                <li>
                                                    <a href="<?php echo esc_url( $menu_link_url ); ?>" target="<?php echo esc_attr( $menu_link_target ); ?>">
                                                        <?php echo esc_html( $menu_link_title ); ?>
                                                    </a>
                                                </li>
                                            <?php endif; ?>
                                            <?php } ?>
                                            
                                    <?php endwhile; ?>
                                    </ul>
                                    <div class="secondary-menu-mobile">
                                        <?php if( have_rows('secondary_menu') ): ?>
                                            <?php while( have_rows('secondary_menu') ): the_row(); 
                                                $secondary_link = get_sub_field('secondary_link');
                                                ?>
                                                <?php if( $secondary_link ): 
                                                    $secondary_link_url = $secondary_link['url'];
                                                    $secondary_link_title = $secondary_link['title'];
                                                    $secondary_link_target = $secondary_link['target'] ? $secondary_link['target'] : '_self';
                                                    ?>
                                                    <a href="<?php echo esc_url( $secondary_link_url ); ?>" target="<?php echo esc_attr( $secondary_link_target ); ?>"><?php echo esc_html( $secondary_link_title ); ?></a>
                                                <?php endif; ?>
                                                
                                            <?php endwhile; ?>
                                        <?php endif;?>
                                        
                                        <?php if( have_rows('language') ): ?>
                                            <?php while( have_rows('language') ): the_row(); 
                                                $language_link = get_sub_field('language_link');
                                                $language_flag = get_sub_field('language_flag');
                                            ?>
                                                <?php if( $language_link ): 
                                                    $language_link_url = $language_link['url'];
                                                    $language_link_title = $language_link['title'];
                                                    $language_link_target = $language_link['target'] ? $language_link['target'] : '_self';
                                                ?>
                                                    
                                                    <a href="<?php echo esc_url( $language_link_url ); ?>" target="<?php echo esc_attr( $language_link_target ); ?>" class="lenguage-btn">
                                                        <?php if( !empty( $language_flag ) ): ?>
                                                            <img src="<?php echo esc_url($language_flag['url']); ?>" alt="<?php echo esc_attr($language_flag['alt']); ?>" />
                                                        <?php endif; ?>
                                                        <?php echo esc_html( $language_link_title ); ?>
                                                    </a>
                                                <?php endif;?>
                                            <?php endwhile; ?>
                                        <?php endif;?>
                                    </div>
                                </div>
                            <?php endif; ?>

                            
                            
                        </div>
                    </div>
                    <!-- Nav Buttons -->
                    <div class="nav-mobile-container">
                        <div class="search-mobile">
                            <div class="search-icon-mobile" onclick="toggleSearch()">
                                <span id="search-icon-mobile" class="icon">
                                    <img src="<?php echo plugins_url('assets/images/search-icon.svg', __FILE__); ?>" alt="search icon">
                                </span>
                                <div id="search-connector-mobile"></div>
                            </div>
                        </div>
                        <div class="nav-buttons">
                        <!-- Search -->
                            <div class="search-container">
                                <div class="search-icon" onclick="toggleSearch()">
                                    <span id="search-icon" class="icon">
                                        <img src="<?php echo plugins_url('assets/images/search-icon.svg', __FILE__); ?>" alt="search icon">
                                    </span>
                                    <div id="search-connector"></div>
                                </div>
                            </div>
                        <?php if( $login_link ): 
                                $login_link_url = $login_link['url'];
                                $login_link_title = $login_link['title'];
                                $login_link_target = $login_link['target'] ? $login_link['target'] : '_self'; ?>
                            <a href="<?php echo esc_url( $login_link_url ); ?>" class="login-btn" target="<?php echo esc_attr( $login_link_target ); ?>">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                                    <g clip-path="url(#clip0_713_6)">
                                    <path d="M0 8C0 8.368 0.298666 8.66667 0.666666 8.66667H10.024L7.862 10.8287C7.60133 11.0893 7.60133 11.5107 7.862 11.7713C7.992 11.9013 8.16267 11.9667 8.33333 11.9667C8.504 11.9667 8.67467 11.9013 8.80467 11.7713L11.6333 8.94267C12.1533 8.42267 12.1533 7.57733 11.6333 7.05733L8.80467 4.22867C8.544 3.968 8.12267 3.968 7.862 4.22867C7.60133 4.48933 7.60133 4.91067 7.862 5.17133L10.024 7.33333H0.666666C0.298666 7.33333 0 7.632 0 8ZM0.924 10.0453C1.268 9.91133 1.654 10.0813 1.78733 10.424C2.794 13.0013 5.232 14.6667 7.99933 14.6667C11.6753 14.6667 14.666 11.676 14.666 8C14.666 4.324 11.676 1.33333 8 1.33333C5.23267 1.33333 2.794 2.99867 1.788 5.576C1.654 5.91867 1.26933 6.088 0.924665 5.95467C0.581332 5.82067 0.412 5.434 0.546 5.09133C1.75333 1.99867 4.67933 0 8 0C12.4113 0 16 3.58867 16 8C16 12.4113 12.4113 16 8 16C4.67933 16 1.75333 14.0013 0.545334 10.9093C0.411333 10.566 0.580666 10.18 0.924 10.046V10.0453Z" fill="white"/>
                                    </g>
                                    <defs>
                                    <clipPath id="clip0_713_6">
                                        <rect width="16" height="16" fill="white" transform="matrix(-1 0 0 1 16 0)"/>
                                    </clipPath>
                                    </defs>
                                </svg>
                                <?php echo esc_html( $login_link_title ); ?>
                            </a>
                            <?php endif; ?>
                            <?php if( $sign_up_link ): 
                                $sign_up_link_url = $sign_up_link['url'];
                                $sign_up_link_title = $sign_up_link['title'];
                                $sign_up_link_target = $sign_up_link['target'] ? $sign_up_link['target'] : '_self'; ?>
                            <a href="<?php echo esc_url( $sign_up_link_url ); ?>" class="sign-up-btn" target="<?php echo esc_attr( $sign_up_link_target ); ?>">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                                    <g clip-path="url(#clip0_713_11)">
                                    <path d="M12.6667 1.33325H3.33333C1.49333 1.33325 0 2.82659 0 4.66659V11.3333C0 13.1733 1.49333 14.6666 3.33333 14.6666H8C8.36667 14.6666 8.66667 14.3666 8.66667 13.9999C8.66667 13.6333 8.36667 13.3333 8 13.3333H3.33333C2.23333 13.3333 1.33333 12.4333 1.33333 11.3333V5.99992H14.6667V9.33325C14.6667 9.69992 14.9667 9.99992 15.3333 9.99992C15.7 9.99992 16 9.69992 16 9.33325V4.66659C16 2.82659 14.5067 1.33325 12.6667 1.33325ZM1.33333 4.66659C1.33333 3.56659 2.23333 2.66659 3.33333 2.66659H12.6667C13.7667 2.66659 14.6667 3.56659 14.6667 4.66659H1.33333ZM10.94 8.11325C10.4333 7.60659 9.76667 7.33325 9.05333 7.33325H7.99333C7.62667 7.33325 7.32667 7.63325 7.32667 7.99992V9.05992C7.32667 9.77325 7.60667 10.4399 8.10667 10.9466L12.58 15.4199C12.96 15.7999 13.46 16.0066 13.9933 16.0066C14.5267 16.0066 15.0267 15.7999 15.4067 15.4199C15.7867 15.0399 15.9933 14.5399 15.9933 14.0066C15.9933 13.4733 15.7867 12.9733 15.4067 12.5933L10.9333 8.11992L10.94 8.11325ZM14.4667 14.4733C14.2133 14.7266 13.7733 14.7266 13.5267 14.4733L9.05333 9.99992C8.8 9.74659 8.66 9.41325 8.66 9.05992V8.66659H9.05333C9.40667 8.66659 9.74667 8.80659 9.99333 9.05992L14.4667 13.5333C14.5933 13.6599 14.66 13.8266 14.66 14.0066C14.66 14.1866 14.5933 14.3533 14.4667 14.4799V14.4733Z" fill="white"/>
                                    </g>
                                    <defs>
                                    <clipPath id="clip0_713_11">
                                        <rect width="16" height="16" fill="white"/>
                                    </clipPath>
                                    </defs>
                                </svg>
                                <?php echo esc_html( $sign_up_link_title ); ?>
                            </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    
        <script>
            document.getElementById("navbar-toggle").addEventListener("click", function () {
    this.classList.toggle("active");
    document.getElementById("navbar-toggle-x").classList.toggle("active");
    document.getElementById("navbar-links").classList.toggle("active");
});

document.getElementById("navbar-toggle-x").addEventListener("click", function () {
    this.classList.toggle("active");
    document.getElementById("navbar-toggle").classList.toggle("active");
    document.getElementById("navbar-links").classList.toggle("active");
});

document.addEventListener('DOMContentLoaded', function () {
    const dropdowns = document.querySelectorAll('.dropdown');

    function handleDropdownClick(e) {
        e.stopPropagation();

        this.classList.toggle('active');
        const dropdownWrapper = this.closest('.dropdown-wrapper');
        const dropdownContent = dropdownWrapper.nextElementSibling;

        if (this.classList.contains('active')) {
            dropdownContent.style.display = 'block';
        } else {
            dropdownContent.style.display = 'none';
        }
    }

    function closeDropdowns() {
        dropdowns.forEach(dropdown => {
            dropdown.classList.remove('active');
            const dropdownWrapper = dropdown.closest('.dropdown-wrapper');
            const dropdownContent = dropdownWrapper.nextElementSibling;
            dropdownContent.style.display = 'none';
        });
    }

    function initDropdownBehavior() {
        const isDesktop = window.matchMedia("(min-width: 769px)").matches;

        // Limpiar eventos previos para evitar duplicaciones
        dropdowns.forEach(dropdown => {
            dropdown.removeEventListener('click', handleDropdownClick);
        });
        document.removeEventListener('click', closeDropdowns);

        if (!isDesktop) {
            // En mobile, usar clic para abrir y cerrar
            dropdowns.forEach(dropdown => {
                dropdown.addEventListener('click', handleDropdownClick);
            });

            // Cerrar el dropdown al hacer clic fuera de él solo en mobile
            document.addEventListener('click', closeDropdowns);
        }
    }

    // Ejecutar la función inicialmente y cada vez que cambie el tamaño de la pantalla
    initDropdownBehavior();
    window.addEventListener('resize', initDropdownBehavior);
});

// Search
function toggleSearch() {
    // Desktop
    const searchForm = document.getElementById('search-form');
    const searchIcon = document.querySelector('.search-icon');
    const searchConnector = document.getElementById('search-connector');

    // Mobile
    const searchIconMobile = document.querySelector('.search-icon-mobile');
    const searchConnectorMobile = document.getElementById('search-connector-mobile');

    if (searchForm.classList.contains('expanded')) {
        searchForm.classList.remove('expanded');
        searchIcon.style.borderBottomLeftRadius = '50%';
        searchIcon.style.borderBottomRightRadius = '50%';
        searchConnector.classList.remove('show');
        // Mobile
        searchIconMobile.style.borderBottomLeftRadius = '50%';
        searchIconMobile.style.borderBottomRightRadius = '50%';
        searchConnectorMobile.classList.remove('show');
    } else {
        searchForm.classList.add('expanded');
        searchConnector.classList.add('show');
        searchIcon.style.borderBottomLeftRadius = '0';
        searchIcon.style.borderBottomRightRadius = '0';
        // Mobile
        searchIconMobile.style.borderBottomLeftRadius = '0';
        searchIconMobile.style.borderBottomRightRadius = '0';
        searchConnectorMobile.classList.add('show');
    }
}
        </script>
    
    </div>
</div>
